/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.climate.EnumSeason;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.base.DCSimpleBlock;
import defeatedcrow.hac.core.util.DCTimeHelper;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.food.block.TileAgingBarrel;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.block.build.TileDisplayShelf;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.recipes.BlockContainerUtil;
import defeatedcrow.hac.main.util.LootTablesDC;
import defeatedcrow.hac.main.worldgen.CaravanGenPos;
import defeatedcrow.hac.main.worldgen.WorldGenCaravanBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CaravanGenEvent {
    Random rand = new Random();

    @SubscribeEvent
    public void populate(PopulateChunkEvent.Post event) {
        if (!ModuleConfig.world) {
            return;
        }
        if (event.getWorld().field_73011_w.getDimension() == 0 && !event.isHasVillageGenerated() && CaravanGenPos.isSuitableChunk(event.getChunkX(), event.getChunkZ(), event.getWorld()) && CaravanGenPos.getCaravanPartNum(event.getChunkX(), event.getChunkZ(), event.getWorld()) > -1) {
            WorldGenCaravanBase wgn = new WorldGenCaravanBase();
            wgn.generate(event.getRand(), event.getChunkX(), event.getChunkZ(), event.getWorld(), event.getGen(), event.getWorld().func_72863_F());
        }
    }

    @SubscribeEvent
    public void onLoad(ChunkEvent.Load event) {
        if (event.getWorld().field_73011_w.getDimension() == 0 && event.getChunk().func_177419_t() && !event.getWorld().field_72995_K) {
            World world = event.getWorld();
            Chunk chunk = event.getChunk();
            int cx = chunk.field_76635_g;
            int cz = chunk.field_76647_h;
            int num = CaravanGenPos.getCaravanPartNum(cx, cz, world);
            if (num < 0) {
                return;
            }
            int nx = num % 3 - 1;
            int nz = num / 3 - 1;
            int cx2 = cx + nx;
            int cz2 = cz + nz;
            int height = CaravanGenPos.getCoreHeight(cx2, cz2, world);
            int px = cx << 4;
            int pz = cz << 4;
            int py = height;
            BlockPos pos = new BlockPos(px, py, pz);
            EnumSeason season = DCTimeHelper.getSeasonEnum((World)world);
            IBlockState s1 = world.func_180495_p(pos.func_177982_a(8, -7, 8));
            IBlockState s2 = world.func_180495_p(pos.func_177982_a(7, -7, 7));
            IBlockState s3 = world.func_180495_p(pos.func_177982_a(8, -4, 8));
            IBlockState s4 = world.func_180495_p(pos.func_177982_a(7, -4, 7));
            CaravanType type = CaravanType.getType(s2.func_177230_c());
            if (type == CaravanType.BROKEN) {
                type = CaravanType.getType(s4.func_177230_c());
            }
            if (this.getSeason(s1) != null && type != CaravanType.BROKEN) {
                if (type == CaravanType.STANDBY || type == CaravanType.UNINIT) {
                    if (num == 4) {
                        if (ModuleConfig.village) {
                            Village village = world.func_175714_ae().func_176056_a(pos.func_177982_a(7, 0, 7), 16);
                            if (village == null || village.func_75562_e() < 10) {
                                ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS;
                                int id = registry.getID((IForgeRegistryEntry)MainInit.trader);
                                EntityVillager vil1 = new EntityVillager(world, id);
                                vil1.func_70107_b((double)px, (double)(py + 1), (double)pz);
                                world.func_72838_d((Entity)vil1);
                                EntityVillager vil2 = new EntityVillager(world, id);
                                vil2.func_70107_b((double)px + 1.0, (double)(py + 1), (double)pz);
                                world.func_72838_d((Entity)vil2);
                                EntityLlama lla = new EntityLlama(world);
                                lla.func_70107_b((double)px + 3.0, (double)(py + 1), (double)pz);
                                world.func_72838_d((Entity)lla);
                            } else {
                                List list = world.func_175674_a(null, new AxisAlignedBB(pos.func_177982_a(-5, 0, -5), pos.func_177982_a(20, 1, 20)), EntitySelectors.field_94557_a);
                                EntityVillager vil1 = null;
                                EntityVillager vil2 = null;
                                for (Entity e : list) {
                                    if (!(e instanceof EntityVillager)) continue;
                                    if (vil1 == null) {
                                        vil1 = (EntityVillager)e;
                                        continue;
                                    }
                                    if (vil2 != null) break;
                                    vil2 = (EntityVillager)e;
                                }
                                if (vil1 != null) {
                                    vil1.func_70106_y();
                                }
                                if (vil2 != null) {
                                    vil2.func_70106_y();
                                }
                            }
                        }
                    } else {
                        int[] room = CaravanGenPos.getRoomNum(cx + nx, cz + nz, world);
                        int gate = room[0] * 2 + 1;
                        EnumFacing face = EnumFacing.SOUTH;
                        if (num == 7) {
                            face = EnumFacing.NORTH;
                        }
                        if (num == 3) {
                            face = EnumFacing.EAST;
                        }
                        if (num == 5) {
                            face = EnumFacing.WEST;
                        }
                        int t = num / 2;
                        if ((num & 1) == 1 && num != gate) {
                            switch (room[t]) {
                                case 1: {
                                    this.updateInterior0(world, pos, this.rand, face);
                                    break;
                                }
                                case 2: {
                                    this.updateInterior2(world, pos, this.rand, face);
                                    break;
                                }
                                case 3: {
                                    this.updateInterior1(world, pos, this.rand, face);
                                    break;
                                }
                            }
                        }
                    }
                    DCLogger.debugInfoLog((String)("Caravanserai Updated: " + cx + ", " + cz + " height" + py));
                    world.func_180501_a(pos.func_177982_a(7, -7, 7), Blocks.field_150484_ah.func_176223_P(), 2);
                } else if (this.getSeason(s1) != season) {
                    Village village = null;
                    List villages = world.func_175714_ae().func_75540_b();
                    for (Village v : villages) {
                        if (!(v.func_180608_a().func_177951_i((Vec3i)pos.func_177982_a(7, 0, 7)) < 1024.0)) continue;
                        village = v;
                        break;
                    }
                    if (village != null || !ModuleConfig.village) {
                        DCLogger.debugInfoLog((String)("Caravanserai Stand-By: " + cx + ", " + cz + " height" + py));
                        world.func_180501_a(pos.func_177982_a(7, -7, 7), Blocks.field_150475_bE.func_176223_P(), 2);
                    } else {
                        DCLogger.debugInfoLog((String)("Broken Caravanserai: " + cx + ", " + cz));
                        world.func_180501_a(pos.func_177982_a(7, -7, 7), Blocks.field_150368_y.func_176223_P(), 2);
                    }
                    world.func_180501_a(pos.func_177982_a(8, -7, 8), MainInit.gemBlock.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(season.id)), 2);
                }
            } else if (type == CaravanType.BROKEN && (world.func_180495_p(pos.func_177982_a(7, -7, 7)).func_177230_c() == Blocks.field_150368_y || world.func_180495_p(pos.func_177982_a(7, -4, 7)).func_177230_c() == Blocks.field_150368_y)) {
                Village village = null;
                List villages = world.func_175714_ae().func_75540_b();
                for (Village v : villages) {
                    if (!(v.func_180608_a().func_177951_i((Vec3i)pos.func_177982_a(7, 0, 7)) < 1024.0)) continue;
                    village = v;
                    break;
                }
                if (village != null || !ModuleConfig.village) {
                    DCLogger.debugInfoLog((String)("Caravanserai Reconstructed: " + cx + ", " + cz + " height" + py));
                    world.func_180501_a(pos.func_177982_a(7, -7, 7), Blocks.field_150475_bE.func_176223_P(), 2);
                }
                world.func_180501_a(pos.func_177982_a(8, -7, 8), MainInit.gemBlock.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(season.id)), 2);
            }
        }
    }

    private void updateInterior0(World world, BlockPos pos, Random rand, EnumFacing face) {
        int[] i;
        for (int x : i = new int[]{0, 3, 7, 11, 14}) {
            BlockPos p1 = this.rotate(pos, x, 1, 8, face);
            BlockPos p2 = this.rotate(pos, x + 1, 1, 8, face);
            IBlockState cont = BlockContainerUtil.getRondomContainer2(rand);
            world.func_180501_a(p1, cont, 2);
            world.func_180501_a(p2, cont, 2);
            if (rand.nextBoolean()) {
                world.func_180501_a(p1.func_177984_a(), cont, 2);
            }
            if (rand.nextBoolean()) {
                world.func_180501_a(p2.func_177984_a(), cont, 2);
            }
            if (!rand.nextBoolean()) continue;
            BlockPos p3 = this.rotate(pos, x, 1, 7, face);
            world.func_180501_a(p3, cont, 2);
        }
    }

    private void updateInterior1(World world, BlockPos pos, Random rand, EnumFacing face) {
        BlockPos p2;
        TileEntity tile2;
        BlockPos p1 = this.rotate(pos, 0, 1, 9, face);
        TileEntity tile1 = world.func_175625_s(p1);
        if (tile1 != null && tile1 instanceof TileEntityChest) {
            ((TileEntityChest)tile1).func_189404_a(LootTableList.field_186424_f, rand.nextLong());
            ((TileEntityChest)tile1).func_184281_d(null);
        }
        if ((tile2 = world.func_175625_s(p2 = this.rotate(pos, 15, 1, 9, face))) != null && tile2 instanceof TileEntityChest) {
            ((TileEntityChest)tile2).func_189404_a(LootTableList.field_186423_e, rand.nextLong());
            ((TileEntityChest)tile2).func_184281_d(null);
        }
        for (int x = 5; x < 11; ++x) {
            BlockPos p4;
            BlockPos p3 = this.rotate(pos, x, 1, 9, face);
            IBlockState cont = BlockContainerUtil.getRondomContainer1(rand);
            world.func_180501_a(p3, cont, 2);
            if (rand.nextBoolean()) {
                p4 = this.rotate(pos, x, 2, 9, face);
                world.func_180501_a(p4, cont, 2);
            }
            if (!rand.nextBoolean()) continue;
            p4 = this.rotate(pos, x, 1, 8, face);
            IBlockState cont2 = BlockContainerUtil.getRondomContainer1(rand);
            world.func_180501_a(p4, cont2, 2);
        }
    }

    private void updateInterior2(World world, BlockPos pos, Random rand, EnumFacing face) {
        if (ModuleConfig.food) {
            if (ModuleConfig.liquor && ModuleConfig.food_advanced) {
                BlockPos p3;
                if (ModuleConfig.build_advanced) {
                    for (int x = 6; x < 10; ++x) {
                        TileEntity tile;
                        ArrayList list = Lists.newArrayList();
                        this.getLiquorList(list, rand);
                        BlockPos p = this.rotate(pos, x, 3, 9, face);
                        if (world.func_175623_d(p)) {
                            IBlockState shelf = MainInit.displayShelf.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
                            world.func_180501_a(p, shelf, 2);
                        }
                        if ((tile = world.func_175625_s(p)) == null || !(tile instanceof TileDisplayShelf)) continue;
                        for (int i = 0; i < 3; ++i) {
                            if (list.size() <= i || DCUtil.isEmpty((ItemStack)((ItemStack)list.get(i)))) continue;
                            ((TileDisplayShelf)tile).func_70299_a(i, (ItemStack)list.get(i));
                        }
                    }
                }
                BlockPos p1 = this.rotate(pos, -2, 1, 8, face);
                IBlockState barrel = FoodInit.barrel.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176746_e());
                if (world.func_175623_d(p1)) {
                    world.func_180501_a(p1, barrel, 2);
                }
                if (rand.nextBoolean()) {
                    Fluid f = this.getFluid(rand.nextInt(8));
                    TileEntity te = world.func_175625_s(p1);
                    if (f != null && te instanceof TileAgingBarrel) {
                        ((TileAgingBarrel)te).inputT.setFluid(new FluidStack(f, 2000));
                    }
                }
                BlockPos p2 = this.rotate(pos, -2, 1, 9, face);
                world.func_180501_a(p2, barrel, 2);
                if (world.func_175623_d(p2) && rand.nextBoolean()) {
                    Fluid f = this.getFluid(rand.nextInt(8));
                    TileEntity te = world.func_175625_s(p2);
                    if (f != null && te instanceof TileAgingBarrel) {
                        ((TileAgingBarrel)te).inputT.setFluid(new FluidStack(f, 2000));
                    }
                }
                if (world.func_175623_d(p3 = this.rotate(pos, 17, 1, 8, face))) {
                    world.func_180501_a(p3, barrel, 2);
                }
                if (rand.nextBoolean()) {
                    Fluid f = this.getFluid(rand.nextInt(8));
                    TileEntity te = world.func_175625_s(p3);
                    if (f != null && te instanceof TileAgingBarrel) {
                        ((TileAgingBarrel)te).inputT.setFluid(new FluidStack(f, 2000));
                    }
                }
                BlockPos p4 = this.rotate(pos, 17, 1, 9, face);
                world.func_180501_a(p4, barrel, 2);
                if (rand.nextBoolean()) {
                    Fluid f = this.getFluid(rand.nextInt(8));
                    TileEntity te = world.func_175625_s(p4);
                    if (f != null && te instanceof TileAgingBarrel) {
                        ((TileAgingBarrel)te).inputT.setFluid(new FluidStack(f, 2000));
                    }
                }
            }
            BlockPos p5 = this.rotate(pos, -2, 1, 7, face);
            IBlockState chest = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)face.func_176734_d());
            world.func_180501_a(p5, chest, 2);
            TileEntity tile = world.func_175625_s(p5);
            if (tile != null && tile instanceof TileEntityChest) {
                ((TileEntityChest)tile).func_189404_a(LootTablesDC.CARAVAN_CHEST_LOOT, rand.nextLong());
            }
        }
    }

    private BlockPos rotate(BlockPos pos, int x, int y, int z, EnumFacing face) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        if (face == EnumFacing.NORTH) {
            x1 = 15 - x;
            z1 = 15 - z;
        }
        if (face == EnumFacing.EAST) {
            x1 = z;
            z1 = 15 - x;
        }
        if (face == EnumFacing.WEST) {
            x1 = 15 - z;
            z1 = x;
        }
        return pos.func_177982_a(x1, y1, z1);
    }

    public EnumSeason getSeason(IBlockState block) {
        if (block.func_177230_c() instanceof DCSimpleBlock) {
            int v = (Integer)block.func_177229_b((IProperty)DCState.TYPE16);
            for (EnumSeason s : EnumSeason.values()) {
                if (s.id != v) continue;
                return s;
            }
        }
        return null;
    }

    private List<ItemStack> getLiquorList(List<ItemStack> list, Random rand) {
        for (int i = 0; i < 3; ++i) {
            int m;
            if (rand.nextFloat() > 0.85f) {
                m = rand.nextInt(17);
                if (m == 0) {
                    list.add(new ItemStack(FoodInit.roseWaterBottle, 1, 0));
                    continue;
                }
                list.add(new ItemStack(FoodInit.liquorBottle, 1, m));
                continue;
            }
            if (!(rand.nextFloat() > 0.6f)) continue;
            m = rand.nextInt(5);
            if (m == 0) {
                list.add(new ItemStack(FoodInit.roseWaterBottle, 1, 0));
                continue;
            }
            list.add(new ItemStack(FoodInit.liquorBottle, 1, m));
        }
        return list;
    }

    private Fluid getFluid(int i) {
        switch (i) {
            case 0: {
                return FoodInit.roseWater;
            }
            case 1: {
                return FoodInit.beer;
            }
            case 2: {
                return FoodInit.wine;
            }
            case 3: {
                return FoodInit.dateWine;
            }
            case 4: {
                return FoodInit.araq;
            }
        }
        return null;
    }

    public static enum CaravanType {
        UNINIT,
        STANDBY,
        LOADED,
        BROKEN;


        public static CaravanType getType(Block block) {
            if (block == Blocks.field_150339_S) {
                return UNINIT;
            }
            if (block == Blocks.field_150484_ah) {
                return LOADED;
            }
            if (block == Blocks.field_150475_bE) {
                return STANDBY;
            }
            return BROKEN;
        }
    }
}

