/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen;

import defeatedcrow.hac.core.util.BiomeCatchDC;
import defeatedcrow.hac.main.config.WorldGenConfig;
import defeatedcrow.hac.main.worldgen.CaravanGenEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;

public class CaravanGenPos {
    public static Chunk chunk = null;

    public static int isDupe(int cx, int cz, World world) {
        int count = 0;
        for (int x = -8; x < 9; ++x) {
            for (int z = -8; z < 9; ++z) {
                if (x == 0 && z == 0 || !CaravanGenPos.canGeneratePos(cx + x, cz + z, world)) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean isAlreadyHasCaravan(int cx, int cz, World world) {
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (x == 0 && z == 0 || !CaravanGenPos.canGeneratePos(cx + x, cz + z, world)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getCaravanPartNum(int cx, int cz, World world) {
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                if (!CaravanGenPos.canGeneratePos(cx + x - 1, cz + z - 1, world)) continue;
                return x + z * 3;
            }
        }
        return -1;
    }

    public static int getCoreHeight(int cx, int cz, World world) {
        BlockPos p1;
        int y;
        int px = cx << 4;
        int pz = cz << 4;
        int h = -1;
        for (y = 30; y < 100; ++y) {
            p1 = new BlockPos(px + 7, y, pz + 7);
            if (CaravanGenPos.getType(world, p1) == CaravanGenEvent.CaravanType.BROKEN) continue;
            h = y + 7;
            return h;
        }
        for (y = 40; y < 100; ++y) {
            p1 = new BlockPos(px + 7, y, pz + 7);
            if (CaravanGenPos.isReplaceable(world, p1) || !CaravanGenPos.isReplaceable(world, p1.func_177984_a())) continue;
            h = y;
        }
        return h;
    }

    public static boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a().func_76224_d()) {
            return false;
        }
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_185904_a().func_76222_j() || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151575_d;
    }

    public static boolean isSuitableChunk(int cx, int cz, World world) {
        if (world.field_72995_K) {
            return false;
        }
        int genDim1 = world.field_73011_w.getDimension();
        if (genDim1 != 0) {
            return false;
        }
        if (cx > 2000 || cz > 2000) {
            return false;
        }
        return cx >= -2000 && cz >= -2000;
    }

    public static boolean canGeneratePos(int cx, int cz, World world) {
        long seed = world.func_72905_C() + (long)(cx * 31) + (long)(cz * 131);
        Random rand = new Random(seed);
        rand.nextFloat();
        rand.nextFloat();
        float r = rand.nextFloat() * 10000.0f;
        int ri = MathHelper.func_76141_d((float)r);
        return ri > 0 && ri < WorldGenConfig.caravanGen;
    }

    public static int[] getRoomNum(int cx, int cz, World world) {
        long seed = world.func_72905_C() + (long)(cx * 31) + (long)(cz * 131);
        Random rand = new Random(seed);
        rand.nextInt(4);
        rand.nextInt(4);
        int[] r = new int[]{rand.nextInt(4), rand.nextInt(4), rand.nextInt(4), rand.nextInt(4)};
        return r;
    }

    public static boolean canGenerateBiome(int cx, int cz, World world) {
        if (world != null) {
            int px = cx << 4;
            int pz = cz << 4;
            Biome biome = BiomeCatchDC.getBiome((BlockPos)new BlockPos(px += 8, 1, pz += 8), (World)world);
            if (biome != null) {
                boolean b1 = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA);
                boolean b2 = !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
                return b1 && b2;
            }
        }
        return false;
    }

    public static CaravanGenEvent.CaravanType getType(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state != null) {
            Block block = state.func_177230_c();
            if (block == Blocks.field_150339_S) {
                return CaravanGenEvent.CaravanType.UNINIT;
            }
            if (block == Blocks.field_150484_ah) {
                return CaravanGenEvent.CaravanType.LOADED;
            }
            if (block == Blocks.field_150475_bE) {
                return CaravanGenEvent.CaravanType.STANDBY;
            }
            return CaravanGenEvent.CaravanType.BROKEN;
        }
        return CaravanGenEvent.CaravanType.BROKEN;
    }
}

