/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.block.build.BlockSlabBase;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.worldgen.CaravanGenPos;
import java.util.Random;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCaravanBase
implements IWorldGenerator {
    public void generate(Random rand, int cx, int cz, World world, IChunkGenerator gen, IChunkProvider prov) {
        int genDim1 = world.field_73011_w.getDimension();
        if (genDim1 != 0) {
            return;
        }
        int num = CaravanGenPos.getCaravanPartNum(cx, cz, world);
        if (num > -1) {
            int height;
            int nx = num % 3 - 1;
            int nz = num / 3 - 1;
            int cx2 = cx + nx;
            int cz2 = cz + nz;
            boolean check = CaravanGenPos.canGenerateBiome(cx2, cz2, world);
            int check2 = CaravanGenPos.isDupe(cx2, cz2, world);
            if (check && check2 == 0 && (height = CaravanGenPos.getCoreHeight(cx2, cz2, world)) > 40 && height < 100) {
                if (num == 4) {
                    this.generateCore(rand, cx, cz, height, world);
                    CaravanGenPos.chunk = prov.func_186026_b(cx, cz);
                } else {
                    this.generatePart(num, rand, cx, cz, height, world);
                }
                if (cx == cx2 && cz == cz2) {
                    DCLogger.debugInfoLog((String)("Caravanserai Core : " + cx2 + ", " + cz2 + " height " + height));
                }
            }
        }
    }

    public void generateCore(Random rand, int cx, int cz, int h, World world) {
        int px = cx << 4;
        int pz = cz << 4;
        int py = h;
        for (int y = -7; y < 40; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos pos = new BlockPos(px + x, py + y, pz + z);
                    IBlockState set = this.getCoreState(x, y, z, rand);
                    world.func_180501_a(pos, set, 2);
                }
            }
        }
    }

    public void generatePart(int num, Random rand, int cx, int cz, int h, World world) {
        int z1;
        BlockPos pos;
        int z;
        int x;
        int y;
        int px = cx << 4;
        int pz = cz << 4;
        int py = h;
        int minX = 0;
        int minZ = 0;
        int maxX = 16;
        int maxZ = 16;
        int nx = num % 3 - 1;
        int nz = num / 3 - 1;
        int cx2 = cx + nx;
        int cz2 = cz + nz;
        int[] type = CaravanGenPos.getRoomNum(cx2, cz2, world);
        int gate = type[0] * 2 + 1;
        int minX2 = 0;
        int minZ2 = 0;
        int maxX2 = 16;
        int maxZ2 = 16;
        EnumFacing face = EnumFacing.SOUTH;
        if (num == 7) {
            face = EnumFacing.NORTH;
        }
        if (num == 3) {
            face = EnumFacing.EAST;
        }
        if (num == 5) {
            face = EnumFacing.WEST;
        }
        if (nx == -1) {
            maxX = 13;
            maxX2 = 15;
        }
        if (nx == 1) {
            minX = 3;
            minX2 = 1;
        }
        if (nz == -1) {
            maxZ = 13;
            maxZ2 = 15;
        }
        if (nz == 1) {
            minZ = 3;
            minZ2 = 1;
        }
        for (y = -10; y < 40; ++y) {
            for (x = minX2; x < maxX2; ++x) {
                for (z = minZ2; z < maxZ2; ++z) {
                    pos = new BlockPos(px + x, py + y, pz + z);
                    IBlockState set = this.getPartBase(num, x, y, z, rand);
                    if (x >= minX && x < maxX && z >= minZ && z < maxZ) {
                        world.func_180501_a(pos, set, 2);
                        continue;
                    }
                    if (y <= 0) continue;
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
        for (y = 0; y < 15; ++y) {
            for (x = minX; x < maxX; ++x) {
                for (z = minZ; z < maxZ; ++z) {
                    IBlockState set;
                    pos = new BlockPos(px + x, py + y, pz + z);
                    int x1 = x;
                    z1 = z;
                    if (num == 7) {
                        x1 = 15 - x;
                        z1 = 15 - z;
                    }
                    if (num == 3) {
                        x1 = 15 - z;
                        z1 = x;
                    }
                    if (num == 5) {
                        x1 = z;
                        z1 = 15 - x;
                    }
                    if ((set = num == gate ? this.getGate(num, x1, y, z1, rand) : ((num & 1) == 0 ? this.getCornerRoom(num, x, y, z, rand) : this.getSmallRoom(num, x1, y, z1, rand))) == null || set.func_177230_c() == Blocks.field_150350_a) continue;
                    world.func_180501_a(pos, set, 2);
                }
            }
        }
        int t = num / 2;
        if ((num & 1) == 1 && num != gate) {
            for (int y2 = 0; y2 < 15; ++y2) {
                for (int x2 = minX; x2 < maxX; ++x2) {
                    for (int z2 = minZ; z2 < maxZ; ++z2) {
                        IBlockState set;
                        int x1 = x2;
                        z1 = z2;
                        if (num == 7) {
                            x1 = 15 - x2;
                            z1 = 15 - z2;
                        }
                        if (num == 3) {
                            x1 = 15 - z2;
                            z1 = x2;
                        }
                        if (num == 5) {
                            x1 = z2;
                            z1 = 15 - x2;
                        }
                        BlockPos pos2 = new BlockPos(px + x2, py + y2, pz + z2);
                        switch (type[t]) {
                            case 0: {
                                set = this.getInterior0(num, x1, y2, z1, rand, face);
                                break;
                            }
                            case 1: {
                                set = this.getInterior1(num, x1, y2, z1, rand, face);
                                break;
                            }
                            case 2: {
                                set = this.getInterior2(num, x1, y2, z1, rand, face);
                                break;
                            }
                            case 3: {
                                set = this.getInterior3(num, x1, y2, z1, rand, face);
                                break;
                            }
                            default: {
                                set = this.getInterior0(num, x1, y2, z1, rand, face);
                            }
                        }
                        if (set == null || set.func_177230_c() == Blocks.field_150350_a) continue;
                        world.func_180501_a(pos2, set, 2);
                    }
                }
            }
        }
    }

    private IBlockState getCoreState(int x, int y, int z, Random rand) {
        if (y < -3) {
            if (x == 7 && z == 7 && y == -7) {
                return Blocks.field_150339_S.func_176223_P();
            }
            if (x == 8 && z == 8 && y == -7) {
                return MainInit.gemBlock.func_176223_P();
            }
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        if (y == -3) {
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        if (y < 0) {
            if (x > 4 && x < 11 && z > 4 && z < 11) {
                if (x == 5 || x == 10 || z == 5 || z == 10) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                return Blocks.field_150355_j.func_176223_P();
            }
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        if (y == 0) {
            if (x > 4 && x < 11 && z > 4 && z < 11) {
                if (x == 5 || x == 10 || z == 5 || z == 10) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                return Blocks.field_150355_j.func_176223_P();
            }
            if (x > 2 && x < 13 && z > 2 && z < 13) {
                return Blocks.field_150349_c.func_176223_P();
            }
            if (x > 1 && x < 14 && z > 1 && z < 14) {
                return Blocks.field_150355_j.func_176223_P();
            }
            if (x > 0 && x < 15 && z > 0 && z < 15) {
                return Blocks.field_150349_c.func_176223_P();
            }
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(10));
        }
        if (y == 1) {
            if (x > 4 && x < 11 && z > 4 && z < 11) {
                if (x == 5 && z == 5) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (x == 5 && z == 10) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (x == 10 && z == 5) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (x == 10 && z == 10) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (x == 5) {
                    return MainInit.stairsDirtbrick.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.WEST);
                }
                if (x == 10) {
                    return MainInit.stairsDirtbrick.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.EAST);
                }
                if (z == 5) {
                    return MainInit.stairsDirtbrick.func_176223_P();
                }
                if (z == 10) {
                    return MainInit.stairsDirtbrick.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.SOUTH);
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            if (x > 3 && x < 12 && z > 3 && z < 12) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (y < 4) {
            if (x == 5 && z == 5) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if (x == 5 && z == 10) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if (x == 10 && z == 5) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if (x == 10 && z == 10) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (y == 4) {
            if (x > 3 && x < 12 && z > 3 && z < 12) {
                if (x > 4 && x < 11 && z > 4 && z < 11) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getPartBase(int num, int x, int y, int z, Random rand) {
        if (y < 0) {
            if (x == 7 && z == 7 && y == -7) {
                return Blocks.field_150339_S.func_176223_P();
            }
            if (x == 8 && z == 8 && y == -7) {
                return MainInit.gemBlock.func_176223_P();
            }
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getCornerRoom(int num, int x, int y, int z, Random rand) {
        int cx2 = num % 3 - 1;
        int cz2 = num / 3 - 1;
        if (cx2 == 1) {
            x = 15 - x;
        }
        if (cz2 == 1) {
            z = 15 - z;
        }
        if (x == 3 && z == 2 && y == 1) {
            IBlockState door = Blocks.field_180413_ao.func_176223_P();
            if (cz2 == -1) {
                door = door.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.SOUTH);
            }
            return door;
        }
        if (x == 3 && z == 2 && y == 2) {
            IBlockState door = Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            if (cz2 == -1) {
                door = door.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.SOUTH);
            }
            return door;
        }
        if (x == 8 && z == 8 && y == 5) {
            return ModuleConfig.build_advanced ? MainInit.chain.func_176223_P() : Blocks.field_180405_aT.func_176223_P();
        }
        if (x == 8 && z == 8 && y == 4) {
            return ModuleConfig.build_advanced ? MainInit.chandelierGypsum.func_176223_P() : MainInit.chalLamp.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(2));
        }
        if (x == 5 && z == 3 && y == 1) {
            return MainInit.chalLamp.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(9));
        }
        if (y == 0) {
            if (x > 3 && x < 12 && z > 3 && z < 12) {
                return ModuleConfig.build_advanced ? MainInit.carpetRed.func_176223_P() : Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED);
            }
            if (x < 11 && z < 11) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(10));
            }
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        if (x > 1 && x < 13 && z > 1 && z < 13) {
            if (x == 2 || x == 12 || z == 2 || z == 12) {
                if (y < 3) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (y == 3) {
                    if (rand.nextBoolean()) {
                        return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                    }
                    return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
                }
                if (y < 8) {
                    return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
                }
                if (y == 8) {
                    return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
                }
            }
            if (x > 2 && x < 12 && z > 2 && z < 12) {
                if (y == 6) {
                    return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
                }
                if (y == 7) {
                    return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
                }
            }
        }
        if (x < 2 && z == 5 || x < 2 && z == 10 || x == 5 && z < 2 || x == 10 && z < 2) {
            if (y < 3) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if (y == 3) {
                if (rand.nextBoolean()) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y < 6) {
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y == 6) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
        }
        if (x < 2 && z > 5 && z < 10) {
            if (y == 5) {
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y == 6) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
        }
        if (z < 2 && x > 5 && x < 10) {
            if (y == 5) {
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y == 6) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
        }
        if (x < 2 && z == 4 && y == 5) {
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        if (z < 2 && x == 4 && y == 5) {
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getSmallRoom(int num, int x, int y, int z, Random rand) {
        int cx2 = num % 3 - 1;
        int cz2 = num / 3 - 1;
        EnumFacing face = EnumFacing.SOUTH;
        int x1 = x;
        int z1 = z;
        if (num == 7) {
            face = EnumFacing.NORTH;
        }
        if (num == 3) {
            face = EnumFacing.EAST;
        }
        if (num == 5) {
            face = EnumFacing.WEST;
        }
        if (y == 0) {
            if (z1 < 11) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(10));
            }
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        if (z1 == 4) {
            if (y < 4) {
                switch (x1) {
                    case 0: 
                    case 5: 
                    case 10: 
                    case 15: {
                        return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                    }
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            if (y == 4) {
                switch (x1) {
                    case 2: 
                    case 3: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 13: {
                        return Blocks.field_150350_a.func_176223_P();
                    }
                }
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if (y == 5) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (z1 == 5 || z1 == 10) {
            if (y < 3) {
                if (z1 == 5) {
                    switch (x1) {
                        case 2: 
                        case 3: 
                        case 7: 
                        case 8: 
                        case 12: 
                        case 13: {
                            return Blocks.field_150350_a.func_176223_P();
                        }
                    }
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if (y == 3) {
                if (rand.nextBoolean()) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y < 6) {
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y == 6) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
        }
        if (z1 > 5 && z1 < 10) {
            if (y == 5) {
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y == 6) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getGate(int num, int x, int y, int z, Random rand) {
        int cx2 = num % 3 - 1;
        int cz2 = num / 3 - 1;
        int x1 = x;
        int z1 = z;
        EnumFacing face = EnumFacing.SOUTH;
        if (num == 7) {
            face = EnumFacing.NORTH;
        }
        if (num == 3) {
            face = EnumFacing.EAST;
        }
        if (num == 5) {
            face = EnumFacing.WEST;
        }
        if (y == 0) {
            if (z1 < 11) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(10));
            }
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        if (x1 == 3 && z1 == 4 && y < 3) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (x1 == 12 && z1 == 4 && y < 3) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (x1 == 6 && z1 == 4 && y < 5) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (x1 == 9 && z1 == 4 && y < 5) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (x1 == 6 && z1 == 11 && y < 5) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (x1 == 9 && z1 == 11 && y < 5) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (x1 == 2 && z1 == 7 && y < 3) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (x1 == 13 && z1 == 7 && y < 3) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (x1 == 5 && z1 == 5 && y < 7) {
            return Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)face);
        }
        if (z1 == 7 && y == 1 && (x1 == 7 || x1 == 8)) {
            return Blocks.field_180392_bq.func_176223_P().func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)face);
        }
        if (z1 > 6 && z1 < 9 && y == 2 && (x1 == 6 || x1 == 9)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (z1 > 6 && z1 < 9 && y == 7 && (x1 == 6 || x1 == 9)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (z1 > 6 && z1 < 9 && y == 8 && (x1 == 6 || x1 == 9)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (x1 < 2 && y == 5 && z1 == 4) {
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        if (x1 > 13 && y == 5 && z1 == 4) {
            return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
        }
        if (x1 > 3 && x1 < 12 && (z1 == 3 || z1 == 12)) {
            if (y < 9) {
                if (x1 == 4 || x1 == 11) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            if (y == 9) {
                if (x1 > 5 && x1 < 10) {
                    return Blocks.field_150350_a.func_176223_P();
                }
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if (y == 10) {
                if (z1 == 3) {
                    return MainInit.stairsDirtbrick.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)face);
                }
                return MainInit.stairsDirtbrick.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
            }
            if (y == 11) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
        }
        if (x1 < 2 && z1 == 5 || x1 < 2 && z1 == 10 || x1 > 13 && z1 == 5 || x1 > 13 && z1 == 10) {
            if (y < 3) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if (y == 3) {
                if (rand.nextBoolean()) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y < 6) {
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y == 6) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
        }
        if (x1 < 2 && z1 > 5 && z1 < 10) {
            if (y == 5) {
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y == 6) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
        }
        if (x1 > 13 && z1 > 5 && z1 < 10) {
            if (y == 5) {
                return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
            if (y == 6) {
                return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
            }
        }
        if (x1 > 1 && x1 < 7 && z1 > 3 && z1 < 12) {
            if (x1 == 2 || x1 == 6 || z1 == 4 || z1 == 11) {
                if (y < 12) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (y == 12) {
                    return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
                }
            } else {
                if (y == 11 || y == 6) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (y == 12) {
                    return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
                }
            }
        }
        if (x1 > 8 && x1 < 14 && z1 > 3 && z1 < 12) {
            if (x1 == 9 || x1 == 13 || z1 == 4 || z1 == 11) {
                if (y < 12) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (y == 12) {
                    return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
                }
            } else {
                if (y == 6 || y == 11) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (y == 12) {
                    return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
                }
            }
        }
        if (x1 > 6 && x1 < 9 && z1 > 3 && z1 < 12) {
            if (z1 == 4 || z1 == 11) {
                if (y > 5 && y < 12) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (y == 12) {
                    return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
                }
            } else {
                if (y == 6) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (y == 12) {
                    return MainInit.halfSlab.func_176223_P().func_177226_a((IProperty)BlockSlabBase.TYPE, (Comparable)Integer.valueOf(5));
                }
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getInterior0(int num, int x, int y, int z, Random rand, EnumFacing face) {
        if ((x == 3 || x == 8 || x == 13) && z == 4 && y == 2) {
            return MainInit.wallLamp.func_176223_P().func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
        }
        if (z > 4 && z < 11) {
            if ((x == 0 || x == 1 || x == 8 || x == 14 || x == 15) && y == 1) {
                if (z == 8) {
                    return Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT).func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)face);
                }
                if (z == 9) {
                    return Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD).func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)face);
                }
            }
            if ((x == 3 || x == 8 || x == 13) && z == 5 && y < 3) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if ((x == 2 || x == 7 || x == 12) && z == 5) {
                if (y == 1) {
                    return Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)face);
                }
                if (y == 2) {
                    return Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)face);
                }
            }
            if (x == 5 || x == 10) {
                if (y < 3) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (y < 6) {
                    return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
                }
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getInterior1(int num, int x, int y, int z, Random rand, EnumFacing face) {
        if ((x == 3 || x == 8 || x == 13) && z == 4 && y == 2) {
            return MainInit.wallLamp.func_176223_P().func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
        }
        if (z > 4 && z < 11) {
            if ((x == 3 || x == 8 || x == 13) && z == 5 && y < 3) {
                return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
            }
            if ((x == 2 || x == 7 || x == 12) && z == 5) {
                if (y == 1) {
                    return Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)face);
                }
                if (y == 2) {
                    return Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)face);
                }
            }
            if (x == 5 || x == 10) {
                if (y < 3) {
                    return MainInit.builds.func_176223_P().func_177226_a((IProperty)DCState.TYPE16, (Comparable)Integer.valueOf(7));
                }
                if (y < 6) {
                    return Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
                }
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getInterior2(int num, int x, int y, int z, Random rand, EnumFacing face) {
        if ((x == 5 || x == 10) && z == 6 && y == 3) {
            return MainInit.wallLamp.func_176223_P().func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)DCState.FACING, (Comparable)face);
        }
        if (ModuleConfig.build_advanced) {
            if (x > 5 && x < 10 && z == 9 && y == 3) {
                return MainInit.displayShelf.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
            }
            if ((x == 0 || x == 15) && z == 8 && y == 4) {
                return MainInit.chandelierGypsum.func_176223_P();
            }
            if (z == 9 && y == 1) {
                switch (x) {
                    case 0: 
                    case 4: 
                    case 11: 
                    case 15: {
                        return MainInit.tableWood.func_176223_P();
                    }
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            if (z == 8 && y == 1) {
                switch (x) {
                    case 2: 
                    case 3: 
                    case 12: 
                    case 13: {
                        return Blocks.field_150350_a.func_176223_P();
                    }
                    case 1: {
                        return MainInit.stoolRed.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176746_e().func_176734_d());
                    }
                    case 14: {
                        return MainInit.stoolRed.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176746_e());
                    }
                }
                return MainInit.tableWood.func_176223_P();
            }
            if (z == 7 && y == 1) {
                switch (x) {
                    case 5: 
                    case 7: 
                    case 9: {
                        return MainInit.stoolRed.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)face.func_176734_d());
                    }
                    case 0: 
                    case 15: {
                        return MainInit.tableWood.func_176223_P();
                    }
                }
                return Blocks.field_150350_a.func_176223_P();
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getInterior3(int num, int x, int y, int z, Random rand, EnumFacing face) {
        if ((x == 5 || x == 10) && z == 6 && y == 2) {
            return MainInit.wallLamp.func_176223_P().func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)DCState.FACING, (Comparable)face);
        }
        if (z == 9 && y == 1) {
            switch (x) {
                case 0: 
                case 15: {
                    return Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)face.func_176734_d());
                }
                case 2: 
                case 13: {
                    return ModuleConfig.build_advanced ? MainInit.tableWood.func_176223_P() : Blocks.field_150344_f.func_176223_P();
                }
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (z == 8 && y == 1) {
            switch (x) {
                case 2: 
                case 13: {
                    return ModuleConfig.build_advanced ? MainInit.tableWood.func_176223_P() : Blocks.field_150344_f.func_176223_P();
                }
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (z == 7 && y == 1) {
            switch (x) {
                case 0: 
                case 1: 
                case 2: 
                case 13: 
                case 14: 
                case 15: {
                    return ModuleConfig.build_advanced ? MainInit.tableWood.func_176223_P() : Blocks.field_150344_f.func_176223_P();
                }
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }
}

