/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen;

import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.config.WorldGenConfig;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenHotspring
implements IWorldGenerator {
    private static final BlockSet AIR = new BlockSet(Blocks.field_150350_a, 0);
    private static final BlockSet STN = new BlockSet(Blocks.field_150348_b, 0);
    private static final BlockSet HOT = new BlockSet(MainInit.hotSpringBlock, 0);
    private static final BlockSet TRA = new BlockSet(MainInit.layerNew, 7);
    private static final BlockSet ALA = new BlockSet(MainInit.layerNew, 0);
    private static final BlockSet GYS = new BlockSet(MainInit.geyser, 1);

    public boolean generate(World world, Random rand, BlockPos pos) {
        if (!world.func_175623_d(pos)) {
            return false;
        }
        while (pos.func_177956_o() > 55 && (world.func_175623_d(pos = pos.func_177977_b()) || world.func_180495_p(pos).func_185904_a() != Material.field_151576_e && world.func_180495_p(pos).func_185904_a() != Material.field_151578_c)) {
        }
        if (pos.func_177956_o() < 56) {
            return false;
        }
        Biome b = world.func_180494_b(pos);
        pos.func_177979_c(2);
        int r = 5 + rand.nextInt(4);
        double r1 = (double)r - 1.0;
        double r2 = (double)r - 3.0;
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-r, -4, -r), (BlockPos)pos.func_177982_a(r, 2, r))) {
            if (!world.func_175667_e(p) || world.func_175623_d(p)) continue;
            double d0 = p.func_177958_n() - pos.func_177958_n();
            double d1 = p.func_177956_o() - pos.func_177956_o();
            double d2 = p.func_177952_p() - pos.func_177952_p();
            double d = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            double d3 = rand.nextDouble() * 0.5;
            if (d < (double)r && world.func_180495_p(p).func_185904_a().func_76222_j()) {
                if (p.func_177956_o() < pos.func_177956_o()) continue;
                world.func_180501_a(p, AIR.getState(), 2);
                continue;
            }
            if (d + d3 < r2) {
                if (p.func_177956_o() < pos.func_177956_o()) {
                    boolean a1;
                    if (p.func_177956_o() == pos.func_177956_o() - 3) {
                        world.func_180501_a(p, TRA.getState(), 2);
                        continue;
                    }
                    if (p.func_177956_o() == pos.func_177956_o() - 2) {
                        a1 = true;
                        for (EnumFacing f : EnumFacing.field_82609_l) {
                            if (f == EnumFacing.UP || world.isSideSolid(p.func_177972_a(f), f.func_176734_d(), false) || world.func_180495_p(p.func_177972_a(f)).func_185904_a().func_76224_d()) continue;
                            a1 = false;
                        }
                        if (a1 && (rand.nextInt(3) == 0 || d < 2.0)) {
                            world.func_180501_a(p, HOT.getState(), 2);
                            continue;
                        }
                        world.func_180501_a(p, TRA.getState(), 2);
                        continue;
                    }
                    if (p.func_177956_o() == pos.func_177956_o() - 1) {
                        a1 = true;
                        for (EnumFacing f : EnumFacing.field_82609_l) {
                            if (f == EnumFacing.UP || world.isSideSolid(p.func_177972_a(f), f.func_176734_d(), false) || world.func_180495_p(p.func_177972_a(f)).func_185904_a().func_76224_d()) continue;
                            a1 = false;
                        }
                        if (a1) {
                            world.func_180501_a(p, HOT.getState(), 2);
                            continue;
                        }
                        world.func_180501_a(p, TRA.getState(), 2);
                        continue;
                    }
                    world.func_180501_a(p, TRA.getState(), 2);
                    continue;
                }
                world.func_180501_a(p, AIR.getState(), 2);
                continue;
            }
            if (d + d3 < r1) {
                if (p.func_177956_o() <= pos.func_177956_o() - 3) {
                    if (rand.nextBoolean()) {
                        world.func_180501_a(p, TRA.getState(), 2);
                        continue;
                    }
                    world.func_180501_a(p, ALA.getState(), 2);
                    continue;
                }
                if (p.func_177956_o() <= pos.func_177956_o()) {
                    if (rand.nextBoolean()) {
                        world.func_180501_a(p, TRA.getState(), 2);
                        continue;
                    }
                    world.func_180501_a(p, STN.getState(), 2);
                    continue;
                }
                if (!rand.nextBoolean()) continue;
                world.func_180501_a(p, AIR.getState(), 2);
                continue;
            }
            if (!(d + d3 < (double)r) || !rand.nextBoolean()) continue;
            if (p.func_177956_o() < pos.func_177956_o()) {
                world.func_180501_a(p, ALA.getState(), 2);
                continue;
            }
            if (p.func_177956_o() != pos.func_177956_o()) continue;
            if (rand.nextInt(100) < 5 && !world.func_175677_d(p.func_177984_a(), false)) {
                world.func_180501_a(p, GYS.getState(), 2);
                continue;
            }
            world.func_180501_a(p, STN.getState(), 2);
        }
        return true;
    }

    public void generate(Random randomIn, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        long seed = world.func_72905_C() + (long)chunkX + (long)(chunkZ * 31);
        Random random = new Random(seed);
        random.nextInt(10000);
        random.nextInt(10000);
        int genDim1 = world.field_73011_w.getDimension();
        if (genDim1 != 0) {
            return;
        }
        if (chunkX > 500 || chunkZ > 500) {
            return;
        }
        if (chunkX < -500 || chunkZ < -500) {
            return;
        }
        int posX = chunkX << 4;
        int posZ = chunkZ << 4;
        BlockPos pos = new BlockPos(posX -= 8, 150, posZ -= 8);
        Biome b = world.func_180494_b(pos);
        if (b.func_185353_n() > 0.2f) {
            return;
        }
        if (!BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) && !BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) && b.func_185353_n() > 0.0f) {
            return;
        }
        double d = 0.2 - (double)b.func_185353_n();
        d += 1.0;
        if ((double)random.nextInt(10000) > (double)WorldGenConfig.hotspringGen * d) {
            return;
        }
        this.generate(world, random, pos);
    }
}

