/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.core.util.BiomeCatchDC;
import defeatedcrow.hac.core.util.DCTimeHelper;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.config.WorldGenConfig;
import java.util.Random;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenSaplings
implements IWorldGenerator {
    private final boolean isForced;
    private int range = -1;
    private int forceX = 0;
    private int forceZ = 0;
    private static Random pRandom;

    public WorldGenSaplings(boolean force) {
        this.isForced = force;
    }

    public void setForcePos(int x, int z) {
        this.forceX = x;
        this.forceZ = z;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!ModuleConfig.world) {
            return;
        }
        this.generateSapling(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
    }

    public boolean generateSapling(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        pRandom = new Random(world.func_72905_C() + (long)chunkX + (long)(chunkZ * 31));
        pRandom.nextInt(8);
        pRandom.nextInt(8);
        pRandom.nextInt(8);
        int genDim1 = world.field_73011_w.getDimension();
        if (genDim1 == 1 || genDim1 == -1) {
            return false;
        }
        if (chunkX > 3000 || chunkZ > 3000) {
            return false;
        }
        if (chunkX < -3000 || chunkZ < -3000) {
            return false;
        }
        if (!this.canGenerate(chunkX, chunkZ, world)) {
            return false;
        }
        int X = chunkX << 4;
        int Z = chunkZ << 4;
        int posX = X + 8 + pRandom.nextInt(8);
        int posZ = Z + 8 + pRandom.nextInt(8);
        if (this.isForced && this.forceX != 0 & this.forceZ != 0) {
            posX = this.forceX;
            posZ = this.forceZ;
        }
        BlockPos pos = new BlockPos(posX, 60, posZ);
        Biome biome = BiomeCatchDC.getBiome((BlockPos)pos, (World)world);
        float temp = biome.func_185353_n();
        TreeType type = null;
        if (temp > 0.9f || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT)) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                type = TreeType.DATE;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                type = TreeType.MORUS;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
                type = TreeType.TEA;
            }
        } else if (temp > 0.0f) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
                type = TreeType.TEA;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                type = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) ? TreeType.WALNUT : (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET) ? TreeType.WISTERIA : TreeType.LEMON);
            } else if (temp > 0.5f) {
                type = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET) ? TreeType.MORUS : TreeType.OLIVE;
            }
        }
        if (type != null) {
            int h = -1;
            for (int y = 200; y > 1; --y) {
                BlockPos p1 = new BlockPos(posX, y, posZ);
                if (!this.isSoil(world, p1) || !this.isReplaceable(world, p1.func_177984_a()) || !world.func_175678_i(p1.func_177984_a()) && world.func_180495_p(p1).func_185904_a() != Material.field_151577_b) continue;
                h = y;
                break;
            }
            if (h > 2) {
                BlockPos main = new BlockPos(posX, h, posZ);
                this.generate(world, main, type);
                return true;
            }
        }
        return false;
    }

    private boolean checkLight(World world, BlockPos pos) {
        if (DCTimeHelper.isDayTime((World)world)) {
            return world.func_175671_l(pos) > 9;
        }
        return world.func_175671_l(pos) > 6;
    }

    public void generate(World world, BlockPos pos, TreeType type) {
        IBlockState sap = FoodInit.saplings.func_176223_P();
        switch (type) {
            case DATE: {
                sap = FoodInit.saplings2.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(1));
                break;
            }
            case LEMON: {
                sap = FoodInit.saplings.func_176223_P();
                break;
            }
            case MORUS: {
                sap = FoodInit.saplings.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(3));
                break;
            }
            case OLIVE: {
                sap = FoodInit.saplings.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(1));
                break;
            }
            case TEA: {
                sap = FoodInit.saplings.func_176223_P().func_177226_a((IProperty)DCState.STAGE4, (Comparable)Integer.valueOf(2));
                break;
            }
            case WALNUT: {
                sap = FoodInit.saplings2.func_176223_P();
                break;
            }
            case WISTERIA: {
                sap = FoodInit.cropWisteria.func_176223_P();
                break;
            }
        }
        world.func_180501_a(pos.func_177984_a(), sap, 2);
        IGrowable crop = (IGrowable)sap.func_177230_c();
        crop.func_176474_b(world, world.field_73012_v, pos.func_177984_a(), sap);
    }

    private boolean canGenerate(int chunkX, int chunkZ, World world) {
        if (this.isForced) {
            return true;
        }
        int i = WorldGenConfig.saplingGen;
        pRandom.nextFloat();
        pRandom.nextFloat();
        float r = pRandom.nextFloat() * 10000.0f;
        int ri = MathHelper.func_76141_d((float)r);
        return ri > 0 && ri < i;
    }

    public boolean isSoil(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151595_p;
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a().func_76224_d()) {
            return false;
        }
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_185904_a().func_76222_j();
    }

    private static enum TreeType {
        LEMON,
        OLIVE,
        TEA,
        MORUS,
        WALNUT,
        DATE,
        WISTERIA;

    }
}

