/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen;

import defeatedcrow.hac.api.blockstate.DCState;
import defeatedcrow.hac.api.blockstate.EnumSide;
import defeatedcrow.hac.core.energy.TileTorqueBase;
import defeatedcrow.hac.core.util.BiomeCatchDC;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.magic.MagicInit;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.config.WorldGenConfig;
import defeatedcrow.hac.main.util.LootTablesDC;
import defeatedcrow.hac.main.worldgen.vein.OreGenPos;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenWindmill
implements IWorldGenerator {
    private final boolean isForced;
    private int range = -1;
    private int forceX = 0;
    private int forceZ = 0;
    private static Random pRandom;
    public static List<ItemStack> loot;

    public WorldGenWindmill(boolean force) {
        this.isForced = force;
    }

    public void setForcePos(int x, int z) {
        this.forceX = x;
        this.forceZ = z;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!ModuleConfig.world) {
            return;
        }
        this.generateWindmill(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
    }

    public boolean generateWindmill(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        pRandom = new Random(world.func_72905_C() + (long)chunkX + (long)(chunkZ * 31));
        pRandom.nextInt(8);
        pRandom.nextInt(8);
        int genDim1 = world.field_73011_w.getDimension();
        if (genDim1 == 1 || genDim1 == -1) {
            return false;
        }
        if (chunkX > 3000 || chunkZ > 3000) {
            return false;
        }
        if (chunkX < -3000 || chunkZ < -3000) {
            return false;
        }
        if (!this.canGenerate(chunkX, chunkZ, world)) {
            return false;
        }
        int X = chunkX << 4;
        int Z = chunkZ << 4;
        int posX = X + 8;
        int posZ = Z + 8;
        if (this.isForced && this.forceX != 0 & this.forceZ != 0) {
            posX = this.forceX;
            posZ = this.forceZ;
        }
        BlockPos pos = new BlockPos(posX, 60, posZ);
        Biome biome = BiomeCatchDC.getBiome((BlockPos)pos, (World)world);
        if (world.field_72982_D.func_176056_a(pos, 32) != null) {
            return false;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return false;
        }
        if (this.isForced || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            int h = -1;
            for (int y = 2; y < 255; ++y) {
                BlockPos p1 = new BlockPos(posX, y, posZ);
                if (this.isReplaceable(world, p1) || !this.isReplaceable(world, p1.func_177984_a()) || !world.func_175678_i(p1.func_177984_a()) && world.func_180495_p(p1).func_185904_a() != Material.field_151577_b) continue;
                h = y;
                break;
            }
            if (h > 40 && h < 100) {
                int i1 = 0;
                int adj = 0;
                for (int i = -3; i < 4; ++i) {
                    for (int j = -3; j < 4; ++j) {
                        BlockPos c1 = new BlockPos(posX + i, h, posZ + j);
                        if (!this.isReplaceable(world, c1.func_177981_b(2)) || this.isReplaceable(world, c1.func_177979_c(2))) {
                            ++i1;
                            continue;
                        }
                        if (this.isReplaceable(world, c1.func_177977_b())) {
                            --adj;
                            continue;
                        }
                        if (this.isReplaceable(world, c1) || this.isReplaceable(world, c1.func_177984_a())) continue;
                        ++adj;
                    }
                }
                if (i1 < 6) {
                    if (adj < -13) {
                        --h;
                    } else if (adj > 12) {
                        ++h;
                    }
                    BlockPos main = new BlockPos(posX, h, posZ);
                    this.generate(world, main);
                    return true;
                }
            }
        }
        return false;
    }

    public void generate(World world, BlockPos pos) {
        int k3;
        int i2;
        int j1;
        int i1;
        for (i1 = -5; i1 < 6; ++i1) {
            for (j1 = -5; j1 < 6; ++j1) {
                for (int k1 = 1; k1 < 15; ++k1) {
                    world.func_175698_g(pos.func_177982_a(i1, k1, j1));
                }
            }
        }
        for (int i = -5; i < 0; ++i) {
            if (!this.isGround(world, pos.func_177982_a(-3, i, -3))) {
                world.func_180501_a(pos.func_177982_a(-3, i, -3), Blocks.field_150336_V.func_176223_P(), 2);
            }
            if (!this.isGround(world, pos.func_177982_a(-3, i, 3))) {
                world.func_180501_a(pos.func_177982_a(-3, i, 3), Blocks.field_150336_V.func_176223_P(), 2);
            }
            if (!this.isGround(world, pos.func_177982_a(3, i, -3))) {
                world.func_180501_a(pos.func_177982_a(3, i, -3), Blocks.field_150336_V.func_176223_P(), 2);
            }
            if (this.isGround(world, pos.func_177982_a(3, i, 3))) continue;
            world.func_180501_a(pos.func_177982_a(3, i, 3), Blocks.field_150336_V.func_176223_P(), 2);
        }
        for (i1 = -3; i1 < 4; ++i1) {
            for (j1 = -3; j1 < 4; ++j1) {
                world.func_180501_a(pos.func_177982_a(i1, 0, j1), Blocks.field_150336_V.func_176223_P(), 2);
            }
        }
        for (int k1 = 1; k1 < 3; ++k1) {
            for (j1 = -3; j1 < 4; ++j1) {
                world.func_180501_a(pos.func_177982_a(-3, k1, j1), Blocks.field_150336_V.func_176223_P(), 2);
                world.func_180501_a(pos.func_177982_a(3, k1, j1), Blocks.field_150336_V.func_176223_P(), 2);
            }
            for (int i12 = -2; i12 < 3; ++i12) {
                world.func_180501_a(pos.func_177982_a(i12, k1, -3), Blocks.field_150336_V.func_176223_P(), 2);
                world.func_180501_a(pos.func_177982_a(i12, k1, 3), Blocks.field_150336_V.func_176223_P(), 2);
            }
        }
        for (i2 = -5; i2 < 6; ++i2) {
            for (int j2 = -5; j2 < 6; ++j2) {
                world.func_180501_a(pos.func_177982_a(i2, 3, j2), Blocks.field_150344_f.func_176223_P(), 2);
            }
        }
        for (i2 = -5; i2 < 6; ++i2) {
            world.func_180501_a(pos.func_177982_a(i2, 4, -5), Blocks.field_180407_aO.func_176223_P(), 2);
            world.func_180501_a(pos.func_177982_a(i2, 4, 5), Blocks.field_180407_aO.func_176223_P(), 2);
        }
        for (i2 = -4; i2 < 5; ++i2) {
            world.func_180501_a(pos.func_177982_a(5, 4, i2), Blocks.field_180407_aO.func_176223_P(), 2);
        }
        world.func_180501_a(pos.func_177982_a(-5, 4, 4), Blocks.field_180407_aO.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(-5, 4, -4), Blocks.field_180407_aO.func_176223_P(), 2);
        IBlockState strO = Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
        for (k3 = 0; k3 < 3; ++k3) {
            IBlockState logY = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
            world.func_180501_a(pos.func_177982_a(-2, 4 + k3, -2), logY, 2);
            world.func_180501_a(pos.func_177982_a(-2, 4 + k3, 2), logY, 2);
            world.func_180501_a(pos.func_177982_a(2, 4 + k3, -2), logY, 2);
            world.func_180501_a(pos.func_177982_a(2, 4 + k3, 2), logY, 2);
            for (int i3 = -1; i3 < 2; ++i3) {
                world.func_180501_a(pos.func_177982_a(i3, 4 + k3, -2), Blocks.field_150344_f.func_176223_P(), 2);
                world.func_180501_a(pos.func_177982_a(i3, 4 + k3, 2), Blocks.field_150344_f.func_176223_P(), 2);
                world.func_180501_a(pos.func_177982_a(2, 4 + k3, i3), Blocks.field_150344_f.func_176223_P(), 2);
            }
            world.func_180501_a(pos.func_177982_a(-2, 4 + k3, -1), Blocks.field_150344_f.func_176223_P(), 2);
            world.func_180501_a(pos.func_177982_a(-2, 4 + k3, 1), Blocks.field_150344_f.func_176223_P(), 2);
        }
        for (k3 = 0; k3 < 4; ++k3) {
            for (int i3 = -1; i3 < 2; ++i3) {
                if (this.isGround(world, pos.func_177982_a(-9 + k3, k3, i3))) continue;
                world.func_180501_a(pos.func_177982_a(-9 + k3, k3, i3), strO, 2);
            }
        }
        world.func_180501_a(pos.func_177982_a(-2, 4, 0), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT), 2);
        world.func_180501_a(pos.func_177982_a(-2, 5, 0), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), 2);
        world.func_180501_a(pos.func_177982_a(-2, 6, 0), Blocks.field_150344_f.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(2, 7, -1), Blocks.field_150344_f.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(2, 7, 1), Blocks.field_150344_f.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(2, 8, 0), Blocks.field_150344_f.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(-2, 7, -1), Blocks.field_150344_f.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(-2, 7, 0), Blocks.field_150344_f.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(-2, 7, 1), Blocks.field_150344_f.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(-2, 8, 0), Blocks.field_150344_f.func_176223_P(), 2);
        IBlockState slab = Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.BRICK);
        world.func_180501_a(pos.func_177982_a(-3, 6, -1), slab, 2);
        world.func_180501_a(pos.func_177982_a(-3, 6, 1), slab, 2);
        world.func_180501_a(pos.func_177982_a(-3, 6, 0), slab, 2);
        IBlockState strL = Blocks.field_150389_bf.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
        IBlockState strR = Blocks.field_150389_bf.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
        for (int j3 = -2; j3 < 3; ++j3) {
            world.func_180501_a(pos.func_177982_a(j3, 6, -3), strL, 2);
            world.func_180501_a(pos.func_177982_a(j3, 7, -2), strL, 2);
            world.func_180501_a(pos.func_177982_a(j3, 8, -1), strL, 2);
            world.func_180501_a(pos.func_177982_a(j3, 6, 3), strR, 2);
            world.func_180501_a(pos.func_177982_a(j3, 7, 2), strR, 2);
            world.func_180501_a(pos.func_177982_a(j3, 8, 1), strR, 2);
            world.func_180501_a(pos.func_177982_a(j3, 9, 0), slab, 2);
        }
        world.func_180501_a(pos.func_177982_a(0, 9, 0), Blocks.field_150336_V.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(0, 10, 0), MainInit.windvane.func_176223_P(), 2);
        for (int i4 = 0; i4 < 3; ++i4) {
            world.func_180501_a(pos.func_177982_a(-1, 1 + i4, -2), Blocks.field_150344_f.func_176223_P(), 2);
            world.func_180501_a(pos.func_177982_a(-1, 1 + i4, -1), Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.SOUTH), 2);
        }
        world.func_180501_a(pos.func_177982_a(-1, 6, 0), MainInit.wallLamp.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(3)), 2);
        world.func_180501_a(pos.func_177982_a(-2, 2, 0), MainInit.wallLamp.func_176223_P().func_177226_a((IProperty)DCState.FACING, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)DCState.TYPE4, (Comparable)Integer.valueOf(3)), 2);
        if (ModuleConfig.machine) {
            world.func_180501_a(pos.func_177982_a(1, 4, 0), MachineInit.stonemill.func_176223_P(), 2);
            if (pRandom.nextInt(8) > 0) {
                world.func_180501_a(pos.func_177982_a(1, 5, 0), MachineInit.shaft_s.func_176223_P().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.UP), 2);
            }
            if (pRandom.nextInt(8) > 0) {
                world.func_180501_a(pos.func_177982_a(1, 6, 0), MachineInit.shaft_s.func_176223_P().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.UP), 2);
            }
            world.func_180501_a(pos.func_177982_a(1, 7, 0), MachineInit.shaft_l.func_176223_P().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.EAST), 2);
            TileEntity shaft = world.func_175625_s(pos.func_177982_a(1, 7, 0));
            if (shaft != null) {
                ((TileTorqueBase)shaft).setFaceSide(EnumFacing.SOUTH);
            }
            world.func_180501_a(pos.func_177982_a(2, 7, 0), MachineInit.gearbox.func_176223_P().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.EAST), 2);
            world.func_180501_a(pos.func_177982_a(3, 7, 0), MachineInit.windmill_l.func_176223_P().func_177226_a((IProperty)DCState.SIDE, (Comparable)EnumSide.WEST), 2);
        }
        world.func_180501_a(pos.func_177982_a(2, 1, -2), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.WEST), 2);
        TileEntity chest = world.func_175625_s(pos.func_177982_a(2, 1, -2));
        if (chest != null && chest instanceof TileEntityChest) {
            ((TileEntityChest)chest).func_189404_a(LootTablesDC.WINDMILL_CHEST_LOOT, world.field_73012_v.nextLong());
        }
    }

    private boolean canGenerate(int chunkX, int chunkZ, World world) {
        if (this.isForced) {
            return true;
        }
        int i = WorldGenConfig.windmillGen;
        pRandom.nextFloat();
        pRandom.nextFloat();
        float r = pRandom.nextFloat() * 10000.0f;
        int ri = MathHelper.func_76141_d((float)r);
        if (ri > 0 && ri < i) {
            if (OreGenPos.canWindmillGenChunk(chunkX, chunkZ)) {
                return true;
            }
        }
        return false;
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a().func_76224_d()) {
            return false;
        }
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_185904_a().func_76222_j() || state.func_185904_a() == Material.field_151584_j;
    }

    public boolean isGround(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a().func_76224_d()) {
            return false;
        }
        return state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151595_p;
    }

    public static void initLoot() {
        if (ModuleConfig.machine) {
            loot.add(new ItemStack(MachineInit.shaft_s, 1, 0));
            loot.add(new ItemStack(MachineInit.shaft_s, 1, 0));
            loot.add(new ItemStack(MachineInit.shaft_l, 1, 0));
        }
        if (ModuleConfig.magic) {
            loot.add(new ItemStack(MagicInit.colorDrop, 1, 0));
            loot.add(new ItemStack(MagicInit.colorDrop, 1, 1));
            loot.add(new ItemStack(MagicInit.colorDrop, 1, 2));
            loot.add(new ItemStack(MagicInit.colorDrop, 1, 3));
            loot.add(new ItemStack(MagicInit.colorDrop, 1, 4));
        }
        if (ModuleConfig.tool) {
            loot.add(new ItemStack(MainInit.dcScythe[1], 1, 0));
            loot.add(new ItemStack(MainInit.dcPickaxe[0], 1, 0));
            loot.add(new ItemStack(MainInit.dcAxe[0], 1, 0));
        }
    }

    static {
        loot = new ArrayList<ItemStack>();
    }
}

