/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen.vein;

import defeatedcrow.hac.main.config.WorldGenConfig;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class SkarnGenPos {
    public static Chunk chunk = null;

    public static boolean isDupe(int cx, int cz, World world) {
        if (!WorldGenConfig.skarnDupeCheck) {
            return false;
        }
        int ccx = cx >> 4;
        int ccz = cz >> 4;
        ccz *= 16;
        boolean count = false;
        for (int x = ccx *= 16; x < ccx + 16; ++x) {
            int z = ccz;
            while (ccz + z < 16) {
                if (!(x == cx && z == cz || !SkarnGenPos.canGeneratePos(x, z, world) || x < cx && z < cz)) {
                    return true;
                }
                ++z;
            }
        }
        return false;
    }

    public static boolean isDupe(BlockPos pos, World world) {
        if (!WorldGenConfig.skarnDupeCheck) {
            return false;
        }
        int cx2 = pos.func_177958_n() >> 4;
        int cz2 = pos.func_177952_p() >> 4;
        return SkarnGenPos.isDupe(cx2, cz2, world);
    }

    public static boolean hasCenterPoint(int cx, int cz, World world) {
        Object ret = null;
        int count = 100;
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (!SkarnGenPos.canGeneratePos(cx + x, cz + z, world)) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockPos getNearestPoint(int cx, int cz, World world, int r) {
        BlockPos ret = null;
        int count = 100;
        for (int x = -r; x < r + 1; ++x) {
            for (int z = -r; z < r + 1; ++z) {
                int i;
                if (!SkarnGenPos.canGeneratePos(cx + x, cz + z, world) || (i = x * x + z * z) >= count) continue;
                count = i;
                int rx = cx + x;
                int rz = cz + z;
                ret = new BlockPos(rx * 16 + 8, 40, rz * 16 + 8);
            }
        }
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public static int getGenHeight(int cx, int cz, World world, BlockPos pos) {
        int h = -1;
        int count = 100;
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                int i;
                if (!SkarnGenPos.canGeneratePos(cx + x, cz + z, world) || (i = x * x + z * z) >= count) continue;
                count = i;
                int rx = cx + x;
                int rz = cz + z;
                int px = rx * 16 + 8 - pos.func_177958_n();
                int pz = rz * 16 + 8 - pos.func_177952_p();
                double d = MathHelper.func_76129_c((float)(px * px + pz * pz));
                h = 40 - MathHelper.func_76128_c((double)d);
            }
        }
        if (h > 0) {
            return h;
        }
        return -1;
    }

    public static int getGenHeight(World world, BlockPos pos, BlockPos from) {
        int h = -1;
        if (pos != null && from != null) {
            int px = from.func_177958_n() - pos.func_177958_n();
            int pz = from.func_177952_p() - pos.func_177952_p();
            double d = MathHelper.func_76129_c((float)(px * px + pz * pz));
            h = from.func_177956_o() - MathHelper.func_76128_c((double)d);
        }
        if (h > 0) {
            return h;
        }
        return -1;
    }

    public static boolean isSuitableChunk(int cx, int cz, World world) {
        if (world.field_72995_K) {
            return false;
        }
        int genDim1 = world.field_73011_w.getDimension();
        if (genDim1 != 0) {
            return false;
        }
        if (cx > 2000 || cz > 2000) {
            return false;
        }
        return cx >= -2000 && cz >= -2000;
    }

    public static boolean canGeneratePos(int cx, int cz, World world) {
        if ((cx & 1) == 0 || (cz & 1) == 0) {
            return false;
        }
        long seed = world.func_72905_C() + (long)cx + (long)(cz * 17);
        Random rand = new Random(seed);
        rand.nextInt(10000);
        int r = rand.nextInt(10000);
        return r > 0 && r < WorldGenConfig.skarnGen;
    }
}

