/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen.vein;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.orevein.EnumVein;
import defeatedcrow.hac.main.api.orevein.VeinTable;
import defeatedcrow.hac.main.api.orevein.VeinTableRegisterEvent;
import defeatedcrow.hac.main.util.MainUtil;
import defeatedcrow.hac.main.worldgen.vein.OreSetDC;
import defeatedcrow.hac.main.worldgen.vein.VeinTableRegister;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class VeinTableJson {
    public static VeinTableJson INSTANCE = new VeinTableJson();
    private static final Map<EnumVein, Map<String, Object>> jsonMap = new HashMap<EnumVein, Map<String, Object>>();
    private static Path parent = null;
    public static final BlockSet STONE = new BlockSet(Blocks.field_150348_b, 0);

    private VeinTableJson() {
    }

    private static void loadVeins() {
        if (!jsonMap.isEmpty()) {
            for (Map.Entry<EnumVein, Map<String, Object>> e1 : jsonMap.entrySet()) {
                Object o2;
                String sl;
                BlockSet bl;
                Object o1;
                EnumVein type = e1.getKey();
                BlockSet layer = STONE;
                ArrayList list = Lists.newArrayList();
                Map<String, Object> map = e1.getValue();
                if (map == null || map.isEmpty()) continue;
                if (map.containsKey("layer") && (o1 = map.get("layer")) instanceof String && !(bl = MainUtil.getBlockSetFromString(sl = (String)o1)).equals((Object)OreSetDC.AIR)) {
                    layer = bl;
                }
                if (map.containsKey("entries") && (o2 = map.get("entries")) instanceof List) {
                    List l2 = (List)o2;
                    for (Object o3 : l2) {
                        if (!(o3 instanceof Map)) continue;
                        try {
                            Object o5;
                            Object o4;
                            Map ores = (Map)o3;
                            BlockSet b1 = STONE;
                            BlockSet b2 = null;
                            int weight = 10;
                            int chance = 0;
                            if (ores.containsKey("ore") && (o4 = ores.get("ore")) instanceof String) {
                                String s1 = (String)o4;
                                b1 = MainUtil.getBlockSetFromString(s1);
                            }
                            if (ores.containsKey("secondary") && (o5 = ores.get("secondary")) instanceof String) {
                                String s2 = (String)o5;
                                b2 = MainUtil.getBlockSetFromString(s2);
                            }
                            if (ores.containsKey("weight")) {
                                Number n1 = (Number)ores.get("weight");
                                if (n1 instanceof Integer) {
                                    weight = n1.intValue();
                                }
                                if (n1 instanceof Double) {
                                    weight = MathHelper.func_76128_c((double)n1.doubleValue());
                                }
                            }
                            if (ores.containsKey("secondary_chance")) {
                                Number n2 = (Number)ores.get("secondary_chance");
                                if (n2 instanceof Integer) {
                                    chance = n2.intValue();
                                }
                                if (n2 instanceof Double) {
                                    chance = MathHelper.func_76128_c((double)n2.doubleValue());
                                }
                            }
                            if (b1 == null || weight <= 0) continue;
                            OreSetDC set = null;
                            set = b2 != null && chance > 0 ? new OreSetDC(weight, b1, b2, chance) : new OreSetDC(weight, b1);
                            if (set == null) continue;
                            list.add(set);
                        }
                        catch (Error e) {
                            DCLogger.warnLog((String)"VainTableJson : Error entry found. This entry is ignored.");
                        }
                        catch (Exception e) {
                            DCLogger.warnLog((String)"VainTableJson : Error entry found. This entry is ignored. ");
                        }
                    }
                }
                VeinTable table = new VeinTable(type, new OreSetDC(100, layer));
                if (list.isEmpty()) {
                    list.add(new OreSetDC(100, layer));
                }
                table.addOres(list);
                if (!VeinTableRegister.list.add(table)) continue;
                DCLogger.debugInfoLog((String)("VainTableJson : Successfilly loaded: " + (Object)((Object)type) + " count" + table.tableCount));
            }
            VeinTableRegisterEvent event = new VeinTableRegisterEvent(VeinTableRegister.INSTANCE);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    public static void pre() {
        for (EnumVein type : EnumVein.VALUES) {
            String fName = type.toString().toLowerCase();
            File file = new File(parent + "/" + fName + ".json");
            if (file == null) continue;
            try {
                if (!file.exists() || !file.canRead()) continue;
                FileInputStream fis = new FileInputStream(file.getPath());
                InputStreamReader isr = new InputStreamReader(fis);
                JsonReader jsr = new JsonReader((Reader)isr);
                Gson gson = new Gson();
                Map get = (Map)gson.fromJson(jsr, Map.class);
                isr.close();
                fis.close();
                jsr.close();
                if (get == null || get.isEmpty()) continue;
                jsonMap.put(type, get);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!jsonMap.isEmpty()) {
            VeinTableJson.loadVeins();
        }
    }

    public static void post() {
        boolean b = VeinTableJson.registerVeins();
        if (b) {
            for (Map.Entry<EnumVein, Map<String, Object>> entry : jsonMap.entrySet()) {
                String fName = entry.getKey().toString().toLowerCase();
                File file = new File(parent + "/" + fName + ".json");
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try {
                    if (!file.exists() && !file.createNewFile() || !file.canWrite()) continue;
                    FileOutputStream fos = new FileOutputStream(file.getPath());
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    JsonWriter jsw = new JsonWriter((Writer)osw);
                    jsw.setIndent("    ");
                    Gson gson = new Gson();
                    gson.toJson(entry.getValue(), Map.class, jsw);
                    osw.close();
                    fos.close();
                    jsw.close();
                }
                catch (IOException e) {
                    DCLogger.debugInfoLog((String)("VainTableJson : Failed to create json file: " + fName));
                    e.printStackTrace();
                }
            }
        } else {
            DCLogger.debugInfoLog((String)"VainTableJson : Orevein custom data json is already exists.");
            return;
        }
        VeinTableJson.loadVeins();
    }

    public static boolean registerVeins() {
        boolean ret = false;
        if (!jsonMap.containsKey((Object)EnumVein.RED)) {
            HashMap<String, Object> red = new HashMap<String, Object>();
            red.put("layer", VeinTableJson.blockString(new BlockSet(MainInit.layerNew, 1)));
            ArrayList redMap = Lists.newArrayList();
            redMap.add(VeinTableJson.getEntry(80, new BlockSet(MainInit.oreNew, 0), new BlockSet(MainInit.oreNew, 5), 5));
            redMap.add(VeinTableJson.getEntry(20, new BlockSet(MainInit.layerNew, 3)));
            redMap.add(VeinTableJson.getEntry(40, new BlockSet(MainInit.layerNew, 1)));
            redMap.add(VeinTableJson.getEntry(5, new BlockSet(MainInit.oreNew, 5)));
            red.put("entries", redMap);
            jsonMap.put(EnumVein.RED, red);
            ret = true;
        }
        if (!jsonMap.containsKey((Object)EnumVein.HIGH_RED)) {
            HashMap<String, Object> high_red = new HashMap<String, Object>();
            high_red.put("layer", VeinTableJson.blockString(new BlockSet(MainInit.layerNew, 1)));
            ArrayList high_redMap = Lists.newArrayList();
            high_redMap.add(VeinTableJson.getEntry(60, new BlockSet(MainInit.oreNew, 0), new BlockSet(MainInit.oreNew, 5), 5));
            high_redMap.add(VeinTableJson.getEntry(20, new BlockSet(MainInit.layerNew, 3)));
            high_redMap.add(VeinTableJson.getEntry(50, new BlockSet(MainInit.layerNew, 1)));
            high_redMap.add(VeinTableJson.getEntry(20, new BlockSet(MainInit.oreNew, 5)));
            high_red.put("entries", high_redMap);
            jsonMap.put(EnumVein.HIGH_RED, high_red);
            ret = true;
        }
        if (!jsonMap.containsKey((Object)EnumVein.GREEN)) {
            HashMap<String, Object> green = new HashMap<String, Object>();
            green.put("layer", VeinTableJson.blockString(new BlockSet(MainInit.layerNew, 6)));
            ArrayList greenMap = Lists.newArrayList();
            greenMap.add(VeinTableJson.getEntry(80, new BlockSet(MainInit.oreNew, 1), new BlockSet(MainInit.oreNew, 6), 5));
            greenMap.add(VeinTableJson.getEntry(30, new BlockSet(MainInit.layerNew, 6), new BlockSet(Blocks.field_150412_bA, 0), 20));
            greenMap.add(VeinTableJson.getEntry(5, new BlockSet(MainInit.oreNew, 6)));
            greenMap.add(VeinTableJson.getEntry(10, new BlockSet(Blocks.field_150435_aG, 0)));
            green.put("entries", greenMap);
            jsonMap.put(EnumVein.GREEN, green);
            ret = true;
        }
        if (!jsonMap.containsKey((Object)EnumVein.BLUE)) {
            HashMap<String, Object> blue = new HashMap<String, Object>();
            blue.put("layer", VeinTableJson.blockString(new BlockSet(MainInit.layerNew, 0)));
            ArrayList blueMap = Lists.newArrayList();
            blueMap.add(VeinTableJson.getEntry(80, new BlockSet(MainInit.oreNew, 2), new BlockSet(MainInit.oreNew, 7), 5));
            blueMap.add(VeinTableJson.getEntry(40, new BlockSet(MainInit.layerNew, 0)));
            blueMap.add(VeinTableJson.getEntry(5, new BlockSet(Blocks.field_150369_x, 0)));
            blueMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 7)));
            blue.put("entries", blueMap);
            jsonMap.put(EnumVein.BLUE, blue);
            ret = true;
        }
        if (!jsonMap.containsKey((Object)EnumVein.WHITE)) {
            HashMap<String, Object> white = new HashMap<String, Object>();
            white.put("layer", VeinTableJson.blockString(new BlockSet(MainInit.gemBlock, 6)));
            ArrayList whiteMap = Lists.newArrayList();
            whiteMap.add(VeinTableJson.getEntry(80, new BlockSet(MainInit.oreNew, 3), new BlockSet(MainInit.oreNew, 8), 5));
            whiteMap.add(VeinTableJson.getEntry(30, new BlockSet(MainInit.layerNew, 5)));
            whiteMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 8)));
            whiteMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.gemBlock, 6)));
            whiteMap.add(VeinTableJson.getEntry(5, new BlockSet(MainInit.skarnOre, 8)));
            white.put("entries", whiteMap);
            jsonMap.put(EnumVein.WHITE, white);
            ret = true;
        }
        if (!jsonMap.containsKey((Object)EnumVein.BLACK)) {
            HashMap<String, Object> black = new HashMap<String, Object>();
            black.put("layer", VeinTableJson.blockString(new BlockSet(Blocks.field_150348_b, 0)));
            ArrayList blackMap = Lists.newArrayList();
            blackMap.add(VeinTableJson.getEntry(80, new BlockSet(MainInit.oreNew, 4), new BlockSet(MainInit.oreNew, 9), 5));
            blackMap.add(VeinTableJson.getEntry(30, new BlockSet(MainInit.layerNew, 4)));
            blackMap.add(VeinTableJson.getEntry(20, new BlockSet(MainInit.oreNew, 9)));
            blackMap.add(VeinTableJson.getEntry(5, new BlockSet(Blocks.field_150450_ax, 0)));
            blackMap.add(VeinTableJson.getEntry(5, new BlockSet(Blocks.field_150365_q, 0)));
            black.put("entries", blackMap);
            jsonMap.put(EnumVein.BLACK, black);
            ret = true;
        }
        if (!jsonMap.containsKey((Object)EnumVein.GUANO)) {
            HashMap<String, Object> guano = new HashMap<String, Object>();
            guano.put("layer", VeinTableJson.blockString(new BlockSet(Blocks.field_150351_n, 0)));
            ArrayList guanoMap = Lists.newArrayList();
            guanoMap.add(VeinTableJson.getEntry(80, new BlockSet(MainInit.layerNew, 2), new BlockSet(Blocks.field_150351_n, 0), 30));
            guano.put("entries", guanoMap);
            jsonMap.put(EnumVein.GUANO, guano);
            ret = true;
        }
        if (!jsonMap.containsKey((Object)EnumVein.SKARN_IRON)) {
            HashMap<String, Object> skarn = new HashMap<String, Object>();
            skarn.put("layer", VeinTableJson.blockString(new BlockSet(MainInit.skarnBlock, 0)));
            ArrayList skarnMap = Lists.newArrayList();
            skarnMap.add(VeinTableJson.getEntry(20, new BlockSet(MainInit.oreNew, 1), new BlockSet(MainInit.oreNew, 6), 15));
            skarnMap.add(VeinTableJson.getEntry(30, new BlockSet(MainInit.oreNew, 2), new BlockSet(MainInit.oreNew, 7), 15));
            skarnMap.add(VeinTableJson.getEntry(20, new BlockSet(MainInit.oreNew, 4), new BlockSet(MainInit.oreNew, 9), 15));
            skarnMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 6)));
            skarnMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 7)));
            skarnMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 9)));
            skarn.put("entries", skarnMap);
            jsonMap.put(EnumVein.SKARN_IRON, skarn);
            ret = true;
        }
        if (!jsonMap.containsKey((Object)EnumVein.SKARN_COPPER)) {
            HashMap<String, Object> skarn_under = new HashMap<String, Object>();
            skarn_under.put("layer", VeinTableJson.blockString(new BlockSet(MainInit.skarnBlock, 2)));
            ArrayList skarn_underMap = Lists.newArrayList();
            skarn_underMap.add(VeinTableJson.getEntry(40, new BlockSet(MainInit.oreNew, 0), new BlockSet(MainInit.oreNew, 5), 15));
            skarn_underMap.add(VeinTableJson.getEntry(20, new BlockSet(MainInit.oreNew, 3), new BlockSet(MainInit.oreNew, 8), 15));
            skarn_underMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 5)));
            skarn_underMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 6)));
            skarn_underMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 8)));
            skarn_underMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 9)));
            skarn_under.put("entries", skarn_underMap);
            jsonMap.put(EnumVein.SKARN_COPPER, skarn_under);
            ret = true;
        }
        if (!jsonMap.containsKey((Object)EnumVein.NETHER)) {
            HashMap<String, Object> nether = new HashMap<String, Object>();
            nether.put("layer", VeinTableJson.blockString(new BlockSet(MainInit.oreNew, 10)));
            ArrayList netherMap = Lists.newArrayList();
            netherMap.add(VeinTableJson.getEntry(40, new BlockSet(MainInit.oreNew, 10), new BlockSet(MainInit.oreNew, 11), 20));
            netherMap.add(VeinTableJson.getEntry(40, new BlockSet(MainInit.oreNew, 12), new BlockSet(MainInit.oreNew, 13), 20));
            netherMap.add(VeinTableJson.getEntry(20, new BlockSet(MainInit.oreNew, 14)));
            netherMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 11)));
            netherMap.add(VeinTableJson.getEntry(10, new BlockSet(MainInit.oreNew, 13)));
            nether.put("entries", netherMap);
            jsonMap.put(EnumVein.NETHER, nether);
            ret = true;
        }
        return ret;
    }

    public static void setDir(File file) {
        parent = file.toPath().resolve("defeatedcrow\\climate\\veins\\");
    }

    public static String blockString(BlockSet b1) {
        if (b1 == null || b1 == OreSetDC.AIR) {
            return "empty";
        }
        String ore = b1.block.getRegistryName().toString() + ":" + b1.meta;
        return ore;
    }

    public static Map<String, Object> getEntry(int w, BlockSet b1) {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        ret.put("weight", w);
        ret.put("ore", VeinTableJson.blockString(b1));
        return ret;
    }

    public static Map<String, Object> getEntry(int w, BlockSet b1, BlockSet b2, int c) {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        ret.put("weight", w);
        ret.put("ore", VeinTableJson.blockString(b1));
        ret.put("secondary", VeinTableJson.blockString(b2));
        ret.put("secondary_chance", c);
        return ret;
    }
}

