/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen.vein;

import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.orevein.EnumVein;
import defeatedcrow.hac.main.api.orevein.OreSet;
import defeatedcrow.hac.main.api.orevein.VeinTable;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.config.WorldGenConfig;
import defeatedcrow.hac.main.worldgen.vein.OreSetDC;
import defeatedcrow.hac.main.worldgen.vein.SkarnGenPoint;
import defeatedcrow.hac.main.worldgen.vein.VeinTableRegister;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEmptyDrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

@Deprecated
public class WorldGenAltSkarn
implements IWorldGenerator {
    private final boolean isForced;
    private int range = -1;
    private int forceX = 0;
    private int forceZ = 0;
    private static final BlockSet AIR = new BlockSet(Blocks.field_150350_a, 0);
    private static final BlockSet LAVA = new BlockSet((Block)Blocks.field_150353_l, 0);
    private static final BlockSet STONE_0 = new BlockSet(Blocks.field_150348_b, 0);
    private static final BlockSet STONE_1 = new BlockSet(Blocks.field_150348_b, 1);
    private static final BlockSet STONE_2 = new BlockSet(Blocks.field_150348_b, 3);
    private static final BlockSet STONE_3 = new BlockSet(Blocks.field_150348_b, 5);
    private static final BlockSet SAND = new BlockSet(Blocks.field_150322_A, 0);
    private static final BlockSet LIME = new BlockSet(MainInit.layerNew, 1);
    private static final BlockSet MARBLE = new BlockSet(MainInit.gemBlock, 6);

    public WorldGenAltSkarn(boolean force) {
        this.isForced = force;
    }

    public void setRange(int i) {
        if (i > 10) {
            i = 10;
        }
        this.range = i;
    }

    public void setForcePos(int x, int z) {
        this.forceX = x;
        this.forceZ = z;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!ModuleConfig.world) {
            return;
        }
        int genDim1 = world.field_73011_w.getDimension();
        if (genDim1 == 1 || genDim1 == -1) {
            return;
        }
        if (Math.abs(chunkX) > 1000 || Math.abs(chunkZ) > 1000) {
            return;
        }
        if (!world.func_72964_e(chunkX, chunkZ).func_177410_o()) {
            return;
        }
        if (!WorldGenAltSkarn.canGenerate(chunkX, chunkZ, world, this.isForced)) {
            return;
        }
        int posX = chunkX << 4;
        int posZ = chunkZ << 4;
        posX += world.field_73012_v.nextInt(8) + 4;
        posZ += world.field_73012_v.nextInt(8) + 4;
        if (this.isForced && this.forceX != 0 & this.forceZ != 0) {
            posX = this.forceX;
            posZ = this.forceZ;
        }
        BlockPos pos = new BlockPos(posX, 75, posZ);
        Biome biome = world.func_180494_b(pos);
        int f = world.field_73012_v.nextInt(15);
        if (this.range > 0) {
            f = this.range / 2 + world.field_73012_v.nextInt(this.range);
        }
        int r = 2 + f;
        if (this.isForced || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            for (int y = 1; y < 80; ++y) {
                int r2 = y / 4;
                int r3 = y / 8;
                int r4 = (y - 40) / 4;
                int rr = r;
                rr = y < 25 ? r + 3 - r2 : (y > 40 ? r - r3 + r4 : r - r3);
                if (rr <= 0) continue;
                OreSet b1 = this.getBlockSet1(y, f, world.field_73012_v);
                BlockSet b2 = this.getBlockSet2(y, f, world.field_73012_v);
                for (int x = posX - rr; x <= posX + rr; ++x) {
                    for (int z = posZ - rr; z <= posZ + rr; ++z) {
                        BlockPos p = new BlockPos(x, y, z);
                        IBlockState block = world.func_180495_p(p);
                        if (block.func_185904_a() == Material.field_151577_b && !world.func_175623_d(p.func_177984_a())) continue;
                        if (WorldGenAltSkarn.isPlaceable(block, this.isForced)) {
                            int x1 = p.func_177958_n() - posX;
                            int z1 = p.func_177952_p() - posZ;
                            double dist = Math.sqrt(x1 * x1 + z1 * z1);
                            if (rr > 2 && dist < (double)(rr - 2)) {
                                if (b1 == null) continue;
                                if (b1.hasSecondOre() && world.field_73012_v.nextInt(100) < b1.getSecondChance()) {
                                    world.func_180501_a(p, b1.getSecondOre().getState(), 2);
                                    continue;
                                }
                                world.func_180501_a(p, b1.getOre().getState(), 2);
                                continue;
                            }
                            if (!(dist < (double)rr) || b2 == null) continue;
                            world.func_180501_a(p, b2.getState(), 2);
                            continue;
                        }
                        if (block.func_185904_a() == Material.field_151575_d || block.func_185904_a() == Material.field_151584_j) {
                            world.func_175698_g(p);
                            continue;
                        }
                        if (block.func_185904_a() != Material.field_151577_b || !world.field_73012_v.nextBoolean() || !world.func_175623_d(p.func_177984_a())) continue;
                        world.func_175698_g(p);
                    }
                }
            }
        }
    }

    public static boolean canGenerate(int chunkX, int chunkZ, World world, boolean f) {
        Random pRandom = new Random(world.func_72905_C() + (long)chunkX + (long)(chunkZ * 31));
        if (f) {
            return true;
        }
        if (!SkarnGenPoint.hasPos(chunkX, chunkZ)) {
            int i = WorldGenConfig.skarnGen;
            pRandom.nextFloat();
            float r = pRandom.nextFloat() * 10000.0f;
            int ri = MathHelper.func_76141_d((float)r);
            if (ri > 0 && ri < i) {
                SkarnGenPoint.addPos(chunkX, chunkZ);
                return true;
            }
        }
        return false;
    }

    private OreSet getBlockSet1(int y, int f, Random rand) {
        int f2 = rand.nextInt(3);
        if (y < 12 + f2) {
            return new OreSetDC(100, LAVA);
        }
        if (y < 14 + f2) {
            return new OreSetDC(100, AIR);
        }
        if (y < 17 + f2) {
            return new OreSetDC(100, STONE_1);
        }
        if (y > 50 + f2) {
            if (y > 58 + f2) {
                return new OreSetDC(100, LIME, false);
            }
            return new OreSetDC(100, MARBLE, false);
        }
        VeinTable table = VeinTableRegister.INSTANCE.getTable(EnumVein.SKARN_IRON);
        VeinTable table2 = VeinTableRegister.INSTANCE.getTable(EnumVein.SKARN_COPPER);
        if (table == null || table2 == null) {
            return new OreSetDC(100, MARBLE);
        }
        if (y < 28) {
            List<OreSet> list = table2.getOreTable();
            int i1 = rand.nextInt(table2.tableCount);
            int i2 = 0;
            for (OreSet set : list) {
                if ((i2 += set.getWeight()) < i1) continue;
                return set;
            }
            return new OreSetDC(100, STONE_2);
        }
        List<OreSet> list = table.getOreTable();
        int i1 = rand.nextInt(table.tableCount);
        int i2 = 0;
        for (OreSet set : list) {
            if ((i2 += set.getWeight()) < i1) continue;
            return set;
        }
        return new OreSetDC(100, MARBLE, false);
    }

    private BlockSet getBlockSet2(int y, int f, Random rand) {
        int f2 = rand.nextInt(3);
        if (y < 12 + f2) {
            return STONE_1;
        }
        if (y < 20 + f2) {
            return STONE_1;
        }
        if (y > 48 + f2) {
            if (y > 58 + f2) {
                return LIME;
            }
            return MARBLE;
        }
        if (y < 30) {
            return STONE_1;
        }
        return MARBLE;
    }

    static boolean isPlaceable(IBlockState block, boolean b) {
        if (block.func_185915_l() && !(block.func_177230_c() instanceof BlockEmptyDrops)) {
            return block.func_185904_a() == Material.field_151576_e || block.func_185904_a() == Material.field_151595_p || block.func_185904_a() == Material.field_151578_c || block.func_185904_a() == Material.field_151577_b;
        }
        return b;
    }
}

