/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen.vein;

import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.api.orevein.EnumVein;
import defeatedcrow.hac.main.api.orevein.OreSet;
import defeatedcrow.hac.main.api.orevein.VeinTable;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.config.WorldGenConfig;
import defeatedcrow.hac.main.worldgen.vein.OreGenPos;
import defeatedcrow.hac.main.worldgen.vein.VeinTableRegister;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockEmptyDrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOres
implements IWorldGenerator {
    private static final boolean debug = false;
    private final boolean isForced;

    public WorldGenOres(boolean force) {
        this.isForced = force;
    }

    public WorldGenOres() {
        this.isForced = false;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        OreGenPos.OreVein[] veins;
        int genDim1 = world.field_73011_w.getDimension();
        if (Math.abs(chunkX) > 1000 || Math.abs(chunkZ) > 1000) {
            return;
        }
        if (!world.func_72964_e(chunkX, chunkZ).func_177410_o()) {
            return;
        }
        int posX1 = chunkX << 4;
        int posZ1 = chunkZ << 4;
        int count = 4;
        if (genDim1 == -1) {
            OreGenPos.OreVein vein = OreGenPos.INSTANCE.getNetherVeins(chunkX, chunkZ, world);
            if (vein != null) {
                this.generateNetherVein(world, vein, posX1, posZ1);
            }
        } else if (genDim1 != 1 && genDim1 != -1 && (veins = OreGenPos.INSTANCE.getVeins(chunkX, chunkZ, world)) != null) {
            for (int i = 0; i < veins.length; ++i) {
                OreGenPos.OreVein vein = veins[i];
                if (vein == null || this.isForced && vein.pos.func_177956_o() >= 120) continue;
                if (vein.type == EnumVein.GUANO) {
                    this.generateGuano(world, vein, posX1, posZ1);
                    continue;
                }
                this.generateVein(world, vein, posX1, posZ1);
            }
        }
    }

    static boolean isPlaceable(IBlockState block) {
        if (!(!block.func_185915_l() || block.func_177230_c() instanceof BlockEmptyDrops || block.func_177230_c() instanceof BlockContainer || block.func_185904_a() != Material.field_151576_e && block.func_185904_a() != Material.field_151595_p && block.func_185904_a() != Material.field_151578_c && block.func_185904_a() != Material.field_151577_b)) {
            return !WorldGenConfig.disables.contains(new BlockSet(block.func_177230_c(), block.func_177230_c().func_176201_c(block)));
        }
        return false;
    }

    static boolean isPlaceable3(IBlockState block) {
        if (block.func_185915_l() && !(block.func_177230_c() instanceof BlockEmptyDrops) && (block.func_185904_a() == Material.field_151578_c || block.func_177230_c() == Blocks.field_150424_aL || block.func_177230_c() == Blocks.field_150425_aM)) {
            return !WorldGenConfig.disables.contains(new BlockSet(block.func_177230_c(), block.func_177230_c().func_176201_c(block)));
        }
        return false;
    }

    public void generateVein(World world, OreGenPos.OreVein vein, int limX, int limZ) {
        VeinTable table = VeinTableRegister.INSTANCE.getTable(vein.type);
        if (table == null) {
            return;
        }
        BlockPos pos = vein.pos;
        int r = vein.round;
        int h = r - 1;
        int[] rands = vein.rands;
        OreSet[] gen = new OreSet[h];
        block0: for (int i = 0; i < h; ++i) {
            List<Object> list = new ArrayList();
            int i1 = 0;
            list = table.getOreTable();
            i1 = world.field_73012_v.nextInt(table.tableCount + 1);
            int i2 = 0;
            for (OreSet oreSet : list) {
                if ((i2 += oreSet.getWeight()) >= i1) {
                    gen[i] = oreSet;
                    continue block0;
                }
                if (gen[i] != null) continue;
                gen[i] = (OreSet)list.get(0);
            }
        }
        float sx = 0.0f;
        float sz = 0.0f;
        if (rands.length > 0) {
            int i3 = rands[0];
            if (i3 < 11) {
                sx = (float)i3 / 10.0f;
                if ((i3 & 1) == 1) {
                    sx *= -1.0f;
                }
            } else {
                sz = (float)(i3 -= 10) / 10.0f;
                if ((i3 & 1) == 1) {
                    sz *= -1.0f;
                }
            }
        }
        for (int x = -r; x < r; ++x) {
            for (int z = -r; z < r; ++z) {
                for (int y = 0; y < h; ++y) {
                    if (pos.func_177958_n() + x <= limX || pos.func_177952_p() + z <= limZ) continue;
                    int n = MathHelper.func_76141_d((float)(sx * (float)x)) + MathHelper.func_76141_d((float)(sz * (float)z));
                    int h2 = y;
                    BlockPos p = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y + n, pos.func_177952_p() + z);
                    IBlockState block = world.func_180495_p(p);
                    double d1 = Math.sqrt(pos.func_177954_c((double)p.func_177958_n(), (double)pos.func_177956_o(), (double)p.func_177952_p()));
                    if (p.func_177956_o() <= 1 || p.func_177956_o() >= world.func_72940_L() || !(d1 < (double)r)) continue;
                    OreSet add = gen[h2];
                    if (block.func_185904_a() == Material.field_151577_b && !world.func_175623_d(p.func_177984_a()) || !WorldGenOres.isPlaceable(block) && !this.isForced) continue;
                    int j = world.field_73012_v.nextInt(100);
                    if (add.hasSecondOre() && j < add.getSecondChance()) {
                        world.func_180501_a(p, add.getSecondOre().getState(), this.isForced ? 3 : 2);
                        continue;
                    }
                    world.func_180501_a(p, add.getOre().getState(), this.isForced ? 3 : 2);
                }
            }
        }
    }

    public void generateNetherVein(World world, OreGenPos.OreVein vein, int limX, int limZ) {
        VeinTable table = VeinTableRegister.INSTANCE.getTable(vein.type);
        if (table == null) {
            return;
        }
        BlockPos pos = vein.pos;
        int r = vein.round;
        int h = r - 1;
        int[] rands = vein.rands;
        OreSet[] gen = new OreSet[h];
        block0: for (int i = 0; i < h; ++i) {
            List<Object> list = new ArrayList();
            int i1 = 0;
            list = table.getOreTable();
            i1 = world.field_73012_v.nextInt(table.tableCount);
            int i2 = 0;
            for (OreSet oreSet : list) {
                if ((i2 += oreSet.getWeight()) >= i1) {
                    gen[i] = oreSet;
                    continue block0;
                }
                if (gen[i] != null) continue;
                gen[i] = (OreSet)list.get(0);
            }
        }
        float sx = 0.0f;
        float sz = 0.0f;
        if (rands.length > 0) {
            int i3 = rands[0];
            if (i3 < 11) {
                sx = (float)i3 / 10.0f;
                if ((i3 & 1) == 1) {
                    sx *= -1.0f;
                }
            } else {
                sz = (float)(i3 -= 10) / 10.0f;
                if ((i3 & 1) == 1) {
                    sz *= -1.0f;
                }
            }
        }
        for (int x = -r; x < r; ++x) {
            for (int z = -r; z < r; ++z) {
                for (int y = 0; y < h; ++y) {
                    if (pos.func_177958_n() + x <= limX || pos.func_177952_p() + z <= limZ) continue;
                    int n = MathHelper.func_76141_d((float)(sx * (float)x)) + MathHelper.func_76141_d((float)(sz * (float)z));
                    int h2 = y;
                    BlockPos p = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y + n, pos.func_177952_p() + z);
                    IBlockState block = world.func_180495_p(p);
                    double d1 = Math.sqrt(pos.func_177954_c((double)p.func_177958_n(), (double)pos.func_177956_o(), (double)p.func_177952_p()));
                    if (p.func_177956_o() <= 1 || p.func_177956_o() >= world.func_72940_L() || !(d1 < (double)r)) continue;
                    OreSet add = gen[h2];
                    if (!WorldGenOres.isPlaceable3(block) && !this.isForced) continue;
                    int j = world.field_73012_v.nextInt(100);
                    if (add.hasSecondOre() && j < add.getSecondChance()) {
                        world.func_180501_a(p, add.getSecondOre().getState(), this.isForced ? 3 : 4);
                        continue;
                    }
                    world.func_180501_a(p, add.getOre().getState(), this.isForced ? 3 : 4);
                }
            }
        }
    }

    public void generateGuano(World world, OreGenPos.OreVein vein, int limX, int limZ) {
        VeinTable table = VeinTableRegister.INSTANCE.getTable(vein.type);
        if (table == null) {
            return;
        }
        BlockPos pos = vein.pos;
        int r = vein.round - 1;
        int h = r / 2 + 1;
        int[] rands = vein.rands;
        OreSet[] gen = new OreSet[h];
        block0: for (int i = 0; i < h; ++i) {
            if (i == 0) {
                gen[i] = table.layerStone;
                continue;
            }
            List<OreSet> list = table.getOreTable();
            int i1 = world.field_73012_v.nextInt(table.tableCount);
            int i2 = 0;
            for (OreSet set : list) {
                if ((i2 += set.getWeight()) >= i1) {
                    gen[i] = set;
                    continue block0;
                }
                if (gen[i] != null) continue;
                gen[i] = list.get(0);
            }
        }
        for (int x = pos.func_177958_n() - r; x < pos.func_177958_n() + r; ++x) {
            for (int z = pos.func_177952_p() - r; z < pos.func_177952_p() + r; ++z) {
                for (int y = pos.func_177956_o(); y < pos.func_177956_o() + h; ++y) {
                    boolean b2;
                    if (x <= limX || z <= limZ) continue;
                    BlockPos p = new BlockPos(x, y, z);
                    IBlockState block = world.func_180495_p(p);
                    double d1 = Math.sqrt(pos.func_177954_c((double)p.func_177958_n(), (double)pos.func_177956_o(), (double)p.func_177952_p()));
                    boolean b1 = world.func_180495_p(p.func_177981_b(1)).func_185904_a() == Material.field_151586_h;
                    boolean bl = b2 = world.func_180495_p(p.func_177981_b(2)).func_185904_a() == Material.field_151586_h;
                    if (p.func_177956_o() <= 1 || p.func_177956_o() >= world.func_72940_L() || !(d1 < (double)r) || !b1 && !b2) continue;
                    int height = p.func_177956_o() - pos.func_177956_o();
                    OreSet add = gen[height];
                    if (!WorldGenOres.isPlaceable(block) && !this.isForced) continue;
                    int j = world.field_73012_v.nextInt(100);
                    if (add.hasSecondOre() && j < add.getSecondChance()) {
                        world.func_180501_a(p, add.getSecondOre().getState(), this.isForced ? 3 : 4);
                        if (!b1 || !ModuleConfig.food) continue;
                        world.func_175656_a(p.func_177984_a(), FoodInit.cropSeaweed.func_176223_P());
                        continue;
                    }
                    world.func_180501_a(p, add.getOre().getState(), this.isForced ? 3 : 4);
                }
            }
        }
    }
}

