/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen.vein;

import defeatedcrow.hac.core.DCLogger;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenPosTest
implements IWorldGenerator {
    private int range = -1;
    private int forceX = 0;
    private int forceZ = 0;
    private static Random pRandom;

    public void setForcePos(int x, int z) {
        this.forceX = x;
        this.forceZ = z;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generatePos(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
    }

    public boolean generatePos(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        pRandom = new Random(world.func_72905_C() + (long)chunkX + (long)(chunkZ * 31));
        pRandom.nextInt(8);
        pRandom.nextInt(8);
        int genDim1 = world.field_73011_w.getDimension();
        if (genDim1 == 1 || genDim1 == -1) {
            return false;
        }
        if (chunkX > 3000 || chunkX < -3000) {
            return false;
        }
        if (chunkZ > 3000 || chunkZ < -3000) {
            return false;
        }
        int X = chunkX << 4;
        int Z = chunkZ << 4;
        int posX = X + 8 + pRandom.nextInt(8);
        int posZ = Z + 8 + pRandom.nextInt(8);
        BlockPos pos = new BlockPos(posX, 60, posZ);
        Biome biome = world.getBiomeForCoordsBody(pos);
        float temp = biome.func_185353_n();
        pRandom.nextFloat();
        float f = pRandom.nextFloat();
        if (f > 0.8f) {
            DCLogger.debugInfoLog((String)"==== WorldGen Test ====");
            DCLogger.debugInfoLog((String)("*Chunk: " + chunkX + ", " + chunkZ));
            DCLogger.debugInfoLog((String)("*Base Pos: " + X + ", " + Z));
            DCLogger.debugInfoLog((String)("*Pos: " + posX + ", " + posZ));
            DCLogger.debugInfoLog((String)("*Biome: " + biome.func_185359_l()));
            DCLogger.debugInfoLog((String)("*Float: " + String.format("%.3f", Float.valueOf(f))));
        }
        return true;
    }
}

