/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.main.worldgen.vein;

import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.core.util.BiomeCatchDC;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.api.orevein.EnumVein;
import defeatedcrow.hac.main.api.orevein.OreSet;
import defeatedcrow.hac.main.api.orevein.VeinTable;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.worldgen.vein.OreSetDC;
import defeatedcrow.hac.main.worldgen.vein.SkarnGenPos;
import defeatedcrow.hac.main.worldgen.vein.VeinTableRegister;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEmptyDrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenSkarn
implements IWorldGenerator {
    private final boolean isForced;
    private int forceX = 0;
    private int forceZ = 0;
    private static final BlockSet AIR = new BlockSet(Blocks.field_150350_a, 0);
    private static final BlockSet LAVA = new BlockSet((Block)Blocks.field_150353_l, 0);
    private static final BlockSet GRANITE = new BlockSet(Blocks.field_150348_b, 1);
    private static final BlockSet QUARTZ = new BlockSet(MainInit.skarnOre, 8);
    private static final BlockSet IRON = new BlockSet(MainInit.skarnOre, 8);
    private static final BlockSet COPPER = new BlockSet(MainInit.skarnOre, 8);
    private static final BlockSet[] LIME = new BlockSet[]{new BlockSet(MainInit.layerNew, 1), new BlockSet(MainInit.gemBlock, 6), new BlockSet(MainInit.skarnBlock, 2), new BlockSet(Blocks.field_150348_b, 1), new BlockSet(MainInit.oreNew, 4)};
    private static final BlockSet[] STONE = new BlockSet[]{new BlockSet(Blocks.field_150348_b, 0), new BlockSet(MainInit.skarnBlock, 0), new BlockSet(MainInit.skarnBlock, 2), new BlockSet(Blocks.field_150348_b, 1), new BlockSet(MainInit.oreNew, 4)};
    private static final BlockSet[] SAND = new BlockSet[]{new BlockSet(Blocks.field_150322_A, 0), new BlockSet(MainInit.skarnBlock, 1), new BlockSet(MainInit.skarnBlock, 2), new BlockSet(Blocks.field_150348_b, 1), new BlockSet(MainInit.oreNew, 0)};
    private static final OreSet LIME_ORE = new OreSetDC(100, new BlockSet(MainInit.skarnOre, 0), new BlockSet(MainInit.skarnOre, 1), 20);
    private static final OreSet HORNFELS_ORE = new OreSetDC(100, new BlockSet(MainInit.skarnOre, 2), new BlockSet(MainInit.skarnOre, 3), 20);
    private static final OreSet GREISEN_ORE = new OreSetDC(100, new BlockSet(MainInit.skarnOre, 5), new BlockSet(MainInit.skarnOre, 4), 20);
    private static final OreSet SKARN_ORE = new OreSetDC(100, new BlockSet(MainInit.skarnOre, 6), new BlockSet(MainInit.skarnOre, 7), 20);

    public WorldGenSkarn(boolean force) {
        this.isForced = force;
    }

    public void setForcePos(int x, int z) {
        this.forceX = x;
        this.forceZ = z;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!ModuleConfig.world) {
            return;
        }
        int genDim1 = world.field_73011_w.getDimension();
        if (genDim1 == 1 || genDim1 == -1) {
            return;
        }
        if (Math.abs(chunkX) > 2000 || Math.abs(chunkZ) > 2000) {
            return;
        }
        if (!world.func_72964_e(chunkX, chunkZ).func_177410_o()) {
            return;
        }
        BlockPos center = SkarnGenPos.getNearestPoint(chunkX, chunkZ, world, 2);
        if (center == null) {
            return;
        }
        if (SkarnGenPos.isDupe(center, world)) {
            return;
        }
        int cx2 = center.func_177958_n() >> 4;
        int cz2 = center.func_177952_p() >> 4;
        if (chunkX == cx2 && chunkZ == cz2) {
            DCLogger.debugInfoLog((String)("Generation skarn : " + chunkX + "," + chunkZ));
        }
        int posX = chunkX << 4;
        int posZ = chunkZ << 4;
        posX += 4;
        posZ += 4;
        if (this.isForced && this.forceX != 0 & this.forceZ != 0) {
            posX = this.forceX;
            posZ = this.forceZ;
        }
        BlockPos pos = new BlockPos(posX, 40, posZ);
        Random rand2 = new Random(world.func_72905_C() + (long)cx2 + (long)(cz2 * 31));
        OreSet[] ores = this.getBlockSet2(rand2, BiomeCatchDC.getBiome((BlockPos)pos, (World)world));
        for (int x = posX; x < posX + 16; ++x) {
            for (int z = posZ; z < posZ + 16; ++z) {
                BlockPos p1 = new BlockPos(x, 40, z);
                Biome biome = BiomeCatchDC.getBiome((BlockPos)p1, (World)world);
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                    center = new BlockPos(center.func_177958_n(), 30, center.func_177952_p());
                }
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
                    center = new BlockPos(center.func_177958_n(), 50, center.func_177952_p());
                }
                int height = SkarnGenPos.getGenHeight(world, p1, center);
                for (int y = height * 2; y > 2; --y) {
                    BlockPos p = new BlockPos(x, y, z);
                    IBlockState block = world.func_180495_p(p);
                    OreSet set = this.getBlockSet1(y, height, rand2, biome);
                    if (WorldGenSkarn.isPlaceable(block, this.isForced)) {
                        if (y == height && y > 5) {
                            set = new OreSetDC(100, QUARTZ);
                        } else if ((double)y > (double)height * 0.8 && (double)y < (double)height * 1.2 && y > 5) {
                            int h = y - (int)((double)height * 0.8);
                            if (h < 0) {
                                h = -h;
                            }
                            if (h > 19) {
                                h = 0;
                            }
                            if (ores[h] != null) {
                                set = ores[h];
                            }
                        }
                        if (set == null) continue;
                        if (set.hasSecondOre() && world.field_73012_v.nextInt(100) < set.getSecondChance()) {
                            world.func_180501_a(p, set.getSecondOre().getState(), 2);
                            continue;
                        }
                        world.func_180501_a(p, set.getOre().getState(), 2);
                        continue;
                    }
                    if (block == null || block.func_185904_a() != Material.field_151577_b || !world.func_175623_d(p.func_177984_a()) || !world.field_73012_v.nextBoolean()) continue;
                    world.func_180501_a(p, AIR.getState(), 2);
                }
            }
        }
    }

    private OreSet getBlockSet1(int y, int height, Random rand, Biome biome) {
        if (y == height) {
            return new OreSetDC(100, QUARTZ);
        }
        BlockSet[] blocks = STONE;
        if (biome != null) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                blocks = SAND;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                blocks = LIME;
            }
        }
        if (y < height / 2) {
            if (y < 11) {
                return new OreSetDC(100, LAVA);
            }
            if (y < 14) {
                return new OreSetDC(100, AIR);
            }
            return new OreSetDC(100, blocks[3]);
        }
        if (y < height) {
            if (rand.nextInt(100) == 1) {
                return GREISEN_ORE;
            }
            return new OreSetDC(100, blocks[2]);
        }
        if ((double)y < (double)height * 1.5) {
            if (rand.nextInt(100) == 1) {
                if (blocks == LIME) {
                    return LIME_ORE;
                }
                if (blocks == SAND) {
                    return HORNFELS_ORE;
                }
                if (blocks == STONE) {
                    return SKARN_ORE;
                }
            }
            return new OreSetDC(100, blocks[1]);
        }
        return new OreSetDC(100, blocks[0]);
    }

    private OreSet[] getBlockSet2(Random rand, Biome biome) {
        VeinTable table = VeinTableRegister.INSTANCE.getTable(EnumVein.SKARN_IRON);
        if (biome != null && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP))) {
            table = VeinTableRegister.INSTANCE.getTable(EnumVein.SKARN_COPPER);
        }
        OreSet[] ret = new OreSet[20];
        if (table != null) {
            List<OreSet> list = table.getOreTable();
            block0: for (int i = 0; i < 20; ++i) {
                int i1 = rand.nextInt(table.tableCount);
                int i2 = 0;
                for (OreSet set : list) {
                    if ((i2 += set.getWeight()) < i1) continue;
                    ret[i] = set;
                    continue block0;
                }
            }
        }
        return ret;
    }

    static boolean isPlaceable(IBlockState block, boolean b) {
        if (block.func_185915_l() && !(block.func_177230_c() instanceof BlockEmptyDrops) && !block.func_177230_c().func_149739_a().contains("ore")) {
            return block.func_185904_a() == Material.field_151576_e || block.func_185904_a() == Material.field_151595_p || block.func_177230_c().func_149739_a().contains("gravel") || block.func_177230_c().func_149739_a().contains("dirt");
        }
        return b;
    }

    static boolean isPlaceable2(IBlockState block, boolean b) {
        if (block.func_185915_l() && !(block.func_177230_c() instanceof BlockEmptyDrops) && !block.func_177230_c().func_149739_a().contains("ore")) {
            return block.func_185904_a() == Material.field_151576_e || block.func_185904_a() == Material.field_151595_p || block.func_177230_c().func_149739_a().contains("gravel") || block.func_177230_c().func_149739_a().contains("dirt");
        }
        return b;
    }
}

