/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.potion.Potion;
import net.minecraftforge.fluids.Fluid;

public class DrinkPotionType {
    public static final DrinkPotionType INSTANCE = new DrinkPotionType();
    private static final Map<String, PotionSet> effects = new HashMap<String, PotionSet>();

    private DrinkPotionType() {
    }

    public static boolean isRegistered(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        for (String name : effects.keySet()) {
            if (!fluid.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegistered(String fluidName) {
        for (String name : effects.keySet()) {
            if (!fluidName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static Potion getPotion(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        for (String name : effects.keySet()) {
            if (!fluid.getName().equalsIgnoreCase(name)) continue;
            return DrinkPotionType.effects.get((Object)name).potion;
        }
        return null;
    }

    public static PotionSet getPotionSet(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        for (String name : effects.keySet()) {
            if (!fluid.getName().equalsIgnoreCase(name)) continue;
            return effects.get(name);
        }
        return null;
    }

    public static void registerPotion(String name, Potion potion) {
        if (name == null || potion == null) {
            return;
        }
        DrinkPotionType drinkPotionType = INSTANCE;
        drinkPotionType.getClass();
        DrinkPotionType.registerPotion(name, drinkPotionType.new PotionSet(potion, 0));
    }

    public static void registerPotion(String name, Potion potion, int amp) {
        if (name == null || potion == null) {
            return;
        }
        DrinkPotionType drinkPotionType = INSTANCE;
        drinkPotionType.getClass();
        DrinkPotionType.registerPotion(name, drinkPotionType.new PotionSet(potion, amp));
    }

    public static void registerPotion(String name, PotionSet potion) {
        if (name == null || potion == null) {
            return;
        }
        if (!DrinkPotionType.isRegistered(name)) {
            effects.put(name, potion);
        }
    }

    public class PotionSet {
        public final Potion potion;
        public final int amp;

        public PotionSet(Potion pIn, int aIn) {
            this.potion = pIn;
            this.amp = aIn;
        }

        public int hashCode() {
            return Potion.func_188409_a((Potion)this.potion) + this.amp * 127;
        }
    }
}

