/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.cofh;

import cofh.redstoneflux.api.IEnergyConnection;
import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.api.IEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class RFDeviceHelper {
    private RFDeviceHelper() {
    }

    public static boolean isRFConnector(TileEntity tile) {
        return tile instanceof IEnergyConnection || tile instanceof IEnergyStorage;
    }

    public static boolean isRFStorage(TileEntity tile) {
        return tile instanceof IEnergyStorage;
    }

    public static int getStorageAmount(TileEntity tile) {
        if (tile instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)tile;
            return storage.getEnergyStored();
        }
        return 0;
    }

    public static int getStorageMax(TileEntity tile) {
        if (tile instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)tile;
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    public static boolean isRFReceiver(TileEntity tile) {
        return tile instanceof IEnergyReceiver;
    }

    public static int inputEnergy(EnumFacing dir, TileEntity tile, int amount, boolean simulate) {
        IEnergyReceiver handler;
        int ret = 0;
        if (RFDeviceHelper.isRFReceiver(tile) && (handler = (IEnergyReceiver)tile).canConnectEnergy(dir)) {
            ret = handler.receiveEnergy(dir, amount, simulate);
        }
        return ret;
    }

    public static boolean isRFProvider(TileEntity tile) {
        return tile instanceof IEnergyProvider;
    }

    public static int extractEnergy(EnumFacing dir, TileEntity tile, int amount, boolean simulate) {
        IEnergyProvider handler;
        int ret = 0;
        if (RFDeviceHelper.isRFProvider(tile) && (handler = (IEnergyProvider)tile).canConnectEnergy(dir)) {
            ret = handler.extractEnergy(dir, amount, simulate);
        }
        return ret;
    }

    public static boolean isRFHandler(TileEntity tile) {
        return tile instanceof IEnergyHandler;
    }

    public static int getHandlerAmount(TileEntity tile, EnumFacing side) {
        if (tile instanceof IEnergyHandler) {
            IEnergyHandler storage = (IEnergyHandler)tile;
            return storage.getEnergyStored(side);
        }
        return 0;
    }

    public static int getHandlerMax(TileEntity tile, EnumFacing side) {
        if (tile instanceof IEnergyHandler) {
            IEnergyHandler storage = (IEnergyHandler)tile;
            return storage.getMaxEnergyStored(side);
        }
        return 0;
    }
}

