/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.forestry;

import defeatedcrow.hac.api.cultivate.GrowingStage;
import defeatedcrow.hac.api.cultivate.IClimateCrop;
import defeatedcrow.hac.core.base.ClimateCropBase;
import forestry.api.farming.ICrop;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DCCrop
implements ICrop {
    protected final World world;
    protected final BlockPos pos;
    protected final IBlockState state;

    public DCCrop(World w, BlockPos p, IBlockState s) {
        this.world = w;
        this.pos = p;
        this.state = s;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    protected boolean isCrop(World world, BlockPos pos) {
        if (this.state.func_177230_c() instanceof IClimateCrop) {
            IBlockState grown = ((IClimateCrop)this.state.func_177230_c()).getGrownState();
            GrowingStage stage = ((IClimateCrop)this.state.func_177230_c()).getCurrentStage(grown);
            return stage == GrowingStage.GROWN;
        }
        return false;
    }

    public NonNullList<ItemStack> harvest() {
        Block cropB;
        NonNullList ret = NonNullList.func_191196_a();
        IBlockState target = this.world.func_180495_p(this.pos);
        if (this.isCrop(this.world, this.pos) && (cropB = this.state.func_177230_c()) instanceof ClimateCropBase) {
            ClimateCropBase crop = (ClimateCropBase)cropB;
            ret.addAll((Collection)crop.getCropItems(target, 0));
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, this.pos, target);
            NetworkUtil.sendNetworkPacket((IForestryPacketClient)packet, (BlockPos)this.pos, (World)this.world);
            IBlockState next = crop.setGroundState(target);
            this.world.func_180501_a(this.pos, next, 2);
        }
        return ret;
    }

    public String toString() {
        return String.format("HeatAndClimate [ position: [ %s ]; block: %s]", this.pos.toString(), this.state);
    }
}

