/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.forestry;

import defeatedcrow.hac.api.cultivate.GrowingStage;
import defeatedcrow.hac.core.base.ClimateDoubleCropBase;
import forestry.api.farming.ICrop;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DCCropDouble
implements ICrop {
    protected final World world;
    protected final BlockPos pos;
    protected final IBlockState state;

    public DCCropDouble(World w, BlockPos p, IBlockState s) {
        this.world = w;
        this.pos = p;
        this.state = s;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    protected boolean isCrop(World world, BlockPos pos) {
        IBlockState target = world.func_180495_p(pos);
        if (target.func_177230_c() instanceof ClimateDoubleCropBase) {
            return ((ClimateDoubleCropBase)target.func_177230_c()).getCurrentStage(target) == GrowingStage.GROWN;
        }
        return false;
    }

    public NonNullList<ItemStack> harvest() {
        Block cropB;
        IBlockState target = this.world.func_180495_p(this.pos);
        NonNullList ret = NonNullList.func_191196_a();
        if (this.isCrop(this.world, this.pos) && (cropB = this.state.func_177230_c()) instanceof ClimateDoubleCropBase) {
            ClimateDoubleCropBase crop = (ClimateDoubleCropBase)cropB;
            ret.addAll((Collection)crop.getCropItems(target, 0));
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, this.pos, target);
            NetworkUtil.sendNetworkPacket((IForestryPacketClient)packet, (BlockPos)this.pos, (World)this.world);
            IBlockState next = crop.setGroundState(target);
            this.world.func_180501_a(this.pos, next, 2);
        }
        return ret;
    }

    public String toString() {
        return String.format("HeatAndClimate [ position: [ %s ]; block: %s]", this.pos.toString(), this.state);
    }
}

