/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.forestry;

import defeatedcrow.hac.api.cultivate.GrowingStage;
import defeatedcrow.hac.core.base.ClimateDoubleCropBase;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.plugin.forestry.DCCropDouble;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DCFarmableDouble
implements IFarmable {
    protected final ClimateDoubleCropBase crop;

    public DCFarmableDouble(ClimateDoubleCropBase c) {
        this.crop = c;
    }

    public ICrop getCropAt(World world, BlockPos pos, IBlockState state) {
        if (this.crop.getCurrentStage(state) == GrowingStage.GROWN) {
            return new DCCropDouble(world, pos, state);
        }
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof ClimateDoubleCropBase) {
            IBlockState up = world.func_180495_p(pos.func_177984_a());
            return new DCCropDouble(world, pos.func_177984_a(), up);
        }
        return null;
    }

    public boolean isGermling(ItemStack item) {
        ItemStack seed = this.crop.getSeedItem(this.crop.func_176223_P());
        if (!DCUtil.isEmpty((ItemStack)item)) {
            return DCUtil.isSameItem((ItemStack)seed, (ItemStack)item, (boolean)false);
        }
        return false;
    }

    public boolean isSaplingAt(World world, BlockPos pos) {
        IBlockState target = world.func_180495_p(pos);
        if (target.func_177230_c() instanceof ClimateDoubleCropBase) {
            return target == this.crop.func_176223_P();
        }
        return false;
    }

    public boolean isWindfall(ItemStack item) {
        return false;
    }

    public boolean plantSaplingAt(EntityPlayer player, ItemStack item, World world, BlockPos pos) {
        IBlockState plant = this.crop.func_176223_P();
        return BlockUtil.setBlockWithPlaceSound((World)world, (BlockPos)pos, (IBlockState)plant);
    }
}

