/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.jei;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.plugin.jei.ingredients.AirflowRenderer;
import defeatedcrow.hac.core.plugin.jei.ingredients.ClimateTypes;
import defeatedcrow.hac.core.plugin.jei.ingredients.HeatTierRenderer;
import defeatedcrow.hac.core.plugin.jei.ingredients.HumidityRenderer;
import defeatedcrow.hac.plugin.jei.ClimateFluidWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ClimateFluidCategory
implements IRecipeCategory {
    private final IDrawableStatic background;

    public ClimateFluidCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("dcs_climate", "textures/gui/c_fluid_gui_jei.png");
        this.background = guiHelper.createDrawable(location, 8, 8, 160, 56);
    }

    public String getUid() {
        return "dcs_climate.drink";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.getUid(), (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft mc) {
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        DCAirflow air;
        DCHumidity hum;
        if (!(recipeWrapper instanceof ClimateFluidWrapper)) {
            return;
        }
        ClimateFluidWrapper wrapper = (ClimateFluidWrapper)recipeWrapper;
        FluidStack input = wrapper.getFluidInput();
        if (input != null) {
            recipeLayout.getFluidStacks().init(0, false, 24, 20, 13, 13, 1000, false, null);
            recipeLayout.getFluidStacks().set(0, input);
        }
        recipeLayout.getItemStacks().init(0, true, 22, 38);
        recipeLayout.getItemStacks().set(0, wrapper.cup);
        DCHeatTier temp = wrapper.getTemp();
        if (temp != null) {
            recipeLayout.getIngredientsGroup((IIngredientType)ClimateTypes.TEMP).init(0, true, (IIngredientRenderer)new HeatTierRenderer(), 51, 13, 40, 5, 0, 0);
            recipeLayout.getIngredientsGroup((IIngredientType)ClimateTypes.TEMP).set(0, (Object)temp);
        }
        if ((hum = wrapper.getHum()) != null) {
            recipeLayout.getIngredientsGroup((IIngredientType)ClimateTypes.HUM).init(0, true, (IIngredientRenderer)new HumidityRenderer(), 51, 24, 40, 5, 0, 0);
            recipeLayout.getIngredientsGroup((IIngredientType)ClimateTypes.HUM).set(0, (Object)hum);
        }
        if ((air = wrapper.getAir()) != null) {
            recipeLayout.getIngredientsGroup((IIngredientType)ClimateTypes.AIR).init(0, true, (IIngredientRenderer)new AirflowRenderer(), 51, 35, 40, 5, 0, 0);
            recipeLayout.getIngredientsGroup((IIngredientType)ClimateTypes.AIR).set(0, (Object)air);
        }
    }

    public String getModName() {
        return "HeatAndClimateLib";
    }
}

