/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.jei;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.plugin.jei.ingredients.ClimateTypes;
import defeatedcrow.hac.plugin.jei.DCFluidInfo;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ClimateFluidWrapper
implements IRecipeWrapper {
    private final DCFluidInfo recipe;
    public final DCHeatTier temp;
    public final DCHumidity hum;
    public final DCAirflow air;
    public final FluidStack fluidstack;
    public final ItemStack bucket;
    public final ItemStack cup;

    public ClimateFluidWrapper(DCFluidInfo info) {
        this.recipe = info;
        this.temp = this.recipe.temp;
        this.hum = this.recipe.hum;
        this.air = this.recipe.air;
        this.fluidstack = this.recipe.stack;
        this.cup = info.cup;
        this.bucket = info.bucket;
    }

    public void getIngredients(IIngredients ing) {
        ArrayList items = Lists.newArrayList();
        items.add(this.cup);
        items.add(this.bucket);
        ing.setInput((IIngredientType)ClimateTypes.TEMP, (Object)this.temp);
        ing.setInput((IIngredientType)ClimateTypes.HUM, (Object)this.hum);
        ing.setInput((IIngredientType)ClimateTypes.AIR, (Object)this.air);
        ing.setInput(VanillaTypes.FLUID, (Object)this.fluidstack);
        ing.setInputs(VanillaTypes.ITEM, (List)items);
    }

    public DCHeatTier getTemp() {
        return this.temp;
    }

    public DCHumidity getHum() {
        return this.hum;
    }

    public DCAirflow getAir() {
        return this.air;
    }

    public FluidStack getFluidInput() {
        return this.fluidstack;
    }

    public ItemStack getCup() {
        return this.cup;
    }

    public void drawInfo(Minecraft mc, int wid, int hei, int mouseX, int mouseY) {
        int baseY = 0;
        ResourceLocation res = new ResourceLocation("dcs_climate", "textures/gui/c_effective_gui.png");
        mc.func_110434_K().func_110577_a(res);
        if (this.temp != null) {
            if (this.temp.getID() > 6) {
                mc.field_71462_r.func_73729_b(51, baseY + 14, this.temp.getID() * 20 - 140, 174, 20, 3);
                mc.field_71462_r.func_73729_b(71, baseY + 14, this.temp.getID() * 20 - 140, 174, 20, 3);
            } else {
                mc.field_71462_r.func_73729_b(51, baseY + 14, this.temp.getID() * 20, 170, 20, 3);
                mc.field_71462_r.func_73729_b(71, baseY + 14, this.temp.getID() * 20, 170, 20, 3);
            }
        }
        if (this.hum != null) {
            mc.field_71462_r.func_73729_b(51, baseY + 25, this.hum.getID() * 40, 178, 40, 3);
        }
        if (this.air != null) {
            mc.field_71462_r.func_73729_b(51, baseY + 36, this.air.getID() * 40, 182, 40, 3);
        }
        String t = this.temp == null ? "  -" : this.temp.localize();
        mc.field_71466_p.func_175065_a(t, 100.0f, (float)(baseY + 11), 0x993030, false);
        String h = this.hum == null ? "  -" : this.hum.localize();
        mc.field_71466_p.func_175065_a(h, 100.0f, (float)(baseY + 22), 0x303099, false);
        String a = this.air == null ? "  -" : this.air.localize();
        mc.field_71466_p.func_175065_a(a, 100.0f, (float)(baseY + 33), 0x309930, false);
        mc.field_71466_p.func_175065_a(this.recipe.getFluidName(), 5.0f, (float)baseY, 0, false);
        mc.field_71466_p.func_175065_a(this.recipe.getDrinkEffect(), 45.0f, (float)(baseY + 46), 0, false);
    }

    public List<String> getTooltipStrings(int x, int y) {
        ArrayList s = new ArrayList();
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

