/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.jei;

import com.google.common.collect.ImmutableList;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.plugin.jei.ingredients.ClimateTypes;
import defeatedcrow.hac.main.api.brewing.IAgingRecipeDC;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.FluidStack;

public class DCAgingWrapper
implements IRecipeWrapper {
    private final List<FluidStack> inF = new ArrayList<FluidStack>();
    private final List<FluidStack> outF = new ArrayList<FluidStack>();
    private final List<DCHeatTier> temps;
    private final List<DCHumidity> hums;
    private final List<DCAirflow> airs;
    private final int count;

    public DCAgingWrapper(IAgingRecipeDC recipe) {
        this.count = recipe.agingDay();
        if (recipe.getInputFluid() != null) {
            this.inF.add(recipe.getInputFluid());
        }
        if (recipe.getOutputFluid() != null) {
            this.outF.add(recipe.getOutputFluid());
        }
        this.temps = ImmutableList.of((Object)DCHeatTier.COLD, (Object)DCHeatTier.COOL, (Object)DCHeatTier.NORMAL, (Object)DCHeatTier.WARM, (Object)DCHeatTier.HOT);
        this.hums = ImmutableList.of((Object)DCHumidity.DRY, (Object)DCHumidity.NORMAL, (Object)DCHumidity.WET);
        this.airs = ImmutableList.of((Object)DCAirflow.TIGHT, (Object)DCAirflow.NORMAL);
    }

    public int getDay() {
        return this.count;
    }

    public List<DCAirflow> getAirs() {
        return this.airs;
    }

    public List<DCHumidity> getHums() {
        return this.hums;
    }

    public List<DCHeatTier> getTemps() {
        return this.temps;
    }

    public void getIngredients(IIngredients ing) {
        ing.setInputs(VanillaTypes.FLUID, this.inF);
        ing.setOutputs(VanillaTypes.FLUID, this.outF);
        ing.setInputs((IIngredientType)ClimateTypes.TEMP, this.temps);
        ing.setInputs((IIngredientType)ClimateTypes.HUM, this.hums);
        ing.setInputs((IIngredientType)ClimateTypes.AIR, this.airs);
    }

    public List<FluidStack> getFluidInputs() {
        return this.inF;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.outF;
    }

    public void drawInfo(Minecraft mc, int wid, int hei, int mouseX, int mouseY) {
        String s = I18n.func_135052_a((String)(this.count + " Day"), (Object[])new Object[0]);
        mc.field_71466_p.func_78279_b(s, 67, 42, 110, 0);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

