/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.jei;

import com.google.common.collect.ImmutableList;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.plugin.jei.ingredients.ClimateTypes;
import defeatedcrow.hac.main.api.brewing.IBrewingRecipeDC;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class DCBrewingWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> input;
    private final List<ItemStack> output;
    private final IBrewingRecipeDC rec;
    private final List<FluidStack> inF;
    private final List<FluidStack> outF;
    private final List<DCHeatTier> temps;
    private final List<DCHumidity> hums;
    private final List<DCAirflow> airs;

    public DCBrewingWrapper(IBrewingRecipeDC recipe) {
        this.rec = recipe;
        this.input = new ArrayList<List<ItemStack>>();
        if (!recipe.getProcessedInput().isEmpty()) {
            for (Object obj : recipe.getProcessedInput()) {
                if (obj instanceof ItemStack) {
                    ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
                    ret.add((ItemStack)obj);
                    this.input.add(ret);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                this.input.add((List)obj);
            }
        }
        this.output = new ArrayList<ItemStack>();
        this.output.add(recipe.getOutput());
        this.inF = new ArrayList<FluidStack>();
        this.outF = new ArrayList<FluidStack>();
        if (recipe.getInputFluid() != null) {
            this.inF.add(recipe.getInputFluid());
        }
        if (recipe.getOutputFluid() != null) {
            this.outF.add(recipe.getOutputFluid());
        }
        this.temps = ImmutableList.of((Object)DCHeatTier.COOL, (Object)DCHeatTier.NORMAL, (Object)DCHeatTier.WARM, (Object)DCHeatTier.HOT);
        this.hums = ImmutableList.of((Object)DCHumidity.NORMAL, (Object)DCHumidity.WET);
        this.airs = ImmutableList.of((Object)DCAirflow.TIGHT, (Object)DCAirflow.NORMAL);
    }

    public List<List<ItemStack>> getRecipeInputs() {
        return this.input;
    }

    public List<DCAirflow> getAirs() {
        return this.airs;
    }

    public List<DCHumidity> getHums() {
        return this.hums;
    }

    public List<DCHeatTier> getTemps() {
        return this.temps;
    }

    public void getIngredients(IIngredients ing) {
        ing.setInputLists(VanillaTypes.ITEM, this.input);
        ing.setInputs(VanillaTypes.FLUID, this.inF);
        ing.setOutputs(VanillaTypes.ITEM, this.output);
        ing.setOutputs(VanillaTypes.FLUID, this.outF);
        ing.setInputs((IIngredientType)ClimateTypes.TEMP, this.temps);
        ing.setInputs((IIngredientType)ClimateTypes.HUM, this.hums);
        ing.setInputs((IIngredientType)ClimateTypes.AIR, this.airs);
    }

    public List<List<ItemStack>> getInputs() {
        return this.input;
    }

    public List<ItemStack> getOutputs() {
        return this.output;
    }

    public List<FluidStack> getFluidInputs() {
        return this.inF;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.outF;
    }

    public void drawInfo(Minecraft mc, int wid, int hei, int mouseX, int mouseY) {
        DCHeatTier minT = DCHeatTier.INFERNO;
        DCHumidity maxH = DCHumidity.DRY;
        DCAirflow maxA = DCAirflow.TIGHT;
        int baseX = 38;
        int baseY = 75;
        ResourceLocation res = new ResourceLocation("dcs_climate", "textures/gui/c_fluidcraft_gui_jei.png");
        mc.func_110434_K().func_110577_a(res);
        if (this.temps.isEmpty()) {
            mc.field_71462_r.func_73729_b(baseX, baseY, 0, 170, 84, 3);
            minT = DCHeatTier.NORMAL;
        } else {
            for (DCHeatTier dCHeatTier : this.temps) {
                mc.field_71462_r.func_73729_b(baseX + dCHeatTier.getID() * 6, baseY, dCHeatTier.getID() * 6, 170, 6, 3);
                if (dCHeatTier.getID() >= minT.getID()) continue;
                minT = dCHeatTier;
            }
        }
        if (this.hums.isEmpty()) {
            mc.field_71462_r.func_73729_b(baseX, baseY + 10, 0, 174, 84, 3);
            maxH = DCHumidity.NORMAL;
        } else {
            for (DCHumidity dCHumidity : this.hums) {
                mc.field_71462_r.func_73729_b(baseX + dCHumidity.getID() * 21, baseY + 10, dCHumidity.getID() * 21, 174, 21, 3);
                if (maxH.getID() >= dCHumidity.getID()) continue;
                maxH = dCHumidity;
            }
        }
        if (this.airs.isEmpty()) {
            mc.field_71462_r.func_73729_b(baseX, baseY + 20, 0, 178, 84, 3);
            maxA = DCAirflow.NORMAL;
        } else {
            for (DCAirflow dCAirflow : this.airs) {
                mc.field_71462_r.func_73729_b(baseX + dCAirflow.getID() * 21, baseY + 20, dCAirflow.getID() * 21, 178, 21, 3);
                if (maxA.getID() >= dCAirflow.getID()) continue;
                maxA = dCAirflow;
            }
        }
        IClimate clm = ClimateAPI.register.getClimateFromParam(minT, maxH, maxA);
        FluidStack fluidStack = this.inF.isEmpty() ? null : this.inF.get(0);
    }

    public List<String> getTooltipStrings(int x, int y) {
        int i;
        int baseY = 72;
        ArrayList<String> s = new ArrayList<String>();
        if (y > baseY && y < baseY + 8 && x > 38 && x < 122) {
            i = (x - 38) / 6;
            s.add(DCHeatTier.getTypeByID((int)i).localize() + " " + DCHeatTier.getTypeByID((int)i).getTemp());
        }
        if (y > baseY + 10 && y < baseY + 18 && x > 38 && x < 122) {
            i = (x - 38) / 21;
            s.add(DCHumidity.getTypeByID((int)i).localize());
        }
        if (y > baseY + 20 && y < baseY + 28 && x > 38 && x < 122) {
            i = (x - 38) / 21;
            s.add(DCAirflow.getTypeByID((int)i).localize());
        }
        return s.isEmpty() ? null : s;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

