/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.jei;

import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.fluid.FluidDic;
import defeatedcrow.hac.core.fluid.FluidDictionaryDC;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.plugin.DrinkPotionType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DCFluidInfo {
    public final DCHeatTier temp;
    public final DCHumidity hum;
    public final DCAirflow air;
    public final Fluid fluid;
    public final FluidStack stack;
    public final Potion potion;
    public final PotionEffect effect;
    public final boolean clearPotion;
    public final String dictionary;
    public final ItemStack cup;
    public final ItemStack bucket;

    public DCFluidInfo(Fluid recipe) {
        this.fluid = recipe;
        this.stack = new FluidStack(recipe, 1000);
        Block block = this.fluid.getBlock();
        this.temp = block != null ? (ClimateAPI.registerBlock.isRegisteredHeat(block, 0) ? ClimateAPI.registerBlock.getHeatTier(block, 0) : DCHeatTier.getTypeByTemperature((int)this.fluid.getTemperature())) : null;
        this.hum = block != null ? (ClimateAPI.registerBlock.isRegisteredHum(block, 0) ? ClimateAPI.registerBlock.getHumidity(block, 0) : (block.func_176223_P().func_185904_a() == Material.field_151586_h ? DCHumidity.UNDERWATER : DCHumidity.NORMAL)) : null;
        this.air = block != null ? (ClimateAPI.registerBlock.isRegisteredAir(block, 0) ? ClimateAPI.registerBlock.getAirflow(block, 0) : DCAirflow.NORMAL) : null;
        this.bucket = this.fluid.getBlock() != null ? new ItemStack(Items.field_151133_ar) : ItemStack.field_190927_a;
        FluidDic dic = FluidDictionaryDC.getDic((Fluid)this.fluid);
        this.dictionary = dic != null ? dic.dicName : "No DicName";
        if (DrinkPotionType.isRegistered(this.fluid)) {
            this.potion = DrinkPotionType.getPotion(recipe);
            this.effect = this.potion == MobEffects.field_76432_h || this.potion == MobEffects.field_76433_i ? new PotionEffect(this.potion, 1, 0) : (this.potion.func_76398_f() ? new PotionEffect(this.potion, 600, 0) : new PotionEffect(this.potion, 1200, 0));
            this.cup = ModuleConfig.food ? new ItemStack(FoodInit.cupSilver) : ItemStack.field_190927_a;
        } else {
            this.potion = null;
            this.effect = null;
            this.cup = ItemStack.field_190927_a;
        }
        this.clearPotion = FluidDictionaryDC.matchFluidName((Fluid)this.fluid, (String)"milk") || this.fluid == MainInit.soyMilk || this.fluid == MainInit.tomatoJuice;
    }

    public String getFluidName() {
        return this.fluid.getLocalizedName(new FluidStack(this.fluid, 1000)) + " (Dic: " + this.dictionary + ")";
    }

    public String getDrinkEffect() {
        String drink = "";
        drink = this.clearPotion ? drink + I18n.func_135052_a((String)"dcs.tip.clear_potion", (Object[])new Object[0]) : (this.effect != null ? drink + I18n.func_135052_a((String)this.effect.func_76453_d(), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("potion.potency." + this.effect.func_76458_c()), (Object[])new Object[0]).trim() + "(" + Potion.func_188410_a((PotionEffect)this.effect, (float)1.0f) + ")" : drink + I18n.func_135052_a((String)"No Effect", (Object[])new Object[0]));
        return drink;
    }
}

