/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.jei;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.plugin.jei.ingredients.ClimateTypes;
import defeatedcrow.hac.main.api.IHeatTreatment;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class DCHeatTreatmentWrapper
implements IRecipeWrapper {
    private final IHeatTreatment rec;
    private final List<ItemStack> input1;
    private final List<ItemStack> input2;
    private final List<ItemStack> input3;
    private final List<ItemStack> output;
    private final List<List<DCHeatTier>> temps;
    private final List<List<DCHumidity>> hums;
    private final List<List<DCAirflow>> airs;
    public int time1 = 0;
    public int time2 = 0;
    public int time3 = 0;

    public DCHeatTreatmentWrapper(IHeatTreatment recipe) {
        this.rec = recipe;
        this.input1 = new ArrayList<ItemStack>();
        this.input2 = new ArrayList<ItemStack>();
        this.input3 = new ArrayList<ItemStack>();
        this.output = new ArrayList<ItemStack>();
        this.output.add(recipe.getOutput());
        this.output.add(recipe.getFail());
        this.temps = new ArrayList<List<DCHeatTier>>();
        this.hums = new ArrayList<List<DCHumidity>>();
        this.airs = new ArrayList<List<DCAirflow>>();
        this.input1.addAll(this.rec.getInput1());
        this.time1 = recipe.getBurnTime1();
        if (recipe.getTemp1().isEmpty()) {
            this.temps.add(DCHeatTier.createList());
        } else {
            this.temps.add(recipe.getTemp1());
        }
        if (recipe.getHum1().isEmpty()) {
            this.hums.add(DCHumidity.createList());
        } else {
            this.hums.add(recipe.getHum1());
        }
        if (recipe.getAir1().isEmpty()) {
            this.airs.add(DCAirflow.createList());
        } else {
            this.airs.add(recipe.getAir1());
        }
        if (!recipe.getInput2().func_190926_b()) {
            this.input2.add(recipe.getInput2());
            this.time2 = recipe.getBurnTime2();
            if (recipe.getTemp2().isEmpty()) {
                this.temps.add(DCHeatTier.createList());
            } else {
                this.temps.add(recipe.getTemp2());
            }
            if (recipe.getHum2().isEmpty()) {
                this.hums.add(DCHumidity.createList());
            } else {
                this.hums.add(recipe.getHum2());
            }
            if (recipe.getAir2().isEmpty()) {
                this.airs.add(DCAirflow.createList());
            } else {
                this.airs.add(recipe.getAir2());
            }
        }
        if (!recipe.getInput3().func_190926_b()) {
            this.input3.add(recipe.getInput3());
            this.time3 = recipe.getBurnTime3();
            if (recipe.getTemp3().isEmpty()) {
                this.temps.add(DCHeatTier.createList());
            } else {
                this.temps.add(recipe.getTemp3());
            }
            if (recipe.getHum3().isEmpty()) {
                this.hums.add(DCHumidity.createList());
            } else {
                this.hums.add(recipe.getHum3());
            }
            if (recipe.getAir3().isEmpty()) {
                this.airs.add(DCAirflow.createList());
            } else {
                this.airs.add(recipe.getAir3());
            }
        }
    }

    public void getIngredients(IIngredients ing) {
        ArrayList<List<ItemStack>> in = new ArrayList<List<ItemStack>>();
        in.add(this.input1);
        in.add(this.input2);
        in.add(this.input3);
        ing.setInputLists(VanillaTypes.ITEM, in);
        ing.setOutputs(VanillaTypes.ITEM, this.output);
        ing.setInputLists((IIngredientType)ClimateTypes.TEMP, this.temps);
        ing.setInputLists((IIngredientType)ClimateTypes.HUM, this.hums);
        ing.setInputLists((IIngredientType)ClimateTypes.AIR, this.airs);
    }

    public List<List<DCAirflow>> getAirs() {
        return this.airs;
    }

    public List<List<DCHumidity>> getHums() {
        return this.hums;
    }

    public List<List<DCHeatTier>> getTemps() {
        return this.temps;
    }

    public List<ItemStack> getInput1() {
        return this.input1;
    }

    public List<ItemStack> getInput2() {
        return this.input2;
    }

    public List<ItemStack> getInput3() {
        return this.input3;
    }

    public List<ItemStack> getOutputs() {
        return this.output;
    }

    public void drawInfo(Minecraft mc, int wid, int hei, int mouseX, int mouseY) {
        ResourceLocation res = new ResourceLocation("dcs_climate", "textures/gui/metal_treatment_gui_jei.png");
        mc.func_110434_K().func_110577_a(res);
        int baseX = 43;
        int baseY = 6;
        for (DCHeatTier dCHeatTier : this.temps.get(0)) {
            mc.field_71462_r.func_73729_b(baseX + dCHeatTier.getID() * 6, baseY, dCHeatTier.getID() * 6, 170, 6, 3);
        }
        for (DCHumidity dCHumidity : this.hums.get(0)) {
            mc.field_71462_r.func_73729_b(baseX + dCHumidity.getID() * 21, baseY + 6, dCHumidity.getID() * 21, 174, 21, 3);
        }
        for (DCAirflow dCAirflow : this.airs.get(0)) {
            mc.field_71462_r.func_73729_b(baseX + dCAirflow.getID() * 21, baseY + 12, dCAirflow.getID() * 21, 178, 21, 3);
        }
        if (this.input2.isEmpty()) {
            mc.field_71462_r.func_73729_b(2, baseY + 20, 0, 190, 137, 40);
        } else {
            for (DCHeatTier dCHeatTier : this.temps.get(1)) {
                mc.field_71462_r.func_73729_b(baseX + dCHeatTier.getID() * 6, baseY + 34, dCHeatTier.getID() * 6, 170, 6, 3);
            }
            for (DCHumidity dCHumidity : this.hums.get(1)) {
                mc.field_71462_r.func_73729_b(baseX + dCHumidity.getID() * 21, baseY + 40, dCHumidity.getID() * 21, 174, 21, 3);
            }
            for (DCAirflow dCAirflow : this.airs.get(1)) {
                mc.field_71462_r.func_73729_b(baseX + dCAirflow.getID() * 21, baseY + 46, dCAirflow.getID() * 21, 178, 21, 3);
            }
        }
        if (this.input3.isEmpty()) {
            mc.field_71462_r.func_73729_b(2, baseY + 54, 0, 190, 137, 40);
        } else {
            for (DCHeatTier dCHeatTier : this.temps.get(2)) {
                mc.field_71462_r.func_73729_b(baseX + dCHeatTier.getID() * 6, baseY + 68, dCHeatTier.getID() * 6, 170, 6, 3);
            }
            for (DCHumidity dCHumidity : this.hums.get(2)) {
                mc.field_71462_r.func_73729_b(baseX + dCHumidity.getID() * 21, baseY + 74, dCHumidity.getID() * 21, 174, 21, 3);
            }
            for (DCAirflow dCAirflow : this.airs.get(2)) {
                mc.field_71462_r.func_73729_b(baseX + dCAirflow.getID() * 21, baseY + 80, dCAirflow.getID() * 21, 178, 21, 3);
            }
        }
        String s = I18n.func_135052_a((String)"dcs.tip.heat_treatment_jei1", (Object[])new Object[0]);
        if (!this.input2.isEmpty()) {
            mc.field_71466_p.func_175065_a(String.format("Within %d ticks", this.time1), 35.0f, 26.0f, 0xFF5050, false);
        }
        if (!this.input3.isEmpty()) {
            mc.field_71466_p.func_175065_a(String.format("Within %d ticks", this.time2), 35.0f, 60.0f, 0xFF5050, false);
        }
        mc.field_71466_p.func_175065_a(String.format(I18n.func_135052_a((String)"dcs.tip.heat_treatment_jei2", (Object[])new Object[0]), new Object[0]), 70.0f, 105.0f, 0xFF0000, false);
    }
}

