/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.jei;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.fluid.FluidDic;
import defeatedcrow.hac.core.fluid.FluidDictionaryDC;
import defeatedcrow.hac.core.plugin.jei.ingredients.ClimateTypes;
import defeatedcrow.hac.core.plugin.jei.ingredients.HeatTierRenderer;
import defeatedcrow.hac.plugin.jei.DCStillWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DCStillCategory
implements IRecipeCategory {
    private final IDrawableStatic background;

    public DCStillCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("dcs_climate", "textures/gui/still_gui.png");
        this.background = guiHelper.createDrawable(location, 8, 12, 160, 68);
    }

    public String getUid() {
        return "dcs_climate.still";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.getUid(), (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft mc) {
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (!(recipeWrapper instanceof DCStillWrapper)) {
            return;
        }
        DCStillWrapper wrapper = (DCStillWrapper)recipeWrapper;
        List<List<ItemStack>> inputs = wrapper.getRecipeInputs();
        List<ItemStack> outputs = wrapper.getOutputs();
        List<FluidStack> inF = wrapper.getFluidInputs();
        List<FluidStack> outF = wrapper.getFluidOutputs();
        if (!inputs.isEmpty()) {
            for (int i = 0; i < 2; ++i) {
                if (i >= inputs.size()) continue;
                recipeLayout.getItemStacks().init(i, true, 48, 5 + i * 18);
                if (!(inputs.get(i) instanceof List)) continue;
                recipeLayout.getItemStacks().set(i, inputs.get(i));
            }
        }
        recipeLayout.getItemStacks().init(3, false, 92, 23);
        recipeLayout.getItemStacks().set(3, outputs.get(0));
        if (!inF.isEmpty() && inF.get(0) != null) {
            FluidStack f1 = inF.get(0);
            recipeLayout.getFluidStacks().init(0, false, 30, 8, 12, 50, 5000, false, null);
            FluidDic dic = FluidDictionaryDC.getDic((FluidStack)f1);
            if (dic != null && !dic.fluids.isEmpty()) {
                ArrayList ret = Lists.newArrayList();
                for (Fluid f : dic.fluids) {
                    ret.add(new FluidStack(f, f1.amount));
                }
                recipeLayout.getFluidStacks().set(0, (List)ret);
            } else {
                recipeLayout.getFluidStacks().set(0, f1);
            }
        }
        if (!outF.isEmpty() && outF.get(0) != null) {
            FluidStack f2 = outF.get(0);
            recipeLayout.getFluidStacks().init(1, false, 117, 8, 12, 50, 5000, false, null);
            recipeLayout.getFluidStacks().set(1, f2);
        }
        List<DCHeatTier> temps = wrapper.getTemps();
        int i = 0;
        for (DCHeatTier temp : temps) {
            recipeLayout.getIngredientsGroup((IIngredientType)ClimateTypes.TEMP).init(i, true, (IIngredientRenderer)new HeatTierRenderer(), 65 + i * 16, 45, 16, 16, 0, 0);
            recipeLayout.getIngredientsGroup((IIngredientType)ClimateTypes.TEMP).set(i, (Object)temp);
            ++i;
        }
    }

    public String getModName() {
        return "HeatAndClimateLib";
    }
}

