/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.jei;

import com.google.common.collect.ImmutableList;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.core.plugin.jei.ingredients.ClimateTypes;
import defeatedcrow.hac.main.api.brewing.IStillRecipeDC;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class DCStillWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> input;
    private final List<ItemStack> output;
    private final IStillRecipeDC rec;
    private final List<FluidStack> inF;
    private final List<FluidStack> outF;
    private final List<DCHeatTier> temps;

    public DCStillWrapper(IStillRecipeDC recipe) {
        this.rec = recipe;
        this.input = new ArrayList<List<ItemStack>>();
        if (!recipe.getProcessedInput().isEmpty()) {
            for (Object obj : recipe.getProcessedInput()) {
                if (obj instanceof ItemStack) {
                    ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
                    ret.add((ItemStack)obj);
                    this.input.add(ret);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                this.input.add((List)obj);
            }
        }
        this.output = new ArrayList<ItemStack>();
        this.output.add(recipe.getOutput());
        this.inF = new ArrayList<FluidStack>();
        this.outF = new ArrayList<FluidStack>();
        if (recipe.getInputFluid() != null) {
            this.inF.add(recipe.getInputFluid());
        }
        if (recipe.getOutputFluid() != null) {
            this.outF.add(recipe.getOutputFluid());
        }
        this.temps = ImmutableList.of((Object)recipe.requiredHeatTemp(), (Object)recipe.requiredColdTemp());
    }

    public List<List<ItemStack>> getRecipeInputs() {
        return this.input;
    }

    public List<DCHeatTier> getTemps() {
        return this.temps;
    }

    public void getIngredients(IIngredients ing) {
        ing.setInputLists(VanillaTypes.ITEM, this.input);
        ing.setInputs(VanillaTypes.FLUID, this.inF);
        ing.setOutputs(VanillaTypes.ITEM, this.output);
        ing.setOutputs(VanillaTypes.FLUID, this.outF);
        ing.setInputs((IIngredientType)ClimateTypes.TEMP, this.temps);
    }

    public List<List<ItemStack>> getInputs() {
        return this.input;
    }

    public List<ItemStack> getOutputs() {
        return this.output;
    }

    public List<FluidStack> getFluidInputs() {
        return this.inF;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.outF;
    }

    public void drawInfo(Minecraft mc, int wid, int hei, int mouseX, int mouseY) {
        ResourceLocation res = new ResourceLocation("dcs_climate", "textures/gui/still_gui.png");
        mc.func_110434_K().func_110577_a(res);
        if (!this.temps.isEmpty()) {
            int baseX = 65;
            int baseY = 45;
            mc.field_71462_r.func_73729_b(baseX, baseY, 196, 29, 15, 17);
            mc.field_71462_r.func_73729_b(baseX + 15, baseY, 196, 46, 15, 17);
        }
    }

    public List<String> getTooltipStrings(int x, int y) {
        int baseX = 65;
        int baseY = 45;
        ArrayList<String> s = new ArrayList<String>();
        if (x > baseX && x < baseX + 30 && y > baseY && y < baseY + 17) {
            if (x < baseX + 15) {
                s.add("Heat Source" + this.temps.get(0).localize());
            } else {
                s.add("Cold Source" + this.temps.get(1).localize());
            }
        }
        return s.isEmpty() ? null : s;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

