/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.jei;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.plugin.jei.ingredients.ClimateTypes;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.api.brewing.EnumHabitat;
import defeatedcrow.hac.main.api.brewing.EnumMedium;
import defeatedcrow.hac.main.api.brewing.IMicrobe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MicrobeWrapper
implements IRecipeWrapper {
    public final IMicrobe recipe;
    public final List<DCHeatTier> temp;
    public final List<DCHumidity> hum;
    public final List<DCAirflow> air;
    public final List<ItemStack> outputs;
    public final List<ItemStack> mediums;

    public MicrobeWrapper(IMicrobe info) {
        this.recipe = info;
        this.temp = Lists.newArrayList();
        this.hum = Lists.newArrayList();
        this.air = Lists.newArrayList();
        this.outputs = Lists.newArrayList();
        this.mediums = Lists.newArrayList();
        this.temp.addAll(info.getHeats());
        this.hum.addAll(info.getHums());
        this.air.addAll(info.getAirs());
        for (EnumMedium medium : info.getMediums()) {
            this.mediums.add(new ItemStack(FoodInit.medium, 1, medium.id));
        }
        this.outputs.add(new ItemStack(info.getMicrobeItem(), 1, 0));
        this.outputs.add(new ItemStack(info.getMicrobeItem(), 1, 1));
        this.outputs.add(new ItemStack(info.getMicrobeItem(), 1, 2));
    }

    public void getIngredients(IIngredients ing) {
        ing.setInputs((IIngredientType)ClimateTypes.TEMP, this.temp);
        ing.setInputs((IIngredientType)ClimateTypes.HUM, this.hum);
        ing.setInputs((IIngredientType)ClimateTypes.AIR, this.air);
        ing.setInputs(VanillaTypes.ITEM, this.mediums);
        ing.setOutputs(VanillaTypes.ITEM, this.outputs);
    }

    public List<ItemStack> getOutput() {
        return this.outputs;
    }

    public List<ItemStack> getMedium() {
        return this.mediums;
    }

    public List<DCHeatTier> getTemp() {
        return this.temp;
    }

    public List<DCHumidity> getHum() {
        return this.hum;
    }

    public List<DCAirflow> getAir() {
        return this.air;
    }

    public IMicrobe getRecipe() {
        return this.recipe;
    }

    public void drawInfo(Minecraft mc, int wid, int hei, int mouseX, int mouseY) {
        ResourceLocation res = new ResourceLocation("dcs_climate", "textures/gui/microbe_gui_jei.png");
        mc.func_110434_K().func_110577_a(res);
        int baseX = 33;
        int baseY = 35;
        for (DCHeatTier dCHeatTier : this.temp) {
            mc.field_71462_r.func_73729_b(baseX + dCHeatTier.getID() * 6, baseY, dCHeatTier.getID() * 6, 170, 6, 3);
        }
        for (DCHumidity dCHumidity : this.hum) {
            mc.field_71462_r.func_73729_b(baseX + dCHumidity.getID() * 21, baseY + 6, dCHumidity.getID() * 21, 174, 21, 3);
        }
        for (DCAirflow dCAirflow : this.air) {
            mc.field_71462_r.func_73729_b(baseX + dCAirflow.getID() * 21, baseY + 12, dCAirflow.getID() * 21, 178, 21, 3);
        }
        for (int i = 0; i < EnumHabitat.values().length; ++i) {
            EnumHabitat enumHabitat = EnumHabitat.values()[i];
            if (this.recipe.getChance(enumHabitat) <= 0) continue;
            mc.field_71462_r.func_73729_b(23 + i * 17, 62, i * 16, 190, 16, 16);
        }
        if (this.recipe.getGramStaining()) {
            mc.field_71462_r.func_73729_b(17, 12, 177, 50, 16, 16);
        } else {
            mc.field_71462_r.func_73729_b(17, 12, 177, 34, 16, 16);
        }
        String s1 = this.getOutput().get(0).func_82833_r();
        mc.field_71466_p.func_78279_b(s1, 45, 10, 110, 0);
        String string = this.recipe.getType().localize();
        mc.field_71466_p.func_78279_b(string, 45, 22, 110, 0);
        String s3 = I18n.func_135052_a((String)"dcs.tip.habitat", (Object[])new Object[0]);
        mc.field_71466_p.func_78279_b(s3, 15, 52, 110, 0);
        String s4 = I18n.func_135052_a((String)"dcs.tip.medium", (Object[])new Object[0]);
        mc.field_71466_p.func_78279_b(s4, 15, 81, 110, 0);
    }

    public List<String> getTooltipStrings(int x, int y) {
        ArrayList<String> s = new ArrayList<String>();
        if (y > 62 && y < 77) {
            int c;
            if (x > 22 && x < 38 && (c = this.recipe.getChance(EnumHabitat.SOIL)) > 0) {
                s.add(EnumHabitat.SOIL.localize() + ": " + c + "%");
            }
            if (x > 39 && x < 55 && (c = this.recipe.getChance(EnumHabitat.FLOWER)) > 0) {
                s.add(EnumHabitat.FLOWER.localize() + ": " + c + "%");
            }
            if (x > 56 && x < 72 && (c = this.recipe.getChance(EnumHabitat.CROP)) > 0) {
                s.add(EnumHabitat.CROP.localize() + ": " + c + "%");
            }
            if (x > 73 && x < 89 && (c = this.recipe.getChance(EnumHabitat.ANIMAL)) > 0) {
                s.add(EnumHabitat.ANIMAL.localize() + ": " + c + "%");
            }
            if (x > 90 && x < 106 && (c = this.recipe.getChance(EnumHabitat.WATER)) > 0) {
                s.add(EnumHabitat.WATER.localize() + ": " + c + "%");
            }
        }
        return s;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

