/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.sd;

import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.thirst.ThirstUtil;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.plugin.DrinkPotionType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraftforge.fluids.Fluid;

public class DCThirstHelperSD {
    public static boolean enableThirst() {
        return QuickConfig.isThirstEnabled();
    }

    public static void drink(EntityPlayer player, Fluid f) {
        DCDrink type = DCDrink.getType(f);
        ThirstUtil.takeDrink((EntityPlayer)player, (int)type.getThirst(), (float)type.getHydration(), (float)type.getPoisonChance());
    }

    public static enum DCDrink {
        TEA(6, 0.5f, 0.0f),
        JUICE(6, 0.2f, 0.0f),
        RAW(4, 0.2f, 0.25f),
        ETHANOL(2, 0.1f, 0.0f),
        RISK(1, 0.0f, 0.75f);

        final int thirst;
        final float hydration;
        final float chance;

        private DCDrink(int i, float f1, float f2) {
            this.thirst = i;
            this.hydration = f1;
            this.chance = f2;
        }

        public int getThirst() {
            return this.thirst;
        }

        public float getHydration() {
            return this.hydration;
        }

        public float getPoisonChance() {
            return this.chance;
        }

        public static DCDrink getType(Fluid f) {
            Potion p;
            if (f == null) {
                return RAW;
            }
            if (f == MainInit.blackTea) {
                return TEA;
            }
            if (f == MainInit.greenTea) {
                return TEA;
            }
            if (f == MainInit.coffee) {
                return TEA;
            }
            if (f == MainInit.lemon) {
                return JUICE;
            }
            if (f == MainInit.stock) {
                return JUICE;
            }
            if (f == MainInit.tomatoJuice) {
                return JUICE;
            }
            if (f == MainInit.milk) {
                return JUICE;
            }
            if (f == MainInit.soyMilk) {
                return JUICE;
            }
            if (f == MainInit.hotSpring) {
                return JUICE;
            }
            if (f == MainInit.cream) {
                return RAW;
            }
            if (f == MainInit.mazai) {
                return ETHANOL;
            }
            if (f == MainInit.blackLiquor) {
                return RISK;
            }
            if (f == MainInit.oil) {
                return RISK;
            }
            if (f == MainInit.fuelOil) {
                return RISK;
            }
            if (f == MainInit.fuelGas) {
                return RISK;
            }
            if (f == MainInit.ethanol) {
                return ETHANOL;
            }
            if (f == MainInit.ammonia) {
                return RISK;
            }
            if (f == MainInit.nitricAcid) {
                return RISK;
            }
            if (f == MainInit.sulfuricAcid) {
                return RISK;
            }
            if (f == MainInit.nitrogen) {
                return RISK;
            }
            if (f == MainInit.ammonia) {
                return RISK;
            }
            if (f == MainInit.oxygen) {
                return RAW;
            }
            if (ModuleConfig.food_advanced) {
                if (f == FoodInit.roseWater) {
                    return TEA;
                }
                if (f == FoodInit.beer) {
                    return JUICE;
                }
                if (f == FoodInit.wine) {
                    return JUICE;
                }
                if (f == FoodInit.dateWine) {
                    return JUICE;
                }
                if (f == FoodInit.sake) {
                    return JUICE;
                }
                if (f == FoodInit.whisky) {
                    return ETHANOL;
                }
                if (f == FoodInit.brandy) {
                    return ETHANOL;
                }
                if (f == FoodInit.pomaceBrandy) {
                    return ETHANOL;
                }
                if (f == FoodInit.araq) {
                    return ETHANOL;
                }
                if (f == FoodInit.shotyu) {
                    return ETHANOL;
                }
                if (f == FoodInit.akvavit) {
                    return ETHANOL;
                }
                if (f == FoodInit.whiteRum) {
                    return ETHANOL;
                }
                if (f == FoodInit.darkRum) {
                    return ETHANOL;
                }
                if (f == FoodInit.vodka) {
                    return ETHANOL;
                }
                if (f == FoodInit.netherWine) {
                    return JUICE;
                }
                if (f == FoodInit.chorusLiquor) {
                    return ETHANOL;
                }
            }
            if ((p = DrinkPotionType.getPotion(f)) != null && p.func_76398_f()) {
                return RISK;
            }
            return ETHANOL;
        }
    }
}

