/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.tan;

import defeatedcrow.hac.core.DCLogger;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.plugin.DrinkPotionType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fluids.Fluid;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.ISyncedOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.api.thirst.IDrink;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.thirst.ThirstHandler;

public class DCThirstHelper {
    public static boolean enableThirst() {
        return SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_THIRST);
    }

    public static void onDrink(EntityPlayer player, Fluid f) {
        if (f != null) {
            ThirstHandler handler = (ThirstHandler)ThirstHelper.getThirstData((EntityPlayer)player);
            IThirst thirst = ThirstHelper.getThirstData((EntityPlayer)player);
            DCDrink type = DCDrink.getType(f);
            DCLogger.infoLog((String)("on thirst effect: " + (Object)((Object)type)));
            thirst.addStats(type.getThirst(), type.getHydration());
            if (DCThirstHelper.enableThirst() && player.field_70170_p.field_73012_v.nextFloat() < type.getPoisonChance()) {
                player.func_70690_d(new PotionEffect(TANPotions.thirst, 600));
            }
        }
    }

    public static enum DCDrink implements IDrink
    {
        TEA(10, 0.5f, 0.0f),
        RAW(4, 0.1f, 0.5f),
        ETHANOL(6, 0.2f, 0.25f),
        RISK(2, 0.1f, 0.75f);

        final int thirst;
        final float hydration;
        final float chance;

        private DCDrink(int i, float f1, float f2) {
            this.thirst = i;
            this.hydration = f1;
            this.chance = f2;
        }

        public int getThirst() {
            return this.thirst;
        }

        public float getHydration() {
            return this.hydration;
        }

        public float getPoisonChance() {
            return this.chance;
        }

        public static DCDrink getType(Fluid f) {
            if (f == null) {
                return RAW;
            }
            if (f == MainInit.blackTea) {
                return TEA;
            }
            if (f == MainInit.greenTea) {
                return TEA;
            }
            if (f == MainInit.coffee) {
                return TEA;
            }
            if (f == MainInit.lemon) {
                return TEA;
            }
            if (f == MainInit.stock) {
                return TEA;
            }
            if (f == MainInit.tomatoJuice) {
                return TEA;
            }
            if (f == MainInit.milk) {
                return TEA;
            }
            if (f == MainInit.soyMilk) {
                return TEA;
            }
            if (f == MainInit.hotSpring) {
                return RAW;
            }
            if (f == MainInit.cream) {
                return RAW;
            }
            if (f == MainInit.mazai) {
                return ETHANOL;
            }
            if (f == MainInit.blackLiquor) {
                return RISK;
            }
            if (f == MainInit.oil) {
                return RAW;
            }
            if (f == MainInit.ethanol) {
                return ETHANOL;
            }
            if (f == MainInit.ammonia) {
                return RISK;
            }
            if (f == MainInit.nitricAcid) {
                return RISK;
            }
            if (f == MainInit.sulfuricAcid) {
                return RISK;
            }
            if (f == MainInit.nitrogen) {
                return RISK;
            }
            if (ModuleConfig.food && f == FoodInit.roseWater) {
                return TEA;
            }
            Potion p = DrinkPotionType.getPotion(f);
            if (p != null && p.func_76398_f()) {
                return RISK;
            }
            return RAW;
        }
    }
}

