/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.waila;

import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.machine.MachineInit;
import defeatedcrow.hac.machine.block.TileFan;
import defeatedcrow.hac.machine.block.TileFreezer;
import defeatedcrow.hac.machine.block.TileHeatExchanger;
import defeatedcrow.hac.main.MainInit;
import defeatedcrow.hac.main.block.device.BlockFirestand;
import defeatedcrow.hac.main.block.device.TileBellow;
import defeatedcrow.hac.main.block.device.TileCookingStove;
import defeatedcrow.hac.main.block.device.TileNormalChamber;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import mcp.mobius.waila.addons.core.HUDHandlerBlocks;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HUDHandlerChamber
extends HUDHandlerBlocks {
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        DCHeatTier heat;
        byte tier;
        if (!config.getConfig("dcs_climate.showclimate") || accessor.getBlock() == null) {
            return currenttip;
        }
        Block block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == MainInit.chamber || block == MainInit.shitirin || block == MainInit.fuelStove || block == MachineInit.burner) {
            int burntime = accessor.getNBTData().func_74762_e("BurnTime");
            tier = accessor.getNBTData().func_74771_c("Climate");
            if (burntime > 0) {
                heat = DCHeatTier.getTypeByID((int)tier);
                currenttip.add(String.format("%s: %s", DCName.TEMP2.getLocalizedName(), SpecialChars.GOLD + heat.localize()));
            } else {
                currenttip.add(String.format("%s", DCName.STOPPING.getLocalizedName()));
            }
        }
        if (block == MainInit.firestand) {
            if (meta == 1) {
                currenttip.add(String.format("%s: %s", DCName.TEMP2.getLocalizedName(), SpecialChars.GOLD + DCHeatTier.KILN.localize()));
            } else {
                currenttip.add(String.format("%s", DCName.STOPPING.getLocalizedName()));
            }
        }
        if (block == MachineInit.freezer) {
            float burntime = accessor.getNBTData().func_74760_g("dcs.pretoq");
            tier = accessor.getNBTData().func_74771_c("dcs.heatID");
            if (burntime > 0.0f) {
                heat = DCHeatTier.getTypeByID((int)tier);
                currenttip.add(String.format("%s: %s", DCName.TEMP2.getLocalizedName(), SpecialChars.AQUA + heat.localize()));
            } else {
                currenttip.add(String.format("%s", DCName.STOPPING.getLocalizedName()));
            }
        }
        if (block == MainInit.bellow) {
            float f = accessor.getNBTData().func_74760_g("dcs.pretoq");
            if (f > 0.0f) {
                currenttip.add(String.format("%s: %s", DCName.AIR2.getLocalizedName(), SpecialChars.GREEN + DCAirflow.WIND.localize()));
            } else {
                currenttip.add(String.format("%s", DCName.STOPPING.getLocalizedName()));
            }
        }
        if (block == MachineInit.fan) {
            float f = accessor.getNBTData().func_74760_g("dcs.pretoq");
            if (f > 5.5f) {
                currenttip.add(String.format("%s: %s", DCName.AIR2.getLocalizedName(), SpecialChars.GREEN + DCAirflow.WIND.localize()));
            } else {
                currenttip.add(String.format("%s", DCName.STOPPING.getLocalizedName()));
            }
        }
        if (block == MachineInit.heatPump) {
            float f = accessor.getNBTData().func_74760_g("dcs.pretoq");
            if (f > 31.5f) {
                currenttip.add(String.format("Active: %s", SpecialChars.RED + "Stage 2"));
            } else if (f > 5.5f) {
                currenttip.add(String.format("Active: %s", SpecialChars.GOLD + "Stage 1"));
            } else {
                currenttip.add(String.format("%s", DCName.STOPPING.getLocalizedName()));
            }
        }
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return te.func_189515_b(tag);
    }

    public static void register(IWailaRegistrar registrar) {
        HUDHandlerChamber provider = new HUDHandlerChamber();
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileNormalChamber.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileNormalChamber.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileCookingStove.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileCookingStove.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileBellow.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileBellow.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileFan.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileFan.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileHeatExchanger.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileHeatExchanger.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileFreezer.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileFreezer.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockFirestand.class);
    }
}

