/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.waila;

import com.google.common.collect.Lists;
import defeatedcrow.hac.api.climate.BlockSet;
import defeatedcrow.hac.api.climate.ClimateAPI;
import defeatedcrow.hac.api.climate.DCAirflow;
import defeatedcrow.hac.api.climate.DCHeatTier;
import defeatedcrow.hac.api.climate.DCHumidity;
import defeatedcrow.hac.core.base.ClimateCropBase;
import defeatedcrow.hac.core.base.ClimateDoubleCropBase;
import defeatedcrow.hac.food.FoodInit;
import defeatedcrow.hac.main.config.ModuleConfig;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import mcp.mobius.waila.addons.core.HUDHandlerBlocks;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.cbcore.LangUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HUDHandlerClimateData
extends HUDHandlerBlocks {
    static final List<BlockSet> targetHeatList = Lists.newArrayList();
    static final List<BlockSet> targetHumList = Lists.newArrayList();
    static final List<BlockSet> targetAirList = Lists.newArrayList();

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (block == null) {
            return ItemStack.field_190927_a;
        }
        if (ModuleConfig.food && config.getConfig("dcs_climate.showcrop")) {
            if (block == FoodInit.cropRice) {
                return new ItemStack(FoodInit.crops, 1, 0);
            }
            if (block == FoodInit.cropOnion) {
                return new ItemStack(FoodInit.crops, 1, 1);
            }
            if (block == FoodInit.cropSpinach) {
                return new ItemStack(FoodInit.crops, 1, 2);
            }
            if (block == FoodInit.cropTomato) {
                return new ItemStack(FoodInit.crops, 1, 3);
            }
            if (block == FoodInit.cropCoffee) {
                return new ItemStack(FoodInit.crops, 1, 4);
            }
            if (block == FoodInit.cropCotton) {
                return new ItemStack(FoodInit.crops, 1, 5);
            }
            if (block == FoodInit.leavesLemon) {
                return new ItemStack(FoodInit.crops, 1, 6);
            }
            if (block == FoodInit.leavesOlive) {
                return new ItemStack(FoodInit.crops, 1, 7);
            }
            if (block == FoodInit.leavesTea) {
                return new ItemStack(FoodInit.crops, 1, 8);
            }
            if (block == FoodInit.cropLotus) {
                return new ItemStack(FoodInit.crops, 1, 10);
            }
            if (block == FoodInit.saplings) {
                int meta = accessor.getMetadata();
                switch (meta) {
                    case 0: {
                        return new ItemStack(FoodInit.saplings, 1, 0);
                    }
                    case 1: {
                        return new ItemStack(FoodInit.saplings, 1, 1);
                    }
                    case 2: {
                        return new ItemStack(FoodInit.saplings, 1, 2);
                    }
                }
                return new ItemStack(FoodInit.saplings, 1, 3);
            }
        }
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == null) {
            return currenttip;
        }
        BlockSet set = new BlockSet(block, meta);
        if (config.getConfig("dcs_climate.showclimate")) {
            if (targetHeatList.contains(set)) {
                DCHeatTier heat = ClimateAPI.registerBlock.getHeatTier(block, meta);
                if (heat.getTier() < 0) {
                    currenttip.add(String.format(DCName.HEAT.getLocalizedName() + ": %s", SpecialChars.AQUA + heat.localize()));
                } else {
                    currenttip.add(String.format(DCName.HEAT.getLocalizedName() + ": %s", SpecialChars.GOLD + heat.localize()));
                }
            }
            if (targetHumList.contains(set)) {
                DCHumidity hum = ClimateAPI.registerBlock.getHumidity(block, meta);
                currenttip.add(String.format(DCName.HUM.getLocalizedName() + ": %s", SpecialChars.AQUA + hum.localize()));
            }
            if (targetAirList.contains(set)) {
                DCAirflow air = ClimateAPI.registerBlock.getAirflow(block, meta);
                currenttip.add(String.format(DCName.AIR.getLocalizedName() + ": %s", SpecialChars.GREEN + air.localize()));
            }
        }
        if (config.getConfig("dcs_climate.showcrop")) {
            ClimateCropBase crop;
            int stage;
            if (ClimateCropBase.class.isInstance(block) && block != FoodInit.saplings) {
                stage = meta & 3;
                crop = (ClimateCropBase)block;
                float growthValue = (float)stage / (float)crop.getGrownMetadata() * 100.0f;
                if ((double)growthValue < 100.0) {
                    currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG((String)"hud.msg.growth", (Object[])new Object[0]), Float.valueOf(growthValue)));
                } else {
                    currenttip.add(String.format("%s : %s", LangUtil.translateG((String)"hud.msg.growth", (Object[])new Object[0]), LangUtil.translateG((String)"hud.msg.mature", (Object[])new Object[0])));
                }
            } else if (ClimateDoubleCropBase.class.isInstance(block)) {
                stage = meta & 7;
                crop = (ClimateDoubleCropBase)block;
                float growthValue = (float)stage / (float)crop.getGrownMetadata() * 100.0f;
                if ((double)growthValue < 100.0) {
                    currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG((String)"hud.msg.growth", (Object[])new Object[0]), Float.valueOf(growthValue)));
                } else {
                    currenttip.add(String.format("%s : %s", LangUtil.translateG((String)"hud.msg.growth", (Object[])new Object[0]), LangUtil.translateG((String)"hud.msg.mature", (Object[])new Object[0])));
                }
            }
        }
        if (config.getConfig("dcs_climate.showvanillafarmland") && BlockFarmland.class.isInstance(block)) {
            int stage = meta & 7;
            float wetValue = (float)stage / 7.0f * 100.0f;
            currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG((String)"Moisture", (Object[])new Object[0]), Float.valueOf(wetValue)));
        }
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return te.func_189515_b(tag);
    }

    public static void register(IWailaRegistrar registrar) {
        registrar.addConfig("HeatAndClimate", "dcs_climate.showclimate", true);
        registrar.addConfig("HeatAndClimate", "dcs_climate.showcrops", true);
        registrar.addConfig("HeatAndClimate", "dcs_climate.showvanillafarmland", true);
        HUDHandlerClimateData provider = new HUDHandlerClimateData();
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.cropRice.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.cropOnion.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.cropSpinach.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.cropTomato.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.cropCoffee.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.cropCotton.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.leavesLemon.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.leavesOlive.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.leavesTea.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.leavesMorus.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, FoodInit.saplings.getClass());
        registrar.registerBodyProvider((IWailaDataProvider)provider, ClimateCropBase.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, ClimateDoubleCropBase.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockFarmland.class);
        targetHeatList.addAll(ClimateAPI.registerBlock.getHeatList().keySet());
        if (!targetHeatList.isEmpty()) {
            for (BlockSet set : targetHeatList) {
                if (set == null || set.block == null) continue;
                registrar.registerBodyProvider((IWailaDataProvider)provider, set.block.getClass());
            }
        }
        targetHumList.addAll(ClimateAPI.registerBlock.getHumList().keySet());
        if (!targetHumList.isEmpty()) {
            for (BlockSet set : targetHumList) {
                if (set == null || set.block == null) continue;
                registrar.registerBodyProvider((IWailaDataProvider)provider, set.block.getClass());
            }
        }
        targetAirList.addAll(ClimateAPI.registerBlock.getAirList().keySet());
        if (!targetAirList.isEmpty()) {
            for (BlockSet set : targetAirList) {
                if (set == null || set.block == null) continue;
                registrar.registerBodyProvider((IWailaDataProvider)provider, set.block.getClass());
            }
        }
    }
}

