/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.plugin.waila;

import defeatedcrow.hac.core.fluid.DCTank;
import defeatedcrow.hac.food.block.TileFluidProcessorBase;
import defeatedcrow.hac.machine.block.TileDieselEngine;
import defeatedcrow.hac.machine.block.TileHopperFluid;
import defeatedcrow.hac.machine.block.TileIBC;
import defeatedcrow.hac.machine.block.TileReactor;
import defeatedcrow.hac.machine.block.tankyard.TileTankYard;
import defeatedcrow.hac.machine.block.tankyard.TileYardPart;
import defeatedcrow.hac.main.block.device.TileCookingStove;
import defeatedcrow.hac.main.block.device.TilePail;
import defeatedcrow.hac.main.util.DCName;
import java.util.List;
import mcp.mobius.waila.addons.core.HUDHandlerBlocks;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class HUDHandlerFluidDC
extends HUDHandlerBlocks {
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("dcs_climate.showfluid") || accessor.getBlock() == null) {
            return currenttip;
        }
        if (accessor.getNBTData() != null && accessor.getNBTData().func_74764_b("DCTank")) {
            FluidStack fluid;
            NBTTagList list = accessor.getNBTData().func_150295_c("DCTank", 10);
            NBTTagCompound nbt2 = list.func_150305_b(0);
            int lim = accessor.getNBTData().func_74762_e("Limit");
            if (!nbt2.func_74764_b("Empty") && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt2)) != null && fluid.getFluid() != null) {
                currenttip.add(String.format(DCName.FLUID.getLocalizedName() + " : %s", fluid.getLocalizedName()));
                currenttip.add(String.format(DCName.AMOUNT.getLocalizedName() + " : %d / %d mB", fluid.amount, lim));
            }
        }
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        IFluidHandler tank;
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN) && (tank = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null && tank instanceof DCTank) {
            tag.func_74768_a("Limit", ((DCTank)tank).getCapacity());
            return ((DCTank)tank).writeToNBT(tag, "DCTank");
        }
        return te.func_189515_b(tag);
    }

    public static void register(IWailaRegistrar registrar) {
        registrar.addConfig("HeatAndClimate", "dcs_climate.showfluid", true);
        HUDHandlerFluidDC provider = new HUDHandlerFluidDC();
        registrar.registerBodyProvider((IWailaDataProvider)provider, TilePail.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TilePail.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileIBC.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileIBC.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileTankYard.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileTankYard.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileYardPart.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileYardPart.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileHopperFluid.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileHopperFluid.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileFluidProcessorBase.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileFluidProcessorBase.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileCookingStove.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileCookingStove.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileReactor.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileReactor.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, TileDieselEngine.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, TileDieselEngine.class);
    }
}

