/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.blocks;

import com.dannyboythomas.hole_filler_mod.blocks.BlockHoleFiller;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.init.InitBlocks;
import com.dannyboythomas.hole_filler_mod.util.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockCuring
extends Block {
    public static final IntegerProperty CURED = IntegerProperty.func_177719_a((String)"cured", (int)1, (int)9);

    public BlockCuring(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)CURED, (Comparable)Integer.valueOf(1)));
    }

    public boolean func_149653_t(BlockState p_149653_1_) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        int cured = (Integer)state.func_177229_b((Property)CURED);
        worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 1);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        if (!worldIn.field_72995_K) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 20);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        if (worldIn.field_72995_K) {
            return;
        }
        int cured = (Integer)state.func_177229_b((Property)CURED);
        if (worldIn.func_205220_G_().func_205359_a(pos, (Object)state.func_177230_c())) {
            return;
        }
        Random rnd = new Random();
        int totalTurnTimeTicks = (Integer)ConfigHoleFiller.undo_timer.get() * 20;
        int minWait = totalTurnTimeTicks / 8;
        int remainder = totalTurnTimeTicks % 7;
        if (cured < 8) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), minWait);
            if (rnd.nextInt(10) > 3) {
                worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((Property)CURED, (Comparable)Integer.valueOf(cured + 1)));
            }
        } else if (cured == 8) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), remainder + minWait);
            worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((Property)CURED, (Comparable)Integer.valueOf(cured + 1)));
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (!worldIn.field_72995_K) {
            Vector<Vector3i> list = BlockCuring.GetBreakableVein(worldIn, (Vector3i)pos);
            System.out.println("Vein:" + list.size());
            for (int i = 0; i < list.size(); ++i) {
                BlockPos p = new BlockPos(list.get(i));
                if (worldIn.func_180495_p(p).func_177230_c() != ((BlockCuring)InitBlocks.curing_block.get()).getBlock()) continue;
                worldIn.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public static Vector<Vector3i> GetBreakableVein(World world, Vector3i vec) {
        Vector<Vector3i> list = new Vector<Vector3i>();
        Block thisBlock = world.func_180495_p(new BlockPos(vec)).func_177230_c();
        list.add(vec);
        int size = list.size();
        int maxLoop = 100;
        int loop = 0;
        while (loop++ < maxLoop) {
            for (int i = 0; i < size; ++i) {
                Vector<Vector3i> neighbours = BlockCuring.GetBreakableNeighbours(world, list.get(i));
                for (int j = 0; j < neighbours.size(); ++j) {
                    if (list.contains(neighbours.get(j))) continue;
                    list.add(neighbours.get(j));
                }
            }
            if (size == list.size()) break;
            size = list.size();
        }
        return list;
    }

    public static Vector<Vector3i> GetBreakableNeighbours(World world, Vector3i vec) {
        Block thisBlock = ((BlockCuring)InitBlocks.curing_block.get()).getBlock();
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        Vector<Vector3i> list = new Vector<Vector3i>();
        for (int i = 0; i < dirs.size(); ++i) {
            Vector3i dir = dirs.get(i);
            Vector3i pos = Helper.Add(vec, dir);
            Block testBlock = world.func_180495_p(new BlockPos(pos)).func_177230_c();
            if (testBlock != thisBlock && testBlock != ((BlockHoleFiller)InitBlocks.hole_filler_block.get()).getBlock()) continue;
            list.add(pos);
        }
        return list;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CURED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent("Will turn to dirt after").func_230529_a_((ITextComponent)new StringTextComponent("\u00a7a " + ConfigHoleFiller.undo_timer.get())).func_230529_a_((ITextComponent)new StringTextComponent(" seconds.")));
            tooltip.add((ITextComponent)new StringTextComponent("Breaking one will cause a chain reaction to break all connected Curing Blocks"));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("Hold 'shift' for info."));
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

