/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.blocks.BlockCuring;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.init.InitBlocks;
import com.dannyboythomas.hole_filler_mod.init.InitTileEntities;
import com.dannyboythomas.hole_filler_mod.util.Helper;
import com.dannyboythomas.hole_filler_mod.util.OrderByDistance;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class TileHoleFiller
extends TileEntity
implements ITickableTileEntity {
    int timer = 0;
    boolean running = false;
    Vector<Vector3i> area;

    public TileHoleFiller() {
        super((TileEntityType)InitTileEntities.HOLE_FILLER.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
    }

    public void func_73660_a() {
        if (this.running && this.timer++ % 1 == 0) {
            this.area = this.FillHole(this.area);
            if (this.area.size() <= 0) {
                this.running = false;
                this.field_145850_b.func_175656_a(this.field_174879_c, ((BlockCuring)InitBlocks.curing_block.get()).func_176223_P());
            }
        }
    }

    public void Trigger() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.timer = 0;
        this.area = new Vector();
        this.area.add((Vector3i)this.field_174879_c);
        this.area = this.GetHoleArea(this.area);
        this.area.remove(this.field_174879_c);
        this.area.sort(new OrderByDistance(Helper.Vec3d(this.field_174879_c)));
    }

    Vector<Vector3i> FillHole(Vector<Vector3i> area) {
        int blocksPerTick = (Integer)ConfigHoleFiller.fill_speed.get();
        for (int i = 0; i < blocksPerTick; ++i) {
            Random rnd;
            if (area.size() <= 0) continue;
            Vector3i vec = area.firstElement();
            if (i == 0 && (double)(rnd = new Random()).nextFloat() > 0.3) {
                this.field_145850_b.func_184133_a(null, new BlockPos(vec), SoundEvents.field_187753_eE, SoundCategory.BLOCKS, 0.35f, 0.4f / (rnd.nextFloat() * 0.4f + 0.8f));
            }
            area.remove(0);
            if (!this.IsReplaceableBlock(new BlockPos(vec))) continue;
            this.field_145850_b.func_175656_a(new BlockPos(vec), ((BlockCuring)InitBlocks.curing_block.get()).func_176223_P());
        }
        return area;
    }

    boolean IsValidHole(Vector<Vector3i> area, Vector3i pos) {
        int configMaxDiameter = (Integer)ConfigHoleFiller.max_hole_diameter.get();
        int maxDimension = configMaxDiameter / 2;
        int maxCount = 4;
        int count = 0;
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        block0: for (int i = 0; i < dirs.size(); ++i) {
            Vector3i dir = dirs.get(i);
            for (int j = 1; j < maxDimension; ++j) {
                Vector3i spot = Helper.Add(pos, Helper.Multiply(dir, j));
                if (!this.IsValidBoundaryBlock(new BlockPos(spot)) && !area.contains(spot)) continue;
                ++count;
                continue block0;
            }
        }
        return count >= maxCount && this.IsReplaceableBlock(new BlockPos(pos));
    }

    Vector<Vector3i> GetHoleArea(Vector<Vector3i> area) {
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        int maxLoop = 1000;
        int loop = 0;
        int maxAreaCount = (Integer)ConfigHoleFiller.max_hole_area.get();
        int lastCount = area.size();
        while (loop++ < maxLoop && area.size() < maxAreaCount) {
            for (int i = 0; i < lastCount; ++i) {
                Vector3i centre = area.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    Vector3i dir = dirs.get(j);
                    for (int k = 1; k < 2; ++k) {
                        Vector3i test = Helper.Add(centre, Helper.Multiply(dir, k));
                        if (!this.IsValidHole(area, test) || area.contains(test)) continue;
                        area.add(test);
                        if (area.size() < maxAreaCount) continue;
                        return area;
                    }
                }
            }
            if (lastCount == area.size()) break;
            lastCount = area.size();
        }
        return area;
    }

    boolean IsReplaceableBlock(BlockPos posi) {
        BlockState state = this.field_145850_b.func_180495_p(posi);
        return this.field_145850_b.func_175623_d(posi) || state.func_227032_a_((Fluid)null);
    }

    boolean IsValidBoundaryBlock(BlockPos posi) {
        BlockState state = this.field_145850_b.func_180495_p(posi);
        boolean res = !this.field_145850_b.func_175623_d(posi) && Block.func_208062_a((VoxelShape)state.func_196954_c((IBlockReader)this.field_145850_b, posi)) && state.func_200132_m();
        return res;
    }
}

