/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.util.Helper;
import java.util.ArrayList;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class TileHoleFillerOLD1
extends TileEntity {
    public TileHoleFillerOLD1(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public void Trigger() {
        int holeRadius = 12;
        int maxNumberPlaced = (holeRadius + 1) * 2;
        System.out.println("Triggered");
        BlockPos validStartPos = this.IsValidHole((Vector3i)this.field_174879_c, holeRadius);
        System.out.println("Valid Hole: " + validStartPos != null);
        if (validStartPos == null) {
            return;
        }
        System.out.println("Getting area");
        this.GetHoleArea((Vector3i)validStartPos);
        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150475_bE.func_176223_P());
    }

    BlockPos IsValidHole(Vector3i pos, int maxDimension) {
        int maxCount = 4;
        int count = 0;
        BlockPos validStartPos = null;
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        BlockPos tempStartPos = null;
        block0: for (int i = 0; i < dirs.size(); ++i) {
            Vector3i dir = dirs.get(i);
            for (int j = 1; j < maxDimension; ++j) {
                Vector3i oneBack;
                int neighbourCount;
                Vector3i spot = Helper.Add(pos, Helper.Multiply(dir, j));
                if (!this.IsValidBoundaryBlock(new BlockPos(spot))) continue;
                if (tempStartPos == null && (neighbourCount = this.GetAdjacentBlockCount(new BlockPos(oneBack = Helper.Add(pos, Helper.Multiply(dir, j - 1))))) >= 5) {
                    tempStartPos = new BlockPos(oneBack);
                }
                ++count;
                continue block0;
            }
        }
        if (count >= maxCount) {
            validStartPos = tempStartPos;
        }
        return validStartPos;
    }

    boolean IsValidBoundaryBlock(BlockPos posi) {
        BlockState state = this.field_145850_b.func_180495_p(posi);
        boolean res = !this.field_145850_b.func_175623_d(posi) && Block.func_208062_a((VoxelShape)state.func_196954_c((IBlockReader)this.field_145850_b, posi)) && state.func_177230_c() != Blocks.field_150340_R && state.func_200132_m();
        return res;
    }

    boolean IsPartOfHole(BlockPos pos) {
        return true;
    }

    Vector3i GetCentreOfHole() {
        int iterations = 3;
        BlockPos centre = this.field_174879_c;
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        for (int i = 0; i < iterations; ++i) {
            Vector<Vector3i> bounds = new Vector<Vector3i>();
            for (int j = 0; j < dirs.size(); ++j) {
                Vector3i dir = dirs.get(j);
                BlockPos boundaryPos = this.GetBoundaryAlongAxis(new BlockPos((Vector3i)centre), dir, 16.0f);
                if (boundaryPos != null) {
                    BlockPos backOne = boundaryPos.func_177971_a(Helper.Opposite(dir));
                    bounds.add((Vector3i)boundaryPos);
                    continue;
                }
                bounds.add((Vector3i)new BlockPos(Helper.Add((Vector3i)centre, dir)));
            }
            Vector3i sum = new Vector3i(0, 0, 0);
            centre = Helper.GetCentreFromBounds(bounds);
        }
        this.field_145850_b.func_175656_a(new BlockPos((Vector3i)centre), Blocks.field_150484_ah.func_176223_P());
        return centre;
    }

    BlockPos GetBoundaryAlongAxis(BlockPos startPos, Vector3i dir, float maxLength) {
        block1: {
            BlockPos testBlockPos;
            Vector3i testPos;
            int loop = 0;
            Vector3i start = Helper.Convert(startPos);
            do {
                int n = loop++;
                if (!((float)n < maxLength)) break block1;
            } while ((testPos = Helper.Add(start, Helper.Multiply(dir, loop))) == Helper.Convert(this.field_174879_c) || !this.IsValidBoundaryBlock(testBlockPos = new BlockPos(testPos)));
            return testBlockPos;
        }
        return null;
    }

    int GetAdjacentBlockCount(BlockPos pos) {
        int count = 0;
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        for (int i = 0; i < dirs.size(); ++i) {
            Vector3i dir = dirs.get(i);
            Vector3i test = Helper.Add((Vector3i)pos, dir);
            if (!this.IsValidBoundaryBlock(new BlockPos(test))) continue;
            ++count;
        }
        return count;
    }

    Vector<Vector3i> GetHoleArea(Vector3i startPos) {
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        Vector<Vector3i> area = new Vector<Vector3i>();
        int maxLoop = 100;
        int loop = 0;
        int maxAreaCount = 300;
        area.add(startPos);
        int lastCount = 1;
        while (loop++ < maxLoop && area.size() < maxAreaCount) {
            for (int i = 0; i < area.size(); ++i) {
                Vector3i centre = (Vector3i)area.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    Vector3i dir = dirs.get(j);
                    Vector3i test = Helper.Add(centre, dir);
                    if (!this.IsReplaceableBlock(new BlockPos(test)) || area.contains(test) || !this.CanHolePosBeFilled(area, test)) continue;
                    area.add(test);
                }
            }
            if (lastCount == area.size()) break;
            lastCount = area.size();
        }
        System.out.println("Found area of size " + area.size());
        return area;
    }

    boolean IsReplaceableBlock(BlockPos posi) {
        BlockState state = this.field_145850_b.func_180495_p(posi);
        Block block = state.func_177230_c();
        return state.func_227032_a_((Fluid)null);
    }

    boolean CanHolePosBeFilled(Vector<Vector3i> area, Vector3i posi) {
        Vector<Vector3i> neighbourPos = Helper.GetNeighbourPositions(posi);
        int count = 0;
        for (int i = 0; i < neighbourPos.size(); ++i) {
            Vector3i nPos = neighbourPos.get(i);
            if (!this.IsValidBoundaryBlock(new BlockPos(nPos))) continue;
            ++count;
        }
        return count >= 5;
    }
}

