/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.blocks.BlockCuring;
import com.dannyboythomas.hole_filler_mod.init.InitBlocks;
import com.dannyboythomas.hole_filler_mod.util.Helper;
import java.util.ArrayList;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class TileHoleFillerOLD2
extends TileEntity {
    public TileHoleFillerOLD2(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public void Trigger() {
        System.out.println("Triggered");
        Vector3i centre = this.GetCentreOfHole();
        System.out.println("Placing Flower");
        Vector<Vector3i> flower = this.PlaceFlower();
        Vector<Vector3i> area = new Vector<Vector3i>();
        area.addAll(flower);
        area = this.GetHoleArea(area);
        this.FillHole(area);
    }

    Vector3i GetCentreOfHole() {
        int iterations = 3;
        BlockPos centre = this.field_174879_c;
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        for (int i = 0; i < iterations; ++i) {
            Vector<Vector3i> bounds = new Vector<Vector3i>();
            for (int j = 0; j < dirs.size(); ++j) {
                Vector3i dir = dirs.get(j);
                BlockPos boundaryPos = this.GetBoundaryAlongAxis(new BlockPos((Vector3i)centre), dir, 16.0f);
                if (boundaryPos != null) {
                    BlockPos backOne = boundaryPos.func_177971_a(Helper.Opposite(dir));
                    bounds.add((Vector3i)boundaryPos);
                    continue;
                }
                bounds.add((Vector3i)new BlockPos(Helper.Add((Vector3i)centre, dir)));
            }
            Vector3i sum = new Vector3i(0, 0, 0);
            centre = Helper.GetCentreFromBounds(bounds);
        }
        this.field_145850_b.func_175656_a(new BlockPos((Vector3i)centre), Blocks.field_150484_ah.func_176223_P());
        return centre;
    }

    BlockPos GetBoundaryAlongAxis(BlockPos startPos, Vector3i dir, float maxLength) {
        block1: {
            BlockPos testBlockPos;
            Vector3i testPos;
            int loop = 0;
            Vector3i start = Helper.Convert(startPos);
            do {
                int n = loop++;
                if (!((float)n < maxLength)) break block1;
            } while ((testPos = Helper.Add(start, Helper.Multiply(dir, loop))) == Helper.Convert(this.field_174879_c) || !this.IsValidBoundaryBlock(testBlockPos = new BlockPos(testPos)));
            return testBlockPos;
        }
        return null;
    }

    boolean IsValidBoundaryBlock(BlockPos posi) {
        BlockState state = this.field_145850_b.func_180495_p(posi);
        boolean res = !this.field_145850_b.func_175623_d(posi) && Block.func_208062_a((VoxelShape)state.func_196954_c((IBlockReader)this.field_145850_b, posi)) && state.func_177230_c() != Blocks.field_150340_R && state.func_200132_m();
        return res;
    }

    Vector<Vector3i> PlaceFlower() {
        Vector<Vector3i> list = this.GetReplacebleNeighbours((Vector3i)this.field_174879_c);
        System.out.println("neighs:" + list.size());
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        for (int j = 0; j < dirs.size(); ++j) {
            Vector3i dir = dirs.get(j);
            for (int i = 0; i < 12; ++i) {
                Vector3i vec = Helper.Add((Vector3i)this.field_174879_c, Helper.Multiply(dir, i));
                if (!this.IsReplaceableBlock(new BlockPos(vec))) continue;
                this.field_145850_b.func_175656_a(new BlockPos(list.get(i)), ((BlockCuring)InitBlocks.curing_block.get()).func_176223_P());
                list.add(vec);
            }
        }
        return list;
    }

    Vector<Vector3i> GetReplacebleNeighbours(Vector3i posi) {
        Vector<Vector3i> beforeRemoval = Helper.GetNeighbourPositions(posi);
        Vector<Vector3i> afterRemoval = new Vector<Vector3i>();
        for (int i = 0; i < beforeRemoval.size(); ++i) {
            Vector3i vec = beforeRemoval.get(i);
            if (!this.IsReplaceableBlock(new BlockPos(vec))) continue;
            afterRemoval.add(vec);
        }
        return afterRemoval;
    }

    boolean CanHolePosBeFilled(Vector<Vector3i> area, Vector3i posi) {
        Vector<Vector3i> neighbourPos = Helper.GetNeighbourPositions(posi);
        int count = 0;
        for (int i = 0; i < neighbourPos.size(); ++i) {
            Vector3i nPos = neighbourPos.get(i);
            if (!this.IsValidBoundaryBlock(new BlockPos(nPos)) && !area.contains(nPos)) continue;
            ++count;
        }
        return count >= 3 && this.IsReplaceableBlock(new BlockPos(posi));
    }

    Vector<Vector3i> GetHoleArea(Vector<Vector3i> area) {
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        int maxLoop = 50;
        int loop = 0;
        int maxAreaCount = 600;
        int lastCount = area.size();
        while (loop++ < maxLoop && area.size() < maxAreaCount) {
            System.out.println("Searching area:" + area.size());
            for (int i = 0; i < lastCount; ++i) {
                Vector3i centre = area.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    Vector3i dir = dirs.get(j);
                    Vector3i test = Helper.Add(centre, dir);
                    if (!this.IsReplaceableBlock(new BlockPos(test)) || area.contains(test) || !this.CanHolePosBeFilled(area, test)) continue;
                    area.add(test);
                }
            }
            if (lastCount == area.size()) break;
            lastCount = area.size();
        }
        System.out.println("Found area of size " + area.size());
        return area;
    }

    boolean IsReplaceableBlock(BlockPos posi) {
        BlockState state = this.field_145850_b.func_180495_p(posi);
        Block block = state.func_177230_c();
        return this.field_145850_b.func_175623_d(posi) || state.func_227032_a_((Fluid)null);
    }

    void FillHole(Vector<Vector3i> area) {
        for (int i = 0; i < area.size(); ++i) {
            Vector3i vec = area.get(i);
            this.field_145850_b.func_175656_a(new BlockPos(vec), ((BlockCuring)InitBlocks.curing_block.get()).func_176223_P());
        }
    }

    void TryExpandAxis() {
    }
}

