/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.blocks.BlockCuring;
import com.dannyboythomas.hole_filler_mod.init.InitBlocks;
import com.dannyboythomas.hole_filler_mod.util.Helper;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class TileHoleFillerOLD3
extends TileEntity {
    public TileHoleFillerOLD3(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public void Trigger() {
        Vector<Vector3i> area = new Vector<Vector3i>();
        area.add((Vector3i)this.field_174879_c);
        area = this.GetHoleArea(area);
        area.remove(this.field_174879_c);
        this.FillHole(area);
    }

    Vector3i GetCentreOfHole() {
        int iterations = 5;
        BlockPos centre = this.field_174879_c;
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        for (int i = 0; i < iterations; ++i) {
            Vector<Vector3i> bounds = new Vector<Vector3i>();
            for (int j = 0; j < dirs.size(); ++j) {
                Vector3i dir = dirs.get(j);
                BlockPos boundaryPos = this.GetBoundaryAlongAxis(new BlockPos((Vector3i)centre), dir, 16.0f);
                if (boundaryPos != null) {
                    BlockPos backOne = boundaryPos.func_177971_a(Helper.Opposite(dir));
                    bounds.add((Vector3i)boundaryPos);
                    continue;
                }
                bounds.add((Vector3i)new BlockPos(Helper.Add((Vector3i)centre, dir)));
            }
            Vector3i sum = new Vector3i(0, 0, 0);
            centre = Helper.GetCentreFromBounds(bounds);
        }
        this.field_145850_b.func_175656_a(new BlockPos((Vector3i)centre), Blocks.field_150484_ah.func_176223_P());
        return centre;
    }

    Vector<Vector3i> GetFreeAxis() {
        Vector<Vector3i> axes = new Vector<Vector3i>();
        Vector3i centre = this.GetCentreOfHole();
        BlockPos centrePos = new BlockPos(centre);
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        for (int i = 0; i < dirs.size(); ++i) {
            Vector3i dir = dirs.get(i);
            BlockPos boundary = this.GetBoundaryAlongAxis(centrePos, dir, 8.0f);
            if (boundary != null || axes.size() >= 2) continue;
            axes.add(dir);
            this.field_145850_b.func_175656_a(new BlockPos(Helper.Add(dir, centre)), Blocks.field_150340_R.func_176223_P());
        }
        return axes;
    }

    boolean IsValidHole(Vector3i pos, int maxDimension) {
        int maxCount = 4;
        int count = 0;
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        block0: for (int i = 0; i < dirs.size(); ++i) {
            Vector3i dir = dirs.get(i);
            for (int j = 1; j < maxDimension; ++j) {
                Vector3i spot = Helper.Add(pos, Helper.Multiply(dir, j));
                if (!this.IsValidBoundaryBlock(new BlockPos(spot))) continue;
                Vector3i oneBack = Helper.Add(pos, Helper.Multiply(dir, j - 1));
                ++count;
                continue block0;
            }
        }
        return count >= maxCount;
    }

    BlockPos GetBoundaryAlongAxis(BlockPos startPos, Vector3i dir, float maxLength) {
        block1: {
            BlockPos testBlockPos;
            Vector3i testPos;
            int loop = 0;
            Vector3i start = Helper.Convert(startPos);
            do {
                int n = loop++;
                if (!((float)n < maxLength)) break block1;
            } while ((testPos = Helper.Add(start, Helper.Multiply(dir, loop))) == Helper.Convert(this.field_174879_c) || !this.IsValidBoundaryBlock(testBlockPos = new BlockPos(testPos)));
            return testBlockPos;
        }
        return null;
    }

    boolean IsValidBoundaryBlock(BlockPos posi) {
        BlockState state = this.field_145850_b.func_180495_p(posi);
        boolean res = !this.field_145850_b.func_175623_d(posi) && Block.func_208062_a((VoxelShape)state.func_196954_c((IBlockReader)this.field_145850_b, posi)) && state.func_177230_c() != Blocks.field_150340_R && state.func_200132_m();
        return res;
    }

    Vector<Vector3i> GetHoleArea(Vector<Vector3i> area) {
        ArrayList<Vector3i> dirs = Helper.DirectionVectors;
        int maxLoop = 50;
        int loop = 0;
        int maxAreaCount = 100;
        int lastCount = area.size();
        while (loop++ < maxLoop && area.size() < maxAreaCount) {
            System.out.println("Searching area:" + area.size());
            for (int i = 0; i < lastCount; ++i) {
                Vector3i centre = area.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    Vector3i dir = dirs.get(j);
                    for (int k = 1; k < 12; ++k) {
                        Vector3i test = Helper.Add(centre, Helper.Multiply(dir, k));
                        if (!this.IsReplaceableBlock(new BlockPos(test)) || area.contains(test) || !this.CanHolePosBeFilled(area, test)) continue;
                        area.add(test);
                    }
                }
            }
            if (lastCount == area.size()) break;
            lastCount = area.size();
        }
        System.out.println("Found area of size " + area.size());
        return area;
    }

    boolean IsReplaceableBlock(BlockPos posi) {
        BlockState state = this.field_145850_b.func_180495_p(posi);
        Block block = state.func_177230_c();
        return this.field_145850_b.func_175623_d(posi) || state.func_227032_a_((Fluid)null);
    }

    boolean CanHolePosBeFilled(Vector<Vector3i> area, Vector3i posi) {
        Vector<Vector3i> neighbourPos = Helper.GetNeighbourPositions(posi);
        int count = 0;
        for (int i = 0; i < neighbourPos.size(); ++i) {
            Vector3i nPos = neighbourPos.get(i);
            if (!this.IsValidBoundaryBlock(new BlockPos(nPos)) && !area.contains(nPos)) continue;
            ++count;
        }
        return count >= 4 && this.IsReplaceableBlock(new BlockPos(posi)) || this.IsValidHole(posi, 2);
    }

    void FillHole(Vector<Vector3i> area) {
        for (int i = 0; i < area.size(); ++i) {
            Vector3i vec = area.get(i);
            this.field_145850_b.func_175656_a(new BlockPos(vec), ((BlockCuring)InitBlocks.curing_block.get()).func_176223_P());
        }
    }

    void RandomConnection(Vector<Vector3i> area) {
        int index;
        Random rnd = new Random();
        int index2 = index = rnd.nextInt(area.size());
        while (index2 == index) {
            index2 = rnd.nextInt(area.size());
        }
        Vector3i one = area.get(index);
        Vector3i two = area.get(index2);
        Vector3i centre = Helper.Add(one, two);
        centre = Helper.DivideAndRound(centre, 2.0f);
        Vector3i dirOne = Helper.Add(one, Helper.Multiply(centre, -1.0f));
        Vector3i dirTwo = Helper.Add(two, Helper.Multiply(centre, -1.0f));
    }
}

