/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.blocks;

import com.dannyboythomas.hole_filler_mod.config.ClientConfigHandler;
import com.dannyboythomas.hole_filler_mod.config.HoleFillerConfig;
import com.dannyboythomas.hole_filler_mod.init.ModBlocks;
import com.dannyboythomas.hole_filler_mod.util.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCuring
extends Block {
    public static final PropertyInteger CURED = PropertyInteger.func_177719_a((String)"cured", (int)1, (int)9);

    public BlockCuring(Material mat) {
        super(mat);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)CURED, (Comparable)Integer.valueOf(1)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CURED});
    }

    public IBlockState func_176203_a(int meta) {
        int val = meta;
        int min = Math.min(9, val);
        int max = Math.max(min, 1);
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)CURED, (Comparable)Integer.valueOf(max));
    }

    public int func_176201_c(IBlockState state) {
        int val = (Integer)state.func_177229_b((IProperty)CURED);
        int min = Math.min(9, val);
        int max = Math.max(min, 1);
        return max;
    }

    public boolean func_149653_t() {
        return true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        super.func_180645_a(worldIn, pos, state, random);
        int cured = (Integer)state.func_177229_b((IProperty)CURED);
        if (!worldIn.field_72995_K) {
            worldIn.func_180497_b(pos, state.func_177230_c(), 1, 1);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            worldIn.func_180497_b(pos, state.func_177230_c(), 1, 1);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (worldIn.field_72995_K) {
            return;
        }
        int cured = (Integer)state.func_177229_b((IProperty)CURED);
        if (worldIn.func_184145_b(pos, state.func_177230_c())) {
            return;
        }
        Random rnd = new Random();
        int totalTurnTimeTicks = HoleFillerConfig.undo_timer * 20;
        int minWait = totalTurnTimeTicks / 8;
        int remainder = totalTurnTimeTicks % 7;
        if (cured < 8) {
            worldIn.func_180497_b(pos, state.func_177230_c(), minWait, 1);
            if (rnd.nextInt(10) > 3) {
                worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)CURED, (Comparable)Integer.valueOf(cured + 1)));
            }
        } else if (cured == 8) {
            worldIn.func_180497_b(pos, state.func_177230_c(), remainder + minWait, 1);
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)CURED, (Comparable)Integer.valueOf(cured + 1)));
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (!worldIn.field_72995_K) {
            Vector<Vec3i> list = BlockCuring.GetBreakableVein(worldIn, (Vec3i)pos);
            System.out.println("Vein:" + list.size());
            for (int i = 0; i < list.size(); ++i) {
                BlockPos p = new BlockPos(list.get(i));
                worldIn.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public static Vector<Vec3i> GetBreakableVein(World world, Vec3i vec) {
        Vector<Vec3i> list = new Vector<Vec3i>();
        Block thisBlock = world.func_180495_p(new BlockPos(vec)).func_177230_c();
        list.add(vec);
        int size = list.size();
        int maxLoop = 100;
        int loop = 0;
        while (loop++ < maxLoop) {
            for (int i = 0; i < size; ++i) {
                Vector<Vec3i> neighbours = BlockCuring.GetBreakableNeighbours(world, list.get(i));
                for (int j = 0; j < neighbours.size(); ++j) {
                    if (list.contains(neighbours.get(j))) continue;
                    list.add(neighbours.get(j));
                }
            }
            if (size == list.size()) break;
            size = list.size();
        }
        return list;
    }

    public static Vector<Vec3i> GetBreakableNeighbours(World world, Vec3i vec) {
        Block thisBlock = ModBlocks.BLOCK_CURING;
        ArrayList<Vec3i> dirs = Helper.DirectionVectors;
        Vector<Vec3i> list = new Vector<Vec3i>();
        for (int i = 0; i < dirs.size(); ++i) {
            Vec3i dir = dirs.get(i);
            Vec3i pos = Helper.Add(vec, dir);
            Block testBlock = world.func_180495_p(new BlockPos(pos)).func_177230_c();
            if (testBlock != thisBlock && testBlock != ModBlocks.BLOCK_HOLE_FILLER) continue;
            list.add(pos);
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (GuiScreen.func_146272_n()) {
            tooltip.add("Will turn to dirt after \u00a7a" + ClientConfigHandler.config_undo_timer + "\u00a77 seconds.");
            tooltip.add("Breaking one will cause a chain reaction to break all connected Curing Blocks");
        } else {
            tooltip.add("Hold 'shift' for info.");
        }
        super.func_190948_a(stack, player, tooltip, advanced);
    }
}

