/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.config;

import com.dannyboythomas.hole_filler_mod.HoleFillerMod;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class HoleFillerConfig {
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_DIMENSIONS = "dimensions";
    public static int max_hole_diameter = 12;
    public static int max_hole_volume = 1000;
    public static int undo_timer = 15;
    public static int fill_speed = 5;

    public static void readConfig() {
        Configuration cfg = HoleFillerMod.config;
        try {
            cfg.load();
            HoleFillerConfig.initGeneralConfig(cfg);
        }
        catch (Exception e1) {
            HoleFillerMod.LOGGER.log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_GENERAL, "General configuration");
        max_hole_diameter = cfg.getInt("Max Hole Diameter", CATEGORY_GENERAL, max_hole_diameter, 3, 32, "Maximum diameter that the hole filler will consider a hole. If hole is larger than this value, it will not fill on that axis.  Default = 12, Min = 3, Max = 32");
        max_hole_volume = cfg.getInt("Max Hole Volume", CATEGORY_GENERAL, max_hole_volume, 1, 3000, "Maximum number of blocks that can be placed per hole. Default = 1000, Min = 1, Max = 3000");
        undo_timer = cfg.getInt("Undo Timer", CATEGORY_GENERAL, undo_timer, 1, 120, "How long before 'Curing Blocks' are converted to dirt, in seconds. This is an approximation as some randomness is involved. Default = 15, Min = 1, Max = 120");
        fill_speed = cfg.getInt("Fill Speed", CATEGORY_GENERAL, fill_speed, 5, 120, "How many 'Curing Blocks' placed per tick. Default = 5, Min = 1, Max = 120");
    }
}

