/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.config.HoleFillerConfig;
import com.dannyboythomas.hole_filler_mod.init.ModBlocks;
import com.dannyboythomas.hole_filler_mod.util.Helper;
import com.dannyboythomas.hole_filler_mod.util.OrderByDistance;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class TileHoleFiller
extends TileEntity
implements ITickable {
    int timer = 0;
    boolean running = false;
    Vector<Vec3i> area;

    public void func_73660_a() {
        if (this.running && this.timer++ % 1 == 0) {
            this.area = this.FillHole(this.area);
            if (this.area.size() <= 0) {
                this.running = false;
                this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.BLOCK_CURING.func_176223_P());
            }
        }
    }

    public void Trigger() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.timer = 0;
        this.area = new Vector();
        this.area.add((Vec3i)this.field_174879_c);
        this.area = this.GetHoleArea(this.area);
        this.area.remove(this.field_174879_c);
        this.area.sort(new OrderByDistance(Helper.Vec3d(this.field_174879_c)));
    }

    Vector<Vec3i> FillHole(Vector<Vec3i> area) {
        int blocksPerTick = HoleFillerConfig.fill_speed;
        for (int i = 0; i < blocksPerTick; ++i) {
            Random rnd;
            if (area.size() <= 0) continue;
            Vec3i vec = area.firstElement();
            if (i == 0 && (double)(rnd = new Random()).nextFloat() > 0.3) {
                this.field_145850_b.func_184133_a(null, new BlockPos(vec), SoundEvents.field_187753_eE, SoundCategory.BLOCKS, 0.35f, 0.4f / (rnd.nextFloat() * 0.4f + 0.8f));
            }
            area.remove(0);
            if (!this.IsReplaceableBlock(new BlockPos(vec))) continue;
            this.field_145850_b.func_175656_a(new BlockPos(vec), ModBlocks.BLOCK_CURING.func_176223_P());
        }
        return area;
    }

    boolean IsValidHole(Vector<Vec3i> area, Vec3i pos) {
        int configMaxDiameter = HoleFillerConfig.max_hole_diameter;
        int maxDimension = configMaxDiameter / 2;
        int maxCount = 4;
        int count = 0;
        ArrayList<Vec3i> dirs = Helper.DirectionVectors;
        block0: for (int i = 0; i < dirs.size(); ++i) {
            Vec3i dir = dirs.get(i);
            for (int j = 1; j < maxDimension; ++j) {
                Vec3i spot = Helper.Add(pos, Helper.Multiply(dir, j));
                if (!this.IsValidBoundaryBlock(new BlockPos(spot)) && !area.contains(spot)) continue;
                ++count;
                continue block0;
            }
        }
        return count >= maxCount && this.IsReplaceableBlock(new BlockPos(pos));
    }

    Vector<Vec3i> GetHoleArea(Vector<Vec3i> area) {
        ArrayList<Vec3i> dirs = Helper.DirectionVectors;
        int maxLoop = 1000;
        int loop = 0;
        int maxAreaCount = HoleFillerConfig.max_hole_volume;
        int lastCount = area.size();
        while (loop++ < maxLoop && area.size() < maxAreaCount) {
            for (int i = 0; i < lastCount; ++i) {
                Vec3i centre = area.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    Vec3i dir = dirs.get(j);
                    for (int k = 1; k < 2; ++k) {
                        Vec3i test = Helper.Add(centre, Helper.Multiply(dir, k));
                        if (!this.IsValidHole(area, test) || area.contains(test)) continue;
                        area.add(test);
                        if (area.size() < maxAreaCount) continue;
                        return area;
                    }
                }
            }
            if (lastCount == area.size()) break;
            lastCount = area.size();
        }
        return area;
    }

    boolean IsReplaceableBlock(BlockPos posi) {
        IBlockState state = this.field_145850_b.func_180495_p(posi);
        boolean isReplaceable = state.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, posi) || state.func_177230_c() instanceof BlockLiquid;
        return this.field_145850_b.func_175623_d(posi) || isReplaceable;
    }

    boolean IsValidBoundaryBlock(BlockPos posi) {
        IBlockState state = this.field_145850_b.func_180495_p(posi);
        boolean opaque = state.func_185914_p();
        boolean solid = state.func_185915_l();
        boolean isLeaves = state.func_177230_c().isLeaves(state, (IBlockAccess)this.field_145850_b, posi);
        boolean res = !this.field_145850_b.func_175623_d(posi) && opaque && solid && !isLeaves;
        return res;
    }
}

