/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util;

import com.sun.javafx.geom.Vec3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Helper {
    public static ArrayList<Vec3i> DirectionVectors = new ArrayList<Vec3i>(Arrays.asList(new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1), new Vec3i(0, -1, 0), new Vec3i(0, 1, 0)));

    public static Vec3i GetDirection(Directions dir) {
        int index = dir.ordinal();
        return DirectionVectors.get(index);
    }

    public static Vec3i Multiply(Vec3i vec, float a) {
        float x = (float)vec.func_177958_n() * a;
        float y = (float)vec.func_177956_o() * a;
        float z = (float)vec.func_177952_p() * a;
        return new Vec3i((double)x, (double)y, (double)z);
    }

    public static Vec3f Divide(Vec3i vec, float a) {
        float x = (float)vec.func_177958_n() / a;
        float y = (float)vec.func_177956_o() / a;
        float z = (float)vec.func_177952_p() / a;
        return new Vec3f(x, y, z);
    }

    public static Vec3i DivideAndRound(Vec3i vec, float a) {
        float x = (float)vec.func_177958_n() / a;
        float y = (float)vec.func_177956_o() / a;
        float z = (float)vec.func_177952_p() / a;
        return new Vec3i(Math.round(x), Math.round(y), Math.round(z));
    }

    public static Vec3i Opposite(Vec3i vec) {
        return Helper.Multiply(vec, -1.0f);
    }

    public static Vec3i Add(Vec3i vec, Vec3i vec2) {
        float x = vec.func_177958_n() + vec2.func_177958_n();
        float y = vec.func_177956_o() + vec2.func_177956_o();
        float z = vec.func_177952_p() + vec2.func_177952_p();
        return new Vec3i((double)x, (double)y, (double)z);
    }

    public static ArrayList<Vec3i> RandomDirectionOrder() {
        ArrayList copy = (ArrayList)DirectionVectors.clone();
        Collections.shuffle(copy);
        return copy;
    }

    public static Vec3i GetCentreFromBounds(Vector<Vec3i> vecs) {
        int minX = Helper.MinVecValue(vecs, 0);
        int minY = Helper.MinVecValue(vecs, 1);
        int minZ = Helper.MinVecValue(vecs, 2);
        int maxX = Helper.MaxVecValue(vecs, 0);
        int maxY = Helper.MaxVecValue(vecs, 1);
        int maxZ = Helper.MaxVecValue(vecs, 2);
        int centreX = Math.round((float)(minX + maxX) * 0.5f);
        int centreY = Math.round((float)(minY + maxY) * 0.5f);
        int centreZ = Math.round((float)(minZ + maxZ) * 0.5f);
        return new Vec3i(centreX, centreY, centreZ);
    }

    public static int MinVecValue(Vector<Vec3i> vecs, int index) {
        int min = 999999999;
        for (int i = 0; i < vecs.size(); ++i) {
            Vec3i vec = vecs.get(i);
            int[] array = Helper.ToArray(vec);
            int value = array[index];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static int MaxVecValue(Vector<Vec3i> vecs, int index) {
        int max = -999999999;
        for (int i = 0; i < vecs.size(); ++i) {
            Vec3i vec = vecs.get(i);
            int[] array = Helper.ToArray(vec);
            int value = array[index];
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static String ToString(BlockPos pos) {
        String s = "[x: " + pos.func_177958_n() + ", y: " + pos.func_177956_o() + ", z: " + pos.func_177952_p() + "]";
        return s;
    }

    public static BlockPos Convert(int[] array) {
        return new BlockPos(array[0], array[1], array[2]);
    }

    public static int[] ToArray(Vec3i vec) {
        return new int[]{vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p()};
    }

    public static int Map(int n, int a, int b, int x, int y) {
        return x + (n - a) * (y - x) / (b - a);
    }

    public static double GetDistance(Vec3d vec1, Vec3d vec2) {
        double xDif = Math.abs(vec1.field_72450_a - vec2.field_72450_a);
        double yDif = Math.abs(vec1.field_72448_b - vec2.field_72448_b);
        double zDif = Math.abs(vec1.field_72449_c - vec2.field_72449_c);
        double total = Math.pow(xDif, 2.0) + Math.pow(yDif, 2.0) + Math.pow(zDif, 2.0);
        double ans = Math.sqrt(total);
        return ans;
    }

    public static Vec3d Vec3d(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static Vec3i Convert(BlockPos pos) {
        return new Vec3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static Vector<Vec3i> GetNeighbourPositions(Vec3i vec) {
        ArrayList<Vec3i> dirs = DirectionVectors;
        Vector<Vec3i> list = new Vector<Vec3i>();
        for (int i = 0; i < dirs.size(); ++i) {
            Vec3i dir = dirs.get(i);
            list.add(Helper.Add(vec, dir));
        }
        return list;
    }

    public static Vector<Vec3i> GetSameBlockNeighbours(World world, Vec3i vec) {
        Block thisBlock = world.func_180495_p(new BlockPos(vec)).func_177230_c();
        ArrayList<Vec3i> dirs = DirectionVectors;
        Vector<Vec3i> list = new Vector<Vec3i>();
        for (int i = 0; i < dirs.size(); ++i) {
            Vec3i dir = dirs.get(i);
            Vec3i pos = Helper.Add(vec, dir);
            System.out.println("Comparinng " + thisBlock + " and " + world.func_180495_p(new BlockPos(pos)).func_177230_c());
            if (world.func_180495_p(new BlockPos(pos)).func_177230_c() != thisBlock) continue;
            list.add(pos);
        }
        return list;
    }

    public static Vector<Vec3i> GetSameBlockVein(World world, Vec3i vec) {
        Vector<Vec3i> list = new Vector<Vec3i>();
        Block thisBlock = world.func_180495_p(new BlockPos(vec)).func_177230_c();
        System.out.println(thisBlock);
        list.add(vec);
        int size = list.size();
        int maxLoop = 100;
        int loop = 0;
        while (loop++ < maxLoop) {
            for (int i = 0; i < size; ++i) {
                Vector<Vec3i> neighbours = Helper.GetSameBlockNeighbours(world, list.get(i));
                for (int j = 0; j < neighbours.size(); ++j) {
                    if (list.contains(neighbours.get(j))) continue;
                    list.add(neighbours.get(j));
                }
            }
            if (size == list.size()) break;
            size = list.size();
        }
        return list;
    }

    public static enum Directions {
        down,
        up,
        xMinus,
        xPlus,
        zMinus,
        zPlus;

    }
}

