/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.config;

import com.github.burgerguy.hudtweaks.hud.HudContainer;
import com.github.burgerguy.hudtweaks.util.Util;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Level;

public enum ConfigHelper {

    public static final Path configFile = FabricLoader.getInstance().getConfigDir().resolve("hudtweaks.json");

    public static void tryLoadConfig() {
        if (Files.exists(configFile, new LinkOption[0])) {
            Util.LOGGER.log(Level.INFO, "Loading config file...");
            try (BufferedReader reader = new BufferedReader(new FileReader(configFile.toFile()));){
                HudContainer.updateFromJson(Util.JSON_PARSER.parse((Reader)reader));
            }
            catch (JsonIOException e) {
                Util.LOGGER.error("Unable to read config file", (Throwable)e);
            }
            catch (JsonParseException e) {
                Util.LOGGER.error("Config file invalid", (Throwable)e);
            }
            catch (IOException e) {
                Util.LOGGER.error("Error loading config file", (Throwable)e);
            }
        } else {
            Util.LOGGER.log(Level.INFO, "Config file not found");
        }
    }

    public static void trySaveConfig() {
        Util.LOGGER.log(Level.INFO, "Saving config file...");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(configFile.toFile()));){
            Util.GSON.toJson(HudContainer.getElementMap(), (Appendable)writer);
        }
        catch (JsonIOException e) {
            Util.LOGGER.error("Unable to write to config file", (Throwable)e);
        }
        catch (IOException e) {
            Util.LOGGER.error("Error saving config file", (Throwable)e);
        }
    }
}

