/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.gui;

import com.github.burgerguy.hudtweaks.config.ConfigHelper;
import com.github.burgerguy.hudtweaks.gui.widget.ArrowButtonWidget;
import com.github.burgerguy.hudtweaks.gui.widget.ElementLabelWidget;
import com.github.burgerguy.hudtweaks.gui.widget.SidebarWidget;
import com.github.burgerguy.hudtweaks.hud.HudContainer;
import com.github.burgerguy.hudtweaks.hud.element.HudElement;
import com.github.burgerguy.hudtweaks.hud.element.HudElementWidget;
import com.github.burgerguy.hudtweaks.util.Util;
import io.netty.util.BooleanSupplier;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4893;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class HTOptionsScreen
extends class_437 {
    private static final int SIDEBAR_WIDTH = 116;
    private static final int SIDEBAR_COLOR = 1614955074;
    private static int screensOpened = 0;
    private final class_437 prevScreen;
    private final SidebarWidget sidebar;
    private ElementLabelWidget elementLabel;
    private HudElementWidget focusedHudElement;
    private boolean worldExists = false;

    public HTOptionsScreen(class_437 prevScreen) {
        super((class_2561)new class_2588("hudtweaks.options"));
        this.prevScreen = prevScreen;
        this.sidebar = new SidebarWidget(this, 116, 1614955074);
    }

    protected void method_25426() {
        super.method_25426();
        this.sidebar.clearGlobalDrawables();
        this.sidebar.updateScrolledDist();
        ++screensOpened;
        boolean bl = this.worldExists = this.field_22787.field_1687 != null;
        if (this.worldExists) {
            for (HudElement element : HudContainer.getElements()) {
                HudElementWidget widget = element.createWidget(this.sidebar::updateValues);
                if (widget == null) continue;
                this.field_22786.add(widget);
            }
            this.field_22786.sort((e1, e2) -> {
                boolean isHudElement1 = e1 instanceof HudElementWidget;
                boolean isHudElement2 = e2 instanceof HudElementWidget;
                if (isHudElement1 && !isHudElement2) {
                    return 1;
                }
                if (isHudElement1 && isHudElement2) {
                    return ((HudElementWidget)e1).compareTo((HudElementWidget)e2);
                }
                return 0;
            });
            this.field_22786.add(0, this.sidebar);
            this.elementLabel = new ElementLabelWidget(this.sidebar.width / 2, this.field_22790 - 17, this.sidebar.width - 42);
            ArrowButtonWidget leftArrow = new ArrowButtonWidget(5, this.field_22790 - 21, true, (class_2561)new class_2588("hudtweaks.options.previous_element.name"), b -> this.changeHudElementFocus(false));
            ArrowButtonWidget rightArrow = new ArrowButtonWidget(this.sidebar.width - 21, this.field_22790 - 21, false, (class_2561)new class_2588("hudtweaks.options.next_element.name"), b -> this.changeHudElementFocus(true));
            this.sidebar.addGlobalDrawable(this.elementLabel);
            this.sidebar.addGlobalDrawable((class_4068)leftArrow);
            this.sidebar.addGlobalDrawable((class_4068)rightArrow);
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        --screensOpened;
        this.method_25423(client, width, height);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        super.method_25420(matrixStack);
        if (this.worldExists) {
            for (int i = this.field_22786.size() - 1; i >= 0; --i) {
                class_364 element = (class_364)this.field_22786.get(i);
                if (!(element instanceof class_4068) || element instanceof class_339) continue;
                ((class_4068)element).method_25394(matrixStack, mouseX, mouseY, delta);
            }
            super.method_25394(matrixStack, mouseX, mouseY, delta);
        } else {
            class_2588 text = new class_2588("hudtweaks.options.no_world_prompt");
            List wrappedLines = this.field_22793.method_1728((class_5348)text, this.field_22789);
            int n = wrappedLines.size();
            this.field_22793.getClass();
            int textHeight = n * 9;
            int drawYOffset = 0;
            for (class_5481 line : wrappedLines) {
                this.field_22793.method_27517(matrixStack, line, (float)this.field_22789 / 2.0f - (float)this.field_22793.method_30880(line) / 2.0f, (float)this.field_22790 / 2.0f - (float)textHeight / 2.0f + (float)drawYOffset, -1);
                this.field_22793.getClass();
                drawYOffset += 9;
            }
        }
    }

    public void method_25433(class_4587 matrixStack, int vOffset) {
        if (!this.worldExists) {
            this.method_25434(vOffset);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_364 clickedElement = null;
        for (class_364 element : this.method_25396()) {
            if (!element.method_25402(mouseX, mouseY, button)) continue;
            clickedElement = element;
            break;
        }
        if (this.focusedHudElement != null && clickedElement instanceof HudElementWidget && !this.focusedHudElement.equals(clickedElement)) {
            while (this.focusedHudElement.method_25407(true)) {
            }
        }
        this.method_25395(clickedElement);
        if (clickedElement != null) {
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return false;
    }

    public void method_25419() {
        ConfigHelper.trySaveConfig();
        for (class_364 child : this.field_22786) {
            if (!(child instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)child).close();
            }
            catch (Exception e) {
                Util.LOGGER.error("Error closing HUDTweaks options screen", (Throwable)e);
            }
        }
        if (this.field_22787.field_1687 == null) {
            this.field_22787.method_1507(this.prevScreen);
        } else {
            this.field_22787.method_1507(null);
        }
        --screensOpened;
    }

    public void method_25395(class_364 focused) {
        if (focused instanceof HudElementWidget && !focused.equals(this.focusedHudElement)) {
            this.focusedHudElement = (HudElementWidget)focused;
            this.sidebar.clearDrawables();
            HudElement element = this.focusedHudElement.getElement();
            element.fillSidebar(this.sidebar);
            this.sidebar.setSidebarOptionsHeightSupplier(() -> element.getSidebarOptionsHeight());
            this.elementLabel.setHudElement(element);
        }
        if (focused == null) {
            this.focusedHudElement = null;
            this.sidebar.clearDrawables();
            this.sidebar.setSidebarOptionsHeightSupplier(null);
            if (this.elementLabel != null) {
                this.elementLabel.setHudElement(null);
            }
        }
        super.method_25395(focused);
    }

    public boolean method_25407(boolean lookForwards) {
        return this.sidebar.method_25407(lookForwards);
    }

    private void changeHudElementFocus(boolean lookForwards) {
        BooleanSupplier hasNearbySupplier;
        int curIdx;
        List children = this.method_25396();
        int newIdx = 0;
        newIdx = this.focusedHudElement != null && (curIdx = children.indexOf(this.focusedHudElement)) >= 0 ? curIdx + (lookForwards ? 1 : 0) : (lookForwards ? 0 : children.size());
        ListIterator listIterator = children.listIterator(newIdx);
        BooleanSupplier booleanSupplier = lookForwards ? listIterator::hasNext : (hasNearbySupplier = listIterator::hasPrevious);
        Supplier<class_364> elementSupplier = lookForwards ? listIterator::next : listIterator::previous;
        class_364 currentElement = null;
        do {
            try {
                if (!hasNearbySupplier.get()) {
                    return;
                }
            }
            catch (Exception ignored) {
                return;
            }
        } while (!((currentElement = elementSupplier.get()) instanceof HudElementWidget) || !currentElement.method_25407(lookForwards));
        if (this.focusedHudElement != null) {
            while (this.focusedHudElement.method_25407(true)) {
            }
        }
        this.method_25395(currentElement);
    }

    public void method_25393() {
        for (class_364 element : this.method_25396()) {
            if (element instanceof class_4893) {
                ((class_4893)element).method_25393();
            }
            if (!(element instanceof class_342)) continue;
            ((class_342)element).method_1865();
        }
    }

    public static boolean isOpen() {
        return screensOpened > 0;
    }
}

