/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.gui.widget;

import com.github.burgerguy.hudtweaks.gui.widget.ValueUpdatable;
import com.github.burgerguy.hudtweaks.util.UnmodifiableMergedList;
import com.github.burgerguy.hudtweaks.util.Util;
import com.github.burgerguy.hudtweaks.util.gl.GLUtil;
import com.github.burgerguy.hudtweaks.util.gui.ScrollableWrapperElement;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4893;

public class SidebarWidget
extends class_362
implements class_4068,
class_4893 {
    private static final int CUTOFF_FROM_BOTTOM = 25;
    private static final int SCROLLBAR_WIDTH = 2;
    private static final int SCROLLBAR_COLOR_1 = 0x20A0A0A0;
    private static final int SCROLLBAR_COLOR_2 = -1872797857;
    private static final int SCROLL_PIXEL_MULTIPLIER = 8;
    private final List<class_364> globalElements = new ArrayList<class_364>();
    private final List<class_4068> globalDrawables = new ArrayList<class_4068>();
    private final List<class_364> elements = new ArrayList<class_364>();
    private final List<class_4068> drawables = new ArrayList<class_4068>();
    private final class_437 parentScreen;
    public int width;
    public int color;
    private IntSupplier optionsHeightSupplier;
    private double scrolledDist;

    public SidebarWidget(class_437 parentScreen, int width, int color) {
        this.parentScreen = parentScreen;
        this.width = width;
        this.color = color;
    }

    public void addDrawable(class_4068 drawable) {
        this.drawables.add(drawable);
        if (drawable instanceof class_364) {
            this.elements.add(new ScrollableWrapperElement((class_364)drawable, () -> this.scrolledDist));
        }
    }

    public void clearDrawables() {
        class_364 focused = this.method_25399();
        if (focused != null && this.elements.contains(focused)) {
            while (focused.method_25407(true)) {
            }
            this.method_25395(null);
        }
        this.drawables.clear();
        this.elements.clear();
    }

    public void addGlobalDrawable(class_4068 drawable) {
        this.globalDrawables.add(drawable);
        if (drawable instanceof class_364) {
            this.globalElements.add((class_364)drawable);
        }
    }

    public void clearGlobalDrawables() {
        class_364 focused = this.method_25399();
        if (focused != null && this.globalElements.contains(focused)) {
            while (focused.method_25407(true)) {
            }
            this.method_25395(null);
        }
        this.globalDrawables.clear();
        this.globalElements.clear();
    }

    public void setSidebarOptionsHeightSupplier(IntSupplier optionsHeightSupplier) {
        this.optionsHeightSupplier = optionsHeightSupplier;
        this.updateScrolledDist();
    }

    public void updateScrolledDist() {
        this.scrolledDist = this.optionsHeightSupplier != null ? Util.minClamp(this.scrolledDist, 0.0, this.optionsHeightSupplier.getAsInt() - this.parentScreen.field_22790 + 25) : 0.0;
    }

    public List<? extends class_364> method_25396() {
        return new UnmodifiableMergedList(this.globalElements, this.elements);
    }

    public void updateValues() {
        for (class_4068 drawable : this.drawables) {
            if (!(drawable instanceof ValueUpdatable)) continue;
            ((ValueUpdatable)drawable).updateValue();
        }
        for (class_4068 drawable : this.globalDrawables) {
            if (!(drawable instanceof ValueUpdatable)) continue;
            ((ValueUpdatable)drawable).updateValue();
        }
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        class_332.method_25294((class_4587)matrixStack, (int)0, (int)0, (int)this.width, (int)this.parentScreen.field_22790, (int)this.color);
        double optionsVisibleHeight = this.parentScreen.field_22790 - 25;
        if (optionsVisibleHeight > 0.0) {
            double optionsFullHeight;
            boolean scrollable = false;
            boolean matrixPushed = false;
            if (this.optionsHeightSupplier != null && optionsVisibleHeight < (optionsFullHeight = (double)this.optionsHeightSupplier.getAsInt())) {
                double scale = class_310.method_1551().method_22683().method_4495();
                int x = this.width - 2;
                GLUtil.drawFillColor(matrixStack, x, 0.0, x + 2, optionsVisibleHeight, 0x20A0A0A0);
                GLUtil.drawFillColor(matrixStack, x, this.scrolledDist / optionsFullHeight * optionsVisibleHeight, x + 2, (optionsVisibleHeight + this.scrolledDist) / optionsFullHeight * optionsVisibleHeight, -1872797857);
                RenderSystem.enableScissor((int)0, (int)((int)(25.0 * scale)), (int)((int)((double)this.width * scale)), (int)((int)(optionsVisibleHeight * scale)));
                scrollable = true;
                if (this.scrolledDist > 0.0) {
                    matrixStack.method_22903();
                    matrixStack.method_22904(0.0, -this.scrolledDist, 0.0);
                    matrixPushed = true;
                }
            }
            for (class_4068 drawable : this.drawables) {
                drawable.method_25394(matrixStack, mouseX, scrollable ? (int)((double)mouseY + this.scrolledDist) : mouseY, delta);
            }
            if (scrollable) {
                if (matrixPushed) {
                    matrixStack.method_22909();
                }
                RenderSystem.disableScissor();
            }
        }
        for (class_4068 drawable : this.globalDrawables) {
            drawable.method_25394(matrixStack, mouseX, mouseY, delta);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_364 lastFocused;
        class_364 clickedElement = null;
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25402(mouseX, mouseY, button)) continue;
            clickedElement = class_3642;
            break;
        }
        if ((lastFocused = this.method_25399()) != null && !lastFocused.equals(clickedElement)) {
            while (lastFocused.method_25407(true)) {
            }
        }
        this.method_25395(clickedElement);
        if (clickedElement != null) {
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return this.method_25405(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        boolean childScrolled = super.method_25401(mouseX, mouseY, amount);
        if (childScrolled) {
            return true;
        }
        if (this.optionsHeightSupplier == null || mouseY > (double)(this.parentScreen.field_22790 - 25)) {
            return false;
        }
        this.scrolledDist = Util.minClamp(this.scrolledDist - amount * 8.0, 0.0, this.optionsHeightSupplier.getAsInt() - this.parentScreen.field_22790 + 25);
        return true;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= 0.0 && mouseX <= (double)this.width && mouseY >= 0.0 && mouseY <= (double)this.parentScreen.field_22790;
    }

    public void method_25393() {
        for (class_4068 drawable : this.drawables) {
            if (drawable instanceof class_4893) {
                ((class_4893)drawable).method_25393();
            }
            if (!(drawable instanceof class_342)) continue;
            ((class_342)drawable).method_1865();
        }
        for (class_4068 drawable : this.globalDrawables) {
            if (drawable instanceof class_4893) {
                ((class_4893)drawable).method_25393();
            }
            if (!(drawable instanceof class_342)) continue;
            ((class_342)drawable).method_1865();
        }
    }
}

