/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.gui.widget;

import com.github.burgerguy.hudtweaks.gui.widget.HTButtonWidget;
import com.github.burgerguy.hudtweaks.hud.HudContainer;
import com.github.burgerguy.hudtweaks.hud.XAxisNode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class XAxisParentButtonWidget
extends HTButtonWidget {
    private final Consumer<XAxisNode> onClick;
    private final Map<String, XAxisNode> innerMap = new LinkedHashMap<String, XAxisNode>();
    private final String[] keyHelper;
    private int currentIndex;

    public XAxisParentButtonWidget(int x, int y, int width, int height, XAxisNode currentParentNode, XAxisNode thisNode, Consumer<XAxisNode> onClick) {
        super(x, y, width, height, XAxisParentButtonWidget.createMessage(currentParentNode));
        this.recurseAddNode(HudContainer.getScreenRoot(), thisNode);
        this.keyHelper = this.innerMap.keySet().toArray(new String[this.innerMap.size()]);
        while (this.currentIndex < this.keyHelper.length && !this.keyHelper[this.currentIndex].equals(currentParentNode.getIdentifier())) {
            ++this.currentIndex;
        }
        this.onClick = onClick;
    }

    private void recurseAddNode(XAxisNode node, XAxisNode exclude) {
        if (!node.equals(exclude)) {
            this.innerMap.put(node.getIdentifier(), node);
            for (XAxisNode child : node.getXChildren()) {
                this.recurseAddNode(child, exclude);
            }
        }
    }

    public void method_25306() {
        if (++this.currentIndex >= this.keyHelper.length) {
            this.currentIndex = 0;
        }
        XAxisNode newParentNode = this.innerMap.get(this.keyHelper[this.currentIndex]);
        this.setMessage(newParentNode);
        this.onClick.accept(newParentNode);
    }

    private static class_2561 createMessage(XAxisNode node) {
        return new class_2588("hudtweaks.options.parent.display", new Object[]{node.getIdentifier()});
    }

    public void setMessage(XAxisNode node) {
        this.method_25355(XAxisParentButtonWidget.createMessage(node));
    }
}

