/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.gui.widget;

import com.github.burgerguy.hudtweaks.gui.widget.HTButtonWidget;
import com.github.burgerguy.hudtweaks.hud.HudContainer;
import com.github.burgerguy.hudtweaks.hud.YAxisNode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class YAxisParentButtonWidget
extends HTButtonWidget {
    private final Consumer<YAxisNode> onClick;
    private final Map<String, YAxisNode> innerMap = new LinkedHashMap<String, YAxisNode>();
    private final String[] keyHelper;
    private int currentIndex;

    public YAxisParentButtonWidget(int x, int y, int width, int height, YAxisNode currentParentNode, YAxisNode thisNode, Consumer<YAxisNode> onClick) {
        super(x, y, width, height, YAxisParentButtonWidget.createMessage(currentParentNode));
        this.recurseAddNode(HudContainer.getScreenRoot(), thisNode);
        this.keyHelper = this.innerMap.keySet().toArray(new String[this.innerMap.size()]);
        while (this.currentIndex < this.keyHelper.length && !this.keyHelper[this.currentIndex].equals(currentParentNode.getIdentifier())) {
            ++this.currentIndex;
        }
        this.onClick = onClick;
    }

    private void recurseAddNode(YAxisNode node, YAxisNode exclude) {
        if (!node.equals(exclude)) {
            this.innerMap.put(node.getIdentifier(), node);
            for (YAxisNode child : node.getYChildren()) {
                this.recurseAddNode(child, exclude);
            }
        }
    }

    public void method_25306() {
        if (++this.currentIndex >= this.keyHelper.length) {
            this.currentIndex = 0;
        }
        YAxisNode newParentNode = this.innerMap.get(this.keyHelper[this.currentIndex]);
        this.setMessage(newParentNode);
        this.onClick.accept(newParentNode);
    }

    private static class_2561 createMessage(YAxisNode node) {
        return new class_2588("hudtweaks.options.parent.display", new Object[]{node.getIdentifier()});
    }

    public void setMessage(YAxisNode node) {
        this.method_25355(YAxisParentButtonWidget.createMessage(node));
    }
}

