/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.hud;

import com.github.burgerguy.hudtweaks.hud.UpdateEvent;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4061;
import net.minecraft.class_5134;
import net.minecraft.class_746;

public enum DefaultUpdateEvents {

    public static final Set<UpdateEvent> EVENTS = ImmutableSet.of((Object)new UpdateEvent(){

        @Override
        public String getIdentifier() {
            return "onRender";
        }

        @Override
        public boolean shouldUpdate(class_310 client) {
            return true;
        }
    }, (Object)new UpdateEvent(){
        private int lastWidth;
        private int lastHeight;

        @Override
        public String getIdentifier() {
            return "onScreenBoundsChange";
        }

        @Override
        public boolean shouldUpdate(class_310 client) {
            int scaledWidth = client.method_22683().method_4486();
            int scaledHeight = client.method_22683().method_4502();
            if (scaledWidth != this.lastWidth || scaledHeight != this.lastHeight) {
                this.lastWidth = scaledWidth;
                this.lastHeight = scaledHeight;
                return true;
            }
            return false;
        }
    }, (Object)new UpdateEvent(){
        private boolean lastOffhandStatus;

        @Override
        public String getIdentifier() {
            return "onOffhandStatusChange";
        }

        @Override
        public boolean shouldUpdate(class_310 client) {
            boolean offhandStatus;
            class_1297 cameraEntity = client.method_1560();
            if (cameraEntity != null && cameraEntity instanceof class_1657 && (offhandStatus = ((class_1657)cameraEntity).method_6079().method_7960()) != this.lastOffhandStatus) {
                this.lastOffhandStatus = offhandStatus;
                return true;
            }
            return false;
        }
    }, (Object)new UpdateEvent(){
        private int lastHealthRows;

        @Override
        public String getIdentifier() {
            return "onHealthRowsChange";
        }

        @Override
        public boolean shouldUpdate(class_310 client) {
            int absorption;
            double maxHealth;
            int healthRows;
            class_746 playerEntity = client.field_1724;
            if (playerEntity != null && (healthRows = class_3532.method_15384((double)(((maxHealth = playerEntity.method_26825(class_5134.field_23716)) + (double)(absorption = class_3532.method_15386((float)playerEntity.method_6067()))) / 2.0 / 10.0))) != this.lastHealthRows) {
                this.lastHealthRows = healthRows;
                return true;
            }
            return false;
        }
    }, (Object)new UpdateEvent(){
        private int lastRidingHealthRows;

        @Override
        public String getIdentifier() {
            return "onRidingHealthRowsChange";
        }

        @Override
        public boolean shouldUpdate(class_310 client) {
            int ridingHeartCount;
            int ridingHealthRows;
            class_1309 livingEntity;
            class_1297 ridingEntity;
            class_1297 cameraEntity = client.method_1560();
            if (cameraEntity != null && cameraEntity instanceof class_1657 && (ridingEntity = cameraEntity.method_5854()) != null && ridingEntity instanceof class_1309 && (livingEntity = (class_1309)ridingEntity).method_5709() && (ridingHealthRows = (int)Math.ceil((double)(ridingHeartCount = class_3532.method_15340((int)((int)(livingEntity.method_6063() + 0.5f) / 2), (int)0, (int)30)) / 10.0)) != this.lastRidingHealthRows) {
                this.lastRidingHealthRows = ridingHealthRows;
                return true;
            }
            return false;
        }
    }, (Object)new UpdateEvent(){
        private class_1291[] lastStatusEffects;

        @Override
        public String getIdentifier() {
            return "onStatusEffectsChange";
        }

        @Override
        public boolean shouldUpdate(class_310 client) {
            class_746 playerEntity = client.field_1724;
            if (playerEntity != null) {
                Collection effectInstances = playerEntity.method_6026();
                Object[] statusEffects = new class_1291[effectInstances.size()];
                int i = 0;
                for (class_1293 effectInstance : effectInstances) {
                    statusEffects[i++] = effectInstance.method_5579();
                }
                if (this.lastStatusEffects == null || !Arrays.deepEquals(this.lastStatusEffects, statusEffects)) {
                    this.lastStatusEffects = statusEffects;
                    return true;
                }
            }
            return false;
        }
    }, (Object[])new UpdateEvent[]{new UpdateEvent(){
        private class_4061 lastIndicator;

        @Override
        public String getIdentifier() {
            return "onHotbarAttackIndicatorChange";
        }

        @Override
        public boolean shouldUpdate(class_310 client) {
            class_4061 currentIndicator = client.field_1690.field_1895;
            if (this.lastIndicator == null || !currentIndicator.equals((Object)this.lastIndicator) && (currentIndicator.equals((Object)class_4061.field_18153) || this.lastIndicator.equals((Object)class_4061.field_18153))) {
                this.lastIndicator = currentIndicator;
                return true;
            }
            return false;
        }
    }});
}

