/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.hud;

import com.github.burgerguy.hudtweaks.hud.MatrixCache;
import com.github.burgerguy.hudtweaks.hud.RelativeTreeRootScreen;
import com.github.burgerguy.hudtweaks.hud.UpdateEventRegistry;
import com.github.burgerguy.hudtweaks.hud.element.AirElement;
import com.github.burgerguy.hudtweaks.hud.element.ArmorElement;
import com.github.burgerguy.hudtweaks.hud.element.ExperienceBarElement;
import com.github.burgerguy.hudtweaks.hud.element.HealthElement;
import com.github.burgerguy.hudtweaks.hud.element.HotbarElement;
import com.github.burgerguy.hudtweaks.hud.element.HudElement;
import com.github.burgerguy.hudtweaks.hud.element.HungerElement;
import com.github.burgerguy.hudtweaks.hud.element.JumpBarElement;
import com.github.burgerguy.hudtweaks.hud.element.MountHealthElement;
import com.github.burgerguy.hudtweaks.hud.element.StatusEffectsElement;
import com.github.burgerguy.hudtweaks.util.Util;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public enum HudContainer {

    private static final Map<String, HudElement> ELEMENT_MAP = new HashMap<String, HudElement>();
    private static final transient MatrixCache MATRIX_CACHE = new MatrixCache();
    private static final transient UpdateEventRegistry EVENT_REGISTRY = new UpdateEventRegistry();
    private static final transient RelativeTreeRootScreen SCREEN_ROOT = new RelativeTreeRootScreen();

    public static void init() {
        HotbarElement hotbar = new HotbarElement();
        HudContainer.addElement(hotbar.getIdentifier(), hotbar);
        ExperienceBarElement expBar = new ExperienceBarElement();
        HudContainer.addElement(expBar.getIdentifier(), expBar);
        JumpBarElement jumpBar = new JumpBarElement();
        HudContainer.addElement(jumpBar.getIdentifier(), jumpBar);
        ArmorElement armor = new ArmorElement();
        HudContainer.addElement(armor.getIdentifier(), armor);
        HealthElement health = new HealthElement();
        HudContainer.addElement(health.getIdentifier(), health);
        HungerElement hunger = new HungerElement();
        HudContainer.addElement(hunger.getIdentifier(), hunger);
        MountHealthElement mountHealth = new MountHealthElement();
        HudContainer.addElement(mountHealth.getIdentifier(), mountHealth);
        AirElement air = new AirElement();
        HudContainer.addElement(air.getIdentifier(), air);
        StatusEffectsElement statusEffects = new StatusEffectsElement();
        HudContainer.addElement(statusEffects.getIdentifier(), statusEffects);
    }

    public static HudElement getElement(String identifier) {
        return ELEMENT_MAP.get(identifier);
    }

    public static Collection<HudElement> getElements() {
        return ELEMENT_MAP.values();
    }

    public static void addElement(String identifier, HudElement element) {
        if (!identifier.equals("screen")) {
            ELEMENT_MAP.put(identifier, element);
        } else {
            Util.LOGGER.error("Failed to add element: identifier \"screen\" is reserved");
        }
    }

    public static void addElementIfAbsent(String identifier, HudElement element) {
        if (!identifier.equals("screen")) {
            ELEMENT_MAP.putIfAbsent(identifier, element);
        } else {
            Util.LOGGER.error("Failed to add element: identifier \"screen\" is reserved");
        }
    }

    public static Map<String, HudElement> getElementMap() {
        return ELEMENT_MAP;
    }

    public static MatrixCache getMatrixCache() {
        return MATRIX_CACHE;
    }

    public static RelativeTreeRootScreen getScreenRoot() {
        return SCREEN_ROOT;
    }

    public static UpdateEventRegistry getEventRegistry() {
        return EVENT_REGISTRY;
    }

    public static void updateFromJson(JsonElement json) {
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            try {
                HudContainer.getElement((String)entry.getKey()).updateFromJson((JsonElement)entry.getValue());
            }
            catch (NullPointerException e) {
                Util.LOGGER.error("Element specified in config doesn't exist in element map, skipping...", (Throwable)e);
            }
        }
    }
}

