/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.hud;

import com.github.burgerguy.hudtweaks.hud.HudContainer;
import com.github.burgerguy.hudtweaks.hud.UpdateEvent;
import com.github.burgerguy.hudtweaks.hud.XAxisNode;
import com.github.burgerguy.hudtweaks.hud.YAxisNode;
import com.github.burgerguy.hudtweaks.util.Util;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public abstract class RelativeTreeNode
implements XAxisNode,
YAxisNode {
    private final transient String identifier;
    protected final transient Set<UpdateEvent> updateEvents = new HashSet<UpdateEvent>();
    protected transient XAxisNode xParent;
    protected transient YAxisNode yParent;
    protected final transient Set<XAxisNode> xChildren = new HashSet<XAxisNode>();
    protected final transient Set<YAxisNode> yChildren = new HashSet<YAxisNode>();
    private transient boolean requiresUpdate;

    public RelativeTreeNode(String identifier, String ... updateEvents) {
        this.identifier = identifier;
        for (String eventIdentifier : updateEvents) {
            UpdateEvent event = HudContainer.getEventRegistry().get(eventIdentifier);
            if (event == null) continue;
            this.updateEvents.add(event);
        }
        this.moveXUnder(HudContainer.getScreenRoot());
        this.moveYUnder(HudContainer.getScreenRoot());
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public XAxisNode getXParent() {
        return this.xParent;
    }

    @Override
    public YAxisNode getYParent() {
        return this.yParent;
    }

    @Override
    public Set<XAxisNode> getXChildren() {
        return this.xChildren;
    }

    @Override
    public Set<YAxisNode> getYChildren() {
        return this.yChildren;
    }

    @Override
    public void moveXUnder(XAxisNode newXParent) {
        if (this.xParent != null) {
            if (newXParent.equals(this.xParent)) {
                return;
            }
            this.xParent.getXChildren().remove(this);
        }
        newXParent.getXChildren().add(this);
        this.xParent = newXParent;
        this.requiresUpdate = true;
    }

    @Override
    public void moveYUnder(YAxisNode newYParent) {
        if (this.yParent != null) {
            if (newYParent.equals(this.yParent)) {
                return;
            }
            this.yParent.getYChildren().remove(this);
        }
        newYParent.getYChildren().add(this);
        this.yParent = newYParent;
        this.requiresUpdate = true;
    }

    @Override
    public void tryUpdateX(@Nullable UpdateEvent event, class_310 client, boolean parentUpdated, Set<XAxisNode> updatedElementsX) {
        boolean selfUpdated = false;
        if (!updatedElementsX.contains(this) && (parentUpdated || this.requiresUpdate || Util.containsNotNull(this.updateEvents, event))) {
            this.updateSelfX(client);
            updatedElementsX.add(this);
            selfUpdated = true;
        }
        for (XAxisNode child : this.xChildren) {
            child.tryUpdateX(event, client, selfUpdated, updatedElementsX);
        }
    }

    @Override
    public void tryUpdateY(@Nullable UpdateEvent event, class_310 client, boolean parentUpdated, Set<YAxisNode> updatedElementsY) {
        boolean selfUpdated = false;
        if (!updatedElementsY.contains(this) && (parentUpdated || this.requiresUpdate || Util.containsNotNull(this.updateEvents, event))) {
            this.updateSelfY(client);
            updatedElementsY.add(this);
            selfUpdated = true;
        }
        for (YAxisNode child : this.yChildren) {
            child.tryUpdateY(event, client, selfUpdated, updatedElementsY);
        }
    }

    public void setRequiresUpdate() {
        this.requiresUpdate = true;
    }

    protected void setUpdated() {
        this.requiresUpdate = false;
    }

    public abstract void updateSelfX(class_310 var1);

    public abstract void updateSelfY(class_310 var1);
}

