/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.hud.element;

import com.github.burgerguy.hudtweaks.gui.widget.HTButtonWidget;
import com.github.burgerguy.hudtweaks.gui.widget.SidebarWidget;
import com.github.burgerguy.hudtweaks.hud.element.HudElement;
import com.google.gson.JsonElement;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_5134;

public class HealthElement
extends HudElement {
    private boolean flipped;

    public HealthElement() {
        super("health", "onHealthRowsChange");
    }

    @Override
    protected double calculateWidth(class_310 client) {
        return 81.0;
    }

    private int getRawHeight(class_310 client) {
        double maxHealth = client.field_1724.method_26825(class_5134.field_23716);
        int absorption = class_3532.method_15386((float)client.field_1724.method_6067());
        int healthRows = class_3532.method_15384((double)((maxHealth + (double)absorption) / 2.0 / 10.0));
        return (healthRows - 1) * Math.max(10 - (healthRows - 2), 3);
    }

    private int getHeartJumpDistance(class_310 client) {
        if (this.flipped || client == null || client.field_1724 == null) {
            return 2;
        }
        int heartsInTopRow = class_3532.method_15384((double)(client.field_1724.method_26825(class_5134.field_23716) / 2.0)) % 10;
        int absorption = class_3532.method_15386((float)client.field_1724.method_6067());
        if (heartsInTopRow == 0) {
            return absorption > 0 ? 0 : 2;
        }
        return heartsInTopRow + absorption > 10 ? 0 : 2;
    }

    @Override
    protected double calculateHeight(class_310 client) {
        if (client == null || client.field_1724 == null) {
            return 9 + this.getHeartJumpDistance(client);
        }
        return this.getRawHeight(client) + 9 + this.getHeartJumpDistance(client);
    }

    @Override
    protected double calculateDefaultX(class_310 client) {
        return client.method_22683().method_4486() / 2 - 91;
    }

    @Override
    protected double calculateDefaultY(class_310 client) {
        return client.method_22683().method_4502() - 39 - (this.flipped || client == null || client.field_1724 == null ? 0 : this.getRawHeight(client)) - this.getHeartJumpDistance(client);
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    @Override
    public void updateFromJson(JsonElement json) {
        super.updateFromJson(json);
        this.setFlipped(json.getAsJsonObject().get("flipped").getAsBoolean());
    }

    @Override
    public void fillSidebar(SidebarWidget sidebar) {
        super.fillSidebar(sidebar);
        sidebar.addDrawable((class_4068)new HTButtonWidget(4, 276, sidebar.width - 8, 14, (class_2561)new class_2588("hudtweaks.options.health.style.display", new Object[]{this.flipped ? class_1074.method_4662((String)"hudtweaks.options.health.style.flipped.display", (Object[])new Object[0]) : class_1074.method_4662((String)"hudtweaks.options.health.style.normal.display", (Object[])new Object[0])})){

            public void method_25306() {
                HealthElement.this.flipped = !HealthElement.this.flipped;
                this.method_25355((class_2561)new class_2588("hudtweaks.options.health.style.display", new Object[]{HealthElement.this.flipped ? class_1074.method_4662((String)"hudtweaks.options.health.style.flipped.display", (Object[])new Object[0]) : class_1074.method_4662((String)"hudtweaks.options.health.style.normal.display", (Object[])new Object[0])}));
                HealthElement.this.setRequiresUpdate();
            }
        });
    }

    @Override
    public int getSidebarOptionsHeight() {
        return super.getSidebarOptionsHeight() + 25;
    }
}

