/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.hud.element;

import com.github.burgerguy.hudtweaks.gui.widget.HTLabelWidget;
import com.github.burgerguy.hudtweaks.gui.widget.HTSliderWidget;
import com.github.burgerguy.hudtweaks.gui.widget.NumberFieldWidget;
import com.github.burgerguy.hudtweaks.gui.widget.PosTypeButtonWidget;
import com.github.burgerguy.hudtweaks.gui.widget.SidebarWidget;
import com.github.burgerguy.hudtweaks.gui.widget.XAxisParentButtonWidget;
import com.github.burgerguy.hudtweaks.gui.widget.YAxisParentButtonWidget;
import com.github.burgerguy.hudtweaks.hud.HudContainer;
import com.github.burgerguy.hudtweaks.hud.RelativeTreeNode;
import com.github.burgerguy.hudtweaks.hud.XAxisNode;
import com.github.burgerguy.hudtweaks.hud.YAxisNode;
import com.github.burgerguy.hudtweaks.hud.element.HudElementWidget;
import com.github.burgerguy.hudtweaks.util.Util;
import com.github.burgerguy.hudtweaks.util.gl.DrawTest;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import org.jetbrains.annotations.Nullable;

public abstract class HudElement
extends RelativeTreeNode {
    protected transient PosType xPosType = PosType.DEFAULT;
    protected transient PosType yPosType = PosType.DEFAULT;
    protected transient double xAnchorPos;
    protected transient double yAnchorPos;
    protected transient double xRelativePos;
    protected transient double yRelativePos;
    protected transient double xOffset;
    protected transient double yOffset;
    protected transient double xScale = 1.0;
    protected transient double yScale = 1.0;
    protected transient double cachedWidth;
    protected transient double cachedHeight;
    protected transient double cachedDefaultX;
    protected transient double cachedDefaultY;
    protected transient double cachedX;
    protected transient double cachedY;
    protected transient HudElementWidget widget;
    protected transient DrawTest drawTest;
    protected transient Boolean drawTestResult;
    protected transient boolean drawTestedSinceClear;

    public HudElement(String identifier, String ... updateEvents) {
        super(identifier, updateEvents);
        RenderSystem.recordRenderCall(() -> {
            this.drawTest = new DrawTest();
        });
    }

    protected abstract double calculateWidth(class_310 var1);

    protected abstract double calculateHeight(class_310 var1);

    protected abstract double calculateDefaultX(class_310 var1);

    protected abstract double calculateDefaultY(class_310 var1);

    @Override
    public double getWidth(class_310 client) {
        return this.cachedWidth;
    }

    @Override
    public double getHeight(class_310 client) {
        return this.cachedHeight;
    }

    public double getDefaultX(class_310 client) {
        return this.cachedDefaultX;
    }

    public double getDefaultY(class_310 client) {
        return this.cachedDefaultY;
    }

    @Override
    public double getX(class_310 client) {
        return this.cachedX;
    }

    @Override
    public double getY(class_310 client) {
        return this.cachedY;
    }

    @Override
    public void updateSelfX(class_310 client) {
        this.cachedWidth = this.calculateWidth(client) * this.xScale;
        this.cachedDefaultX = this.calculateDefaultX(client);
        switch (this.xPosType) {
            case DEFAULT: {
                this.cachedX = this.getDefaultX(client) + this.xOffset;
                break;
            }
            case RELATIVE: {
                this.cachedX = this.getXParent().getWidth(client) * this.xRelativePos + this.xOffset + this.getXParent().getX(client) - this.getWidth(client) * this.xAnchorPos;
                break;
            }
            default: {
                throw new UnsupportedOperationException("how");
            }
        }
    }

    @Override
    public void updateSelfY(class_310 client) {
        this.cachedHeight = this.calculateHeight(client) * this.yScale;
        this.cachedDefaultY = this.calculateDefaultY(client);
        switch (this.yPosType) {
            case DEFAULT: {
                this.cachedY = this.getDefaultY(client) + this.yOffset;
                break;
            }
            case RELATIVE: {
                this.cachedY = this.getYParent().getHeight(client) * this.yRelativePos + this.yOffset + this.getYParent().getY(client) - this.getHeight(client) * this.yAnchorPos;
                break;
            }
            default: {
                throw new UnsupportedOperationException("how");
            }
        }
    }

    public class_1159 createMatrix(class_310 client) {
        class_1159 matrix = class_1159.method_24019((float)((float)this.xScale), (float)((float)this.yScale), (float)1.0f);
        matrix.method_22672(class_1159.method_24021((float)((float)(this.getX(client) * (1.0 / this.xScale) - this.getDefaultX(client))), (float)((float)(this.getY(client) * (1.0 / this.yScale) - this.getDefaultY(client))), (float)1.0f));
        this.setUpdated();
        return matrix;
    }

    public PosType getXPosType() {
        return this.xPosType;
    }

    public PosType getYPosType() {
        return this.yPosType;
    }

    public double getXAnchorPos() {
        return this.xAnchorPos;
    }

    public double getYAnchorPos() {
        return this.yAnchorPos;
    }

    public double getXRelativePos() {
        return this.xRelativePos;
    }

    public double getYRelativePos() {
        return this.yRelativePos;
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public double getXScale() {
        return this.xScale;
    }

    public double getYScale() {
        return this.yScale;
    }

    public void startDrawTest() {
        this.drawTest.start();
    }

    public void endDrawTest() {
        if (this.drawTest.end()) {
            this.drawTestedSinceClear = true;
        }
    }

    public void clearDrawTest() {
        this.drawTestResult = null;
        this.drawTestedSinceClear = false;
    }

    public boolean isRendered() {
        if (!this.drawTestedSinceClear) {
            return false;
        }
        if (this.drawTestResult == null) {
            this.drawTestResult = this.drawTest.getResultSync();
        }
        return this.drawTestResult;
    }

    public void updateFromJson(JsonElement json) {
        String relativeParentIdentifier;
        HudElement parentNode;
        String relativeParentIdentifier2;
        HudElement parentNode2;
        JsonObject elementJson = json.getAsJsonObject();
        JsonObject xPosJson = elementJson.get("xPos").getAsJsonObject();
        JsonElement parentIdentifier = xPosJson.get("parent");
        if (parentIdentifier != null && parentIdentifier.isJsonPrimitive() && parentIdentifier.getAsJsonPrimitive().isString() && (parentNode2 = HudContainer.getElement(relativeParentIdentifier2 = parentIdentifier.getAsString())) != null) {
            this.moveXUnder(parentNode2);
        }
        this.xPosType = (PosType)((Object)Util.GSON.fromJson(xPosJson.get("posType"), PosType.class));
        this.xAnchorPos = xPosJson.get("anchorPos").getAsDouble();
        this.xOffset = xPosJson.get("offset").getAsDouble();
        this.xRelativePos = xPosJson.get("relativePos").getAsDouble();
        JsonObject yPosJson = elementJson.get("yPos").getAsJsonObject();
        parentIdentifier = yPosJson.get("parent");
        if (parentIdentifier != null && parentIdentifier.isJsonPrimitive() && parentIdentifier.getAsJsonPrimitive().isString() && (parentNode = HudContainer.getElement(relativeParentIdentifier = parentIdentifier.getAsString())) != null) {
            this.moveYUnder(parentNode);
        }
        this.yPosType = (PosType)((Object)Util.GSON.fromJson(yPosJson.get("posType"), PosType.class));
        this.yAnchorPos = yPosJson.get("anchorPos").getAsDouble();
        this.yOffset = yPosJson.get("offset").getAsDouble();
        this.yRelativePos = yPosJson.get("relativePos").getAsDouble();
        this.xScale = elementJson.get("xScale").getAsDouble();
        this.yScale = elementJson.get("yScale").getAsDouble();
    }

    public void fillSidebar(SidebarWidget sidebar) {
        XAxisParentButtonWidget xRelativeParentButton = new XAxisParentButtonWidget(4, 35, sidebar.width - 8, 14, this.getXParent(), this, p -> this.moveXUnder((XAxisNode)p));
        YAxisParentButtonWidget yRelativeParentButton = new YAxisParentButtonWidget(4, 143, sidebar.width - 8, 14, this.getYParent(), this, p -> this.moveYUnder((YAxisNode)p));
        xRelativeParentButton.field_22763 = !this.xPosType.equals((Object)PosType.DEFAULT);
        yRelativeParentButton.field_22763 = !this.yPosType.equals((Object)PosType.DEFAULT);
        HTSliderWidget xRelativeSlider = new HTSliderWidget(4, 54, sidebar.width - 8, 14, this.xRelativePos){

            protected void method_25346() {
                this.method_25355((class_2561)new class_2588("hudtweaks.options.relative_pos.display", new Object[]{Util.RELATIVE_POS_FORMATTER.format(this.field_22753)}));
            }

            public void method_25344() {
                HudElement.this.xRelativePos = this.field_22753;
                HudElement.this.setRequiresUpdate();
            }

            @Override
            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                boolean bl;
                boolean bl2 = bl = keyCode == 263;
                if (bl || keyCode == 262) {
                    this.setValue(this.field_22753 + (bl ? -0.001 : 0.001));
                    return true;
                }
                return false;
            }

            @Override
            public void updateValue() {
                this.field_22753 = class_3532.method_15350((double)HudElement.this.xRelativePos, (double)0.0, (double)1.0);
                this.method_25346();
            }
        };
        HTSliderWidget yRelativeSlider = new HTSliderWidget(4, 162, sidebar.width - 8, 14, this.yRelativePos){

            protected void method_25346() {
                this.method_25355((class_2561)new class_2588("hudtweaks.options.relative_pos.display", new Object[]{Util.RELATIVE_POS_FORMATTER.format(this.field_22753)}));
            }

            public void method_25344() {
                HudElement.this.yRelativePos = this.field_22753;
                HudElement.this.setRequiresUpdate();
            }

            @Override
            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                boolean bl;
                boolean bl2 = bl = keyCode == 263;
                if (bl || keyCode == 262) {
                    this.setValue(this.field_22753 + (bl ? -0.001 : 0.001));
                    return true;
                }
                return false;
            }

            @Override
            public void updateValue() {
                this.field_22753 = class_3532.method_15350((double)HudElement.this.yRelativePos, (double)0.0, (double)1.0);
                this.method_25346();
            }
        };
        xRelativeSlider.field_22763 = !this.xPosType.equals((Object)PosType.DEFAULT);
        yRelativeSlider.field_22763 = !this.yPosType.equals((Object)PosType.DEFAULT);
        HTSliderWidget xAnchorSlider = new HTSliderWidget(4, 73, sidebar.width - 8, 14, this.xAnchorPos){

            protected void method_25346() {
                this.method_25355((class_2561)new class_2588("hudtweaks.options.anchor_pos.display", new Object[]{Util.ANCHOR_POS_FORMATTER.format(this.field_22753)}));
            }

            public void method_25344() {
                HudElement.this.xAnchorPos = this.field_22753;
                HudElement.this.setRequiresUpdate();
            }

            @Override
            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                boolean bl;
                boolean bl2 = bl = keyCode == 263;
                if (bl || keyCode == 262) {
                    this.setValue(this.field_22753 + (bl ? -0.001 : 0.001));
                    return true;
                }
                return false;
            }

            @Override
            public void updateValue() {
                this.field_22753 = class_3532.method_15350((double)HudElement.this.xAnchorPos, (double)0.0, (double)1.0);
                this.method_25346();
            }
        };
        HTSliderWidget yAnchorSlider = new HTSliderWidget(4, 181, sidebar.width - 8, 14, this.yAnchorPos){

            protected void method_25346() {
                this.method_25355((class_2561)new class_2588("hudtweaks.options.anchor_pos.display", new Object[]{Util.ANCHOR_POS_FORMATTER.format(this.field_22753)}));
            }

            public void method_25344() {
                HudElement.this.yAnchorPos = this.field_22753;
                HudElement.this.setRequiresUpdate();
            }

            @Override
            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                boolean bl;
                boolean bl2 = bl = keyCode == 263;
                if (bl || keyCode == 262) {
                    this.setValue(this.field_22753 + (bl ? -0.001 : 0.001));
                    return true;
                }
                return false;
            }

            @Override
            public void updateValue() {
                this.field_22753 = class_3532.method_15350((double)HudElement.this.yAnchorPos, (double)0.0, (double)1.0);
                this.method_25346();
            }
        };
        xAnchorSlider.field_22763 = !this.xPosType.equals((Object)PosType.DEFAULT);
        yAnchorSlider.field_22763 = !this.yPosType.equals((Object)PosType.DEFAULT);
        PosTypeButtonWidget xPosTypeButton = new PosTypeButtonWidget(4, 16, sidebar.width - 8, 14, this.xPosType, t -> {
            this.xPosType = t;
            this.setRequiresUpdate();
            xAnchorSlider.field_22763 = !t.equals((Object)PosType.DEFAULT);
            xRelativeSlider.field_22763 = !t.equals((Object)PosType.DEFAULT);
            xRelativeParentButton.field_22763 = !t.equals((Object)PosType.DEFAULT);
        });
        PosTypeButtonWidget yPosTypeButton = new PosTypeButtonWidget(4, 124, sidebar.width - 8, 14, this.yPosType, t -> {
            this.yPosType = t;
            this.setRequiresUpdate();
            yAnchorSlider.field_22763 = !t.equals((Object)PosType.DEFAULT);
            yRelativeSlider.field_22763 = !t.equals((Object)PosType.DEFAULT);
            yRelativeParentButton.field_22763 = !t.equals((Object)PosType.DEFAULT);
        });
        NumberFieldWidget xOffsetField = new NumberFieldWidget(class_310.method_1551().field_1772, 43, 92, sidebar.width - 47, 14, (class_2561)new class_2588("hudtweaks.options.offset.name")){

            @Override
            public void updateValue() {
                this.method_1852(Double.toString(HudElement.this.xOffset));
            }
        };
        xOffsetField.method_1852(Double.toString(this.xOffset));
        xOffsetField.method_1863(s -> {
            if (s.equals("")) {
                this.xOffset = 0.0;
                this.setRequiresUpdate();
            } else {
                try {
                    this.xOffset = Double.parseDouble(s);
                    this.setRequiresUpdate();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        NumberFieldWidget yOffsetField = new NumberFieldWidget(class_310.method_1551().field_1772, 43, 200, sidebar.width - 47, 14, (class_2561)new class_2588("hudtweaks.options.offset.name")){

            @Override
            public void updateValue() {
                this.method_1852(Util.NUM_FIELD_FORMATTER.format(HudElement.this.yOffset));
            }
        };
        yOffsetField.method_1852(Util.NUM_FIELD_FORMATTER.format(this.yOffset));
        yOffsetField.method_1863(s -> {
            if (s.equals("")) {
                this.yOffset = 0.0;
                this.setRequiresUpdate();
            } else {
                try {
                    this.yOffset = Double.parseDouble(s);
                    this.setRequiresUpdate();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        NumberFieldWidget xScaleField = new NumberFieldWidget(class_310.method_1551().field_1772, 48, 232, sidebar.width - 52, 14, (class_2561)new class_2588("hudtweaks.options.x_scale.name")){

            @Override
            public void updateValue() {
                this.method_1852(Util.NUM_FIELD_FORMATTER.format(HudElement.this.xScale));
            }
        };
        xScaleField.method_1852(Util.NUM_FIELD_FORMATTER.format(this.xScale));
        xScaleField.method_1863(s -> {
            if (s.equals("")) {
                this.xScale = 0.0;
                this.setRequiresUpdate();
            } else {
                try {
                    double value = Double.parseDouble(s);
                    double lastValue = this.xScale;
                    double d = this.xScale = value < 0.0 ? 0.0 : value;
                    if (this.xScale != lastValue) {
                        this.setRequiresUpdate();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        NumberFieldWidget yScaleField = new NumberFieldWidget(class_310.method_1551().field_1772, 48, 251, sidebar.width - 52, 14, (class_2561)new class_2588("hudtweaks.options.y_scale.name")){

            @Override
            public void updateValue() {
                this.method_1852(Util.NUM_FIELD_FORMATTER.format(HudElement.this.yScale));
            }
        };
        yScaleField.method_1852(Util.NUM_FIELD_FORMATTER.format(this.yScale));
        yScaleField.method_1863(s -> {
            if (s.equals("")) {
                this.yScale = 0.0;
                this.setRequiresUpdate();
            } else {
                try {
                    double value = Double.parseDouble(s);
                    double lastValue = this.yScale;
                    double d = this.yScale = value < 0.0 ? 0.0 : value;
                    if (this.yScale != lastValue) {
                        this.setRequiresUpdate();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        sidebar.addDrawable((class_4068)xPosTypeButton);
        sidebar.addDrawable((class_4068)xRelativeParentButton);
        sidebar.addDrawable((class_4068)xRelativeSlider);
        sidebar.addDrawable((class_4068)xAnchorSlider);
        sidebar.addDrawable((class_4068)xOffsetField);
        sidebar.addDrawable((class_4068)yPosTypeButton);
        sidebar.addDrawable((class_4068)yRelativeParentButton);
        sidebar.addDrawable((class_4068)yRelativeSlider);
        sidebar.addDrawable((class_4068)yAnchorSlider);
        sidebar.addDrawable((class_4068)yOffsetField);
        sidebar.addDrawable((class_4068)xScaleField);
        sidebar.addDrawable((class_4068)yScaleField);
        sidebar.addDrawable(new HTLabelWidget(class_1074.method_4662((String)"hudtweaks.options.offset.display", (Object[])new Object[0]), 5, 95, -855638017, false));
        sidebar.addDrawable(new HTLabelWidget(class_1074.method_4662((String)"hudtweaks.options.offset.display", (Object[])new Object[0]), 5, 203, -855638017, false));
        sidebar.addDrawable(new HTLabelWidget(class_1074.method_4662((String)"hudtweaks.options.x_pos.display", (Object[])new Object[0]), 5, 5, -860835664, false));
        sidebar.addDrawable(new HTLabelWidget(class_1074.method_4662((String)"hudtweaks.options.y_pos.display", (Object[])new Object[0]), 5, 113, -860835664, false));
        sidebar.addDrawable(new HTLabelWidget(class_1074.method_4662((String)"hudtweaks.options.scale.display", (Object[])new Object[0]), 5, 221, -860835664, false));
        sidebar.addDrawable(new HTLabelWidget(class_1074.method_4662((String)"hudtweaks.options.x_scale.display", (Object[])new Object[0]), 5, 236, -855638017, false));
        sidebar.addDrawable(new HTLabelWidget(class_1074.method_4662((String)"hudtweaks.options.y_scale.display", (Object[])new Object[0]), 5, 254, -855638017, false));
    }

    public int getSidebarOptionsHeight() {
        return 265;
    }

    @Nullable
    public HudElementWidget getWidget() {
        return this.widget;
    }

    public HudElementWidget createWidget(@Nullable Runnable valueUpdater) {
        this.widget = new HudElementWidget(this, valueUpdater);
        return this.widget;
    }

    public static enum PosType {
        DEFAULT,
        RELATIVE;

    }
}

